/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;

public class ApiTokenAdvancedSettings
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final UserLookupService userLookupService;
    private final KssoUpgradeManager kssoUpgradeManager;
    public static final String AUTHORIZATION_KEY = "ksso-token";

    @Inject
    public ApiTokenAdvancedSettings(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.apiTokenService = apiTokenService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostApp();
        this.userLookupService = bucket.getUserLookupService();
        this.kssoUpgradeManager = bucket.getKssoUpgradeManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        String additionalBearerKey = req.getParameter("additional-bearer-key");
        if (additionalBearerKey != null) {
            additionalBearerKey = StringUtils.trim((String)additionalBearerKey);
            additionalBearerKey = StringUtils.replace((String)additionalBearerKey, (String)" ", (String)"-");
            this.kerbConfManager.setAdditionalBearerKey(additionalBearerKey);
        }
        this.buildModelAndRenderTemplate(req, resp);
    }

    private void buildModelAndRenderTemplate(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-advanced-settings.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequestFacade req) {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens-advanced-settings");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("additional-bearer-key", this.kerbConfManager.getAdditionalBearerKey());
        return model;
    }
}

