/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenEntity;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.pagination.Paginator;
import org.kantega.atlaskerb.userlookup.UserLookupService;

public class ApiTokenAdminServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;

    @Inject
    public ApiTokenAdminServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.apiTokenService = apiTokenService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.userLookupService = bucket.getUserLookupService();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-admin.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        HashMap protoModel = HashMap.empty();
        if (!protoModel.isEmpty()) {
            return;
        }
        if ("delete".equals(req.getParameter("operation"))) {
            Option.of((Object)req.getParameter("tokenId")).map(this.apiTokenService::findTokenById).filter(Objects::nonNull).forEach(this.apiTokenService::delete);
            this.buildModelAndRenderTemplate(req, resp, protoModel.toJavaMap());
        } else {
            Option<String> maybeToken = this.apiTokenService.createAndPersistToken(req);
            if (maybeToken.isDefined()) {
                this.buildModelAndRenderTemplate(req, resp, protoModel.merge((Map)protoModel.put((Object)"newApiToken", maybeToken.get())).toJavaMap());
                return;
            }
            this.buildModelAndRenderTemplate(req, resp, protoModel.toJavaMap());
        }
    }

    private void buildModelAndRenderTemplate(HttpServletRequestFacade req, HttpServletResponseFacade resp, java.util.Map<String, Object> protoModel) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-admin.vm", model, (Writer)resp.getWriter());
    }

    private java.util.Map<String, Object> buildModel(HttpServletRequestFacade req) {
        java.util.Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("durationOptions", ApiTokenUtil.DatePair.getDurationOptions());
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        List<ApiTokenUtil.ApiTokenRepresentation> tokens = this.getTokensRepresentation();
        model.put("isEmptyTokens", tokens.isEmpty());
        List<ApiTokenUtil.ApiTokenRepresentation> filteredTokens = this.getFilteredTokens(req, model, tokens);
        Paginator<ApiTokenUtil.ApiTokenRepresentation> paginator = new Paginator<ApiTokenUtil.ApiTokenRepresentation>();
        java.util.Map<String, Object> paginationMap = paginator.handlePagination(req, filteredTokens);
        model.putAll(paginationMap);
        return model;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getFilteredTokens(HttpServletRequestFacade req, java.util.Map<String, Object> model, List<ApiTokenUtil.ApiTokenRepresentation> tokens) {
        boolean filterTokenName;
        ArrayList<ApiTokenUtil.ApiTokenRepresentation> filteredTokens = new ArrayList<ApiTokenUtil.ApiTokenRepresentation>();
        boolean filterExpiredTokens = req.getParameter("tokenActiveFilter") != null && req.getParameter("tokenActiveFilter").equals("true");
        boolean filterNonExpiredTokens = req.getParameter("tokenActiveFilter") != null && req.getParameter("tokenActiveFilter").equals("false");
        boolean filterUsername = req.getParameter("userNameFilter") != null && !req.getParameter("userNameFilter").isEmpty();
        boolean bl = filterTokenName = req.getParameter("tokenNameFilter") != null && !req.getParameter("tokenNameFilter").isEmpty();
        if (filterExpiredTokens) {
            model.put("tokenActiveFilter", true);
        }
        if (filterNonExpiredTokens) {
            model.put("tokenActiveFilter", false);
        }
        if (filterUsername) {
            model.put("userNameFilter", req.getParameter("userNameFilter"));
        }
        if (filterTokenName) {
            model.put("tokenNameFilter", req.getParameter("tokenNameFilter"));
        }
        if (!(filterExpiredTokens || filterNonExpiredTokens || filterUsername || filterTokenName)) {
            filteredTokens.addAll(tokens);
        } else {
            String userNameParam = req.getParameter("userNameFilter");
            String tokenNameParam = req.getParameter("tokenNameFilter");
            for (ApiTokenUtil.ApiTokenRepresentation token : tokens) {
                boolean matchesTokenName;
                boolean isExpired = token.isExpired();
                boolean matchesUser = userNameParam != null && token.getUsername().toUpperCase().contains(userNameParam.toUpperCase());
                boolean bl2 = matchesTokenName = tokenNameParam != null && token.getAlias().toUpperCase().contains(tokenNameParam.toUpperCase());
                if (filterExpiredTokens && isExpired || filterNonExpiredTokens && !isExpired || filterUsername && !matchesUser || filterTokenName && !matchesTokenName) continue;
                filteredTokens.add(token);
            }
        }
        return filteredTokens;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation() {
        return new ArrayList<ApiTokenUtil.ApiTokenRepresentation>(io.vavr.collection.List.ofAll(this.apiTokenService.findAllTokens()).map(t -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenEntity)t, this.userManager, this.apiTokenService)).filter(t -> t.getAlias() != null).asJava());
    }
}

