/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apiserver;

import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.kantegasso.jetty.ContextHandlerCollectionFacade;
import com.kantegasso.jetty.ContextHandlerFacade;
import com.kantegasso.jetty.ServletHandlerFacade;
import com.kantegasso.jetty.ServletHolderFacade;
import com.kantegasso.prometheus.MetricsServletFacade;
import jakarta.inject.Inject;
import jakarta.servlet.Servlet;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apiserver.ApiServerConfigState;
import org.kantega.atlaskerb.config.ConfigNameSpaces;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.azure.AzureConnectorPropUtil;
import org.kantega.atlaskerb.connector.crowdserver.CrowdApiHandler;
import org.kantega.atlaskerb.connector.crowdserver.CrowdServlet;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.scim.AtlScimServlet;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiServer
implements InitializingBean,
DisposableBean {
    private final ScimConfManager scimConfManager;
    private final ConnectorConfManager connectorConfManager;
    private final ApiServerConfManager apiServerConfManager;
    private final HostApp hostApp;
    private final PluginLicenseManager pluginLicenseManager;
    private volatile Server server;
    private volatile Exception startException;
    private volatile ApiServerConfigState config;
    private static final Logger log = LoggerFactory.getLogger(ApiServer.class);
    private final TransactionTemplate transactionTemplate;
    private final PluginAccessor pluginAccessor;
    private AzureConnectorPropUtil azureConnectorPropUtil;

    @Inject
    public ApiServer(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport PluginAccessor pluginAccessor, ScimConfManager scimConfManager, ConnectorConfManager connectorConfManager, ApiServerConfManager apiServerConfManager, HostAppFactory hostAppFactory) {
        this.scimConfManager = scimConfManager;
        this.connectorConfManager = connectorConfManager;
        this.apiServerConfManager = apiServerConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.pluginLicenseManager = pluginLicenseManager;
        this.transactionTemplate = transactionTemplate;
        this.pluginAccessor = pluginAccessor;
    }

    @Autowired
    public void setAzureConnectorPropUtil(AzureConnectorPropUtil azureConnectorPropUtil) {
        this.azureConnectorPropUtil = azureConnectorPropUtil;
    }

    private void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
                this.startException = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this.stop();
    }

    public void afterPropertiesSet() {
        this.configChanged(this.apiServerConfManager.getConfig());
    }

    public void configChanged(ApiServerConfigState config) {
        if (this.config == null || !this.config.isCurrent(config.getStateId())) {
            this.config = config;
            if (this.server != null) {
                this.stop();
            }
            this.server = null;
            if (config.isEnabled()) {
                try {
                    Server server = new Server(new InetSocketAddress(config.getAddress(), config.getPort()));
                    ContextHandlerFacade crowdContext = this.initCrowdContext();
                    ContextHandlerFacade scimContext = this.initScimContext();
                    ContextHandlerFacade promContext = this.initPrometheusContext();
                    ContextHandlerCollectionFacade contextHandlerCollection = ContextHandlerCollectionFacade.ofHandlers((ServletContextHandler[])new ServletContextHandler[]{crowdContext.getServletContextHandler(), scimContext.getServletContextHandler(), promContext.getServletContextHandler()});
                    server.setHandler((Handler)contextHandlerCollection);
                    server.start();
                    this.server = server;
                    this.startException = null;
                }
                catch (Exception e) {
                    this.startException = e;
                    log.error("Failed starting Jetty on " + config.getAddress() + ":" + config.getPort(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public Exception getStartException() {
        return this.startException;
    }

    public ApiServerConfigState getConfig() {
        return this.config;
    }

    public void restoreSettings(Set<ConfigNameSpaces.ConfigSubset> configOptions) {
        if (configOptions == null) {
            return;
        }
        if (configOptions.contains((Object)ConfigNameSpaces.ConfigSubset.CLOUD_USER_PROVISIONING)) {
            List<com.atlassian.crowd.embedded.api.Directory> needsUpdate = this.findConnectorDirectoriesToUpdate();
            this.configChanged(this.apiServerConfManager.getConfig());
            this.updateConnectorDirectories(needsUpdate, this.apiServerConfManager.getCrowdServerUrl());
        }
    }

    public void updateConnectorDirectories(List<com.atlassian.crowd.embedded.api.Directory> needsUpdate, String serverURL) {
        for (com.atlassian.crowd.embedded.api.Directory directory : needsUpdate) {
            this.transactionTemplate.execute(() -> {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((com.atlassian.crowd.embedded.api.Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                attrs.put("crowd.server.url", serverURL);
                builder.setAttributes(attrs);
                com.atlassian.crowd.embedded.api.Directory updatedDirectory = builder.toDirectory();
                return this.hostApp.getCrowdDirectoryService().updateDirectory(updatedDirectory);
            });
        }
    }

    public List<com.atlassian.crowd.embedded.api.Directory> findConnectorDirectoriesToUpdate() {
        ArrayList<com.atlassian.crowd.embedded.api.Directory> result = new ArrayList<com.atlassian.crowd.embedded.api.Directory>();
        String serverURL = this.apiServerConfManager.getCrowdServerUrl();
        for (Directory directory : this.connectorConfManager.getDirectories()) {
            com.atlassian.crowd.embedded.api.Directory cwd = new CrowdDirectoryFinder(this.hostApp).findDirectory(directory.getId());
            if (cwd == null || !serverURL.equals(cwd.getAttributes().get("crowd.server.url"))) continue;
            result.add(cwd);
        }
        return result;
    }

    private ContextHandlerFacade initPrometheusContext() throws Exception {
        ContextHandlerFacade ctx = ContextHandlerFacade.ofServletContextHandler((String)"/metrics");
        MetricsServletFacade servlet = new MetricsServletFacade();
        ServletHandlerFacade servlethandler = new ServletHandlerFacade();
        servlethandler.addServletWithMapping(new ServletHolderFacade((Servlet)servlet.getMetricsServlet()), "/*");
        ctx.insertServletHandler((ServletHandler)servlethandler);
        servlethandler.initialize();
        return ctx;
    }

    private ContextHandlerFacade initScimContext() throws Exception {
        ContextHandlerFacade ctx = ContextHandlerFacade.ofServletContextHandler((String)"/scim");
        AtlScimServlet servlet = new AtlScimServlet(this.scimConfManager, this.pluginLicenseManager, true);
        ServletHandlerFacade servlethandler = new ServletHandlerFacade();
        servlethandler.addServletWithMapping(new ServletHolderFacade((Servlet)servlet), "/*");
        ctx.insertServletHandler((ServletHandler)servlethandler);
        servlethandler.initialize();
        return ctx;
    }

    private ContextHandlerFacade initCrowdContext() {
        ContextHandlerFacade sch = ContextHandlerFacade.ofServletContextHandler((String)"/rest");
        CrowdServlet crowdServlet = new CrowdServlet(true);
        CrowdApiHandler servletHandler = new CrowdApiHandler(this.connectorConfManager, this.hostApp, this.pluginLicenseManager, this.pluginAccessor);
        servletHandler.addServletWithMapping(new ServletHolderFacade((Servlet)crowdServlet), "/*");
        servletHandler.setAzureConnectorPropUtil(this.azureConnectorPropUtil);
        sch.insertServletHandler((ServletHandler)servletHandler);
        return sch;
    }
}

