/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.web.context.HttpContext;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.CookieFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.cache.LastUserAgentsCache;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.diagnostics.FailureListener;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.intercept.filter.RequestInterceptor;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.intercept.model.Intercept;
import org.kantega.atlaskerb.intercept.model.InterceptExitCondition;
import org.kantega.atlaskerb.intercept.model.InterceptResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SsoScriptLoginHookUrlReadingCondition;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ContextAware;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.kantega.atlaskerb.wrapper.webresource.WebResourceManagerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class AtlasKerberosMainAuthFilter
extends FilterFacade {
    public static final String LOCKOUT_TIMESTAMP = "lockout_timestamp";
    public static final String USERNAME_ANONYMOUS_USER = "usernameAnonymousUser";
    private static final Logger log = LoggerFactory.getLogger(AtlasKerberosMainAuthFilter.class);
    private static final String ALREADY_MATCHED_ATTR = AtlasKerberosMainAuthFilter.class.getName() + "_alreadyMatched";
    private final KerbConfManager kerbConfManager;
    private final AuditLogFacade auditLogFacade;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final SsoScriptLoginHookUrlReadingCondition loginScriptCondition;
    private final UserLookupService userLookupService;
    private final WebResourceManagerWrapper webResourceManager;
    private String[] products;
    private final RequestInterceptor requestInterceptor;
    private final LastUserAgentsCache lastUserAgentsCache;

    @Inject
    public AtlasKerberosMainAuthFilter(@ComponentImport HttpContext httpContext, WebResourceManagerWrapper webResourceManager, FailureListener failureListener, AuditLogFacade auditLogFacade, RequireAdminServletDependencyBucket bucket, SsoScriptLoginHookUrlReadingCondition ssoScriptLoginHookUrlReadingCondition, LastUserAgentsCache lastUserAgentsCache) {
        this.kerbConfManager = bucket.getKerbConfManager();
        this.auditLogFacade = auditLogFacade;
        this.userLookupService = bucket.getUserLookupService();
        this.webResourceManager = webResourceManager;
        this.hostApp = bucket.getHostApp();
        this.idpConfManager = bucket.getIdpConfManager();
        this.loginScriptCondition = ssoScriptLoginHookUrlReadingCondition;
        this.requestInterceptor = new RequestInterceptor(httpContext, failureListener, auditLogFacade, bucket, ssoScriptLoginHookUrlReadingCondition);
        this.lastUserAgentsCache = lastUserAgentsCache;
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    public void doFilterKsso(HttpServletRequestFacade request, HttpServletResponseFacade response, FilterChainFacade chain) throws IOException {
        HttpServletRequestFacade req = HttpServletRequestFacade.of((HttpServletRequest)request);
        HttpServletResponseFacade res = HttpServletResponseFacade.of((HttpServletResponse)response);
        boolean alreadyMatched = req.getAttribute(ALREADY_MATCHED_ATTR) != null;
        String requestURI = req.getRequestURI();
        boolean isLoginPage = this.hostApp.isPageWithLoginForm(req);
        this.toggleKerberosSessionFromQueryString(req);
        if (alreadyMatched && !this.isForwarded(req) || !this.isProductMatch()) {
            log.trace("Already matched request, !isForwarded and !isProductMatch. Passing filter down chain");
            chain.doFilterKsso(request, response);
            return;
        }
        String userAgent = req.getHeader("User-Agent");
        if (this.kerbConfManager.isCollectUserAgentsEnabled()) {
            this.lastUserAgentsCache.put(userAgent);
        }
        AtlasKerberosMainAuthFilter.logRequestDetails(req, userAgent);
        req.setAttribute(ALREADY_MATCHED_ATTR, (Object)Boolean.TRUE);
        if (isLoginPage && TraditionalLoginUtils.shouldTraditionalLoginBePreventedForThisPage(this.kerbConfManager, this.userLookupService, this.hostApp, req) && !this.isForceUIForTest(req)) {
            log.trace("Including disabling-login elements in page since traditional login is disabled for {}", (Object)requestURI);
            if (this.hostApp.shouldUseLegacyLoginExperience()) {
                this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-disable-legacy-login");
            } else {
                this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-disable-login");
            }
        }
        if (!this.isMappedRequest(req, res)) {
            log.trace("Request for {} is not mapped for further processing. Passing down filter chain", (Object)requestURI);
            chain.doFilterKsso(request, response);
            return;
        }
        this.addLoginScrips(req);
        this.logAuthorizationHeaders(req);
        this.logSessionAttributes(req);
        this.logForwardedRequest(req);
        log.trace("AtlasKerberosMainAuthFilter processing requestUri {}, method {}", (Object)requestURI, (Object)req.getMethod());
        List<Intercept> interceptOrder = Collections.unmodifiableList(Arrays.asList(Intercept.REST_API_ACCESS, Intercept.ALREADY_LOGGED_IN, Intercept.LICENSE, Intercept.ANONYMOUS_BROWSING, Intercept.USERNAME_FROM_HEADER, Intercept.API_TOKEN, Intercept.OTHER_AUTH_TOKEN, Intercept.HANDLE_TRADITIONAL_LOGIN, Intercept.KERBEROS, Intercept.FEDERATED_SSO, Intercept.PASS_DOWN_FILTER_CHAIN));
        this.logInterceptOrder(requestURI, interceptOrder);
        InterceptResult interceptResult = this.requestInterceptor.intercept(req, res, interceptOrder);
        log.trace("Intercepted request on URI {} with result {}", (Object)requestURI, (Object)interceptResult);
        switch (interceptResult.getType()) {
            case LOGIN_SUCCESS: {
                this.finishLogin(req, res, chain, interceptResult);
                return;
            }
            case LOGIN_FAILED: {
                this.auditLogFacade.loginFailed((String)interceptResult.getMaybeUsername().getOrElse((Object)"anonymous"), interceptResult.getAuthMethod(), interceptResult.getMessage());
                interceptResult.writeRequestAndResponse(req, res).onFailure(t -> log.warn(ErrorUtils.createErrorMessage((String)"KSSO-2GRKFGW5YE", (String)"Failed to write response: "), t));
                return;
            }
            case PASS_DOWN_FILTER_CHAIN: {
                interceptResult.doFilter(request, response, chain).onFailure(t -> log.error(String.format("Could not pass down custom filter with result %s: %s", new Object[]{interceptResult.getType(), interceptResult.getMessage()}), t)).onFailure(t -> log.debug("Failed to pass down filter chain for user " + (String)interceptResult.getMaybeUsername().getOrElse((Object)"anonymous") + " with result " + String.valueOf((Object)interceptResult.getType()) + " " + interceptResult.getMessage(), t)).getOrElseThrow(t -> new RuntimeException((Throwable)t));
                return;
            }
            case SEND_REDIRECT: {
                Option<String> redirectTarget = interceptResult.getMaybeRedirectTarget();
                if (redirectTarget.isDefined()) {
                    res.sendRedirect((String)redirectTarget.get());
                } else {
                    log.warn(ErrorUtils.createErrorMessage((String)"KSSO-MKKZK2YMWF", (String)("Redirect target not defined for result type: " + String.valueOf((Object)interceptResult.getType()) + ". Passing down filter chain")));
                    chain.doFilterKsso(request, response);
                }
                return;
            }
            case DISPATCH_TO_LOGIN: {
                interceptResult.writeRequestAndResponse(req, res).onFailure(t -> log.warn(ErrorUtils.createErrorMessage((String)"KSSO-T2RJWACUNX", (String)"Failed to write response."), t));
                this.dispatchToLogin(req, res, chain);
                return;
            }
            case NEXT_INTERCEPT: {
                log.warn("KSSO: Ended up in CONTINUE path after all processing in filter. No further processing at this point. Passing down filter chain...");
                chain.doFilterKsso(request, response);
                break;
            }
            default: {
                log.warn(ErrorUtils.createErrorMessage((String)"KSSO-K1DFM4MUTP", (String)"Unexpected value after filter intercept. Passing down filter chain: ") + String.valueOf((Object)interceptResult.getType()));
                chain.doFilterKsso(request, response);
            }
        }
    }

    private static void logRequestDetails(HttpServletRequestFacade req, String userAgent) {
        log.debug("Host:" + req.getRemoteHost() + ", , Request URI: " + HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req) + ", IP address: " + req.getRemoteAddr() + ", X-forwarded-for: " + req.getHeader("x-forwarded-for") + ", User Agent: " + userAgent);
        StringBuilder headers = new StringBuilder();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.append("[").append(headerName).append(": ").append(req.getHeader(headerName)).append("] ");
        }
        log.trace("All headers: " + String.valueOf(headers));
    }

    private void logInterceptOrder(String requestURI, List<Intercept> interceptOrder) {
        log.trace("Intercepting request on" + requestURI + ". Perform the following checks: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List)io.vavr.collection.List.ofAll(interceptOrder).map(Enum::toString), (KssoStringUtils.StringLiteral)KssoStringUtils.StringLiteral.COMMA_AND_SPACE));
    }

    private void finishLogin(HttpServletRequestFacade req, HttpServletResponseFacade res, FilterChainFacade chain, InterceptResult result) throws IOException {
        if (result.getMaybePrincipal().isEmpty()) {
            this.auditLogFacade.loginFailed((String)result.getMaybeUsername().getOrElse((Object)"anonymous"), result.getAuthMethod(), result.getMessage());
            log.error("Unable to finish login. Principal is not set. Passing down filter chain");
            chain.doFilterKsso(req, res);
            return;
        }
        Principal principal = (Principal)result.getMaybePrincipal().get();
        if (result.getType() == InterceptExitCondition.LOGIN_SUCCESS) {
            log.debug("Successful login with {}", (Object)result.getAuthMethod());
            String username = principal.getName();
            if (result.getAuthMethod() == AuthMethod.KERBEROS) {
                this.auditLogFacade.loginSuccess(username, result.getAuthMethod());
                this.finishSuccessfulKerberosLogin(req, res, principal, chain);
            } else if (result.getAuthMethod() == AuthMethod.API_TOKEN) {
                this.auditLogFacade.loginSuccess(username, result.getAuthMethod());
                this.finishSuccessfulApiTokenLogin(req, res, chain, result, principal);
            } else if (result.getAuthMethod() == AuthMethod.USERNAME_FROM_HEADER) {
                this.auditLogFacade.loginSuccess(username, result.getAuthMethod());
                this.hostApp.publishUserAuthenticatedEvent(principal, req, res);
                this.authenticateWithProduct(req, res, principal);
                result.doFilter(req, res, chain).onFailure(t -> log.error("Could not pass down custom filter after successful login...", t)).getOrElseThrow(t -> new RuntimeException((Throwable)t));
            } else {
                log.debug("Incorrect authmethod {}. Passing down filter chain...", (Object)result.getAuthMethod());
                chain.doFilterKsso(req, res);
            }
        } else {
            this.auditLogFacade.loginFailed((String)result.getMaybeUsername().getOrElse((Object)"anonymous"), result.getAuthMethod(), result.getMessage());
            log.warn("Ended up in successful login path with unidentified result {}...", (Object)result);
            log.debug("Passing down filter chain...");
            chain.doFilterKsso(req, res);
        }
    }

    private void finishSuccessfulApiTokenLogin(HttpServletRequestFacade req, HttpServletResponseFacade res, FilterChainFacade chain, InterceptResult result, @NonNull Principal principal) {
        Option<Integer> maybeFailedLoginAttempts = result.getMaybeFailedLoginAttempts();
        this.authenticateWithProduct(req, res, principal);
        maybeFailedLoginAttempts.toTry().peek(failedLoginAttempts -> log.debug("Persisting failed login attempts for {}: {}", (Object)UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal), failedLoginAttempts)).flatMapTry((CheckedFunction1 & Serializable)failedLoginAttempts -> this.hostApp.setFailedLoginAttempts(principal, (int)failedLoginAttempts)).onFailure(e -> log.warn("Failed to persist login attempts during API token authentication:", e));
        result.doFilter(req, res, chain).onFailure(t -> log.error("Could not pass down custom filter after successful login...", t)).getOrElseThrow(t -> new RuntimeException((Throwable)t));
    }

    private void addLoginScrips(HttpServletRequestFacade req) {
        if (this.loginScriptCondition.shouldAddLoginScripts(req)) {
            log.trace("Adding login scripts");
            if (this.hostApp.shouldUseLegacyLoginExperience()) {
                this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-legacy-login");
            } else {
                this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-login");
            }
        }
        if (this.loginScriptCondition.shouldAddMSTeamsScripts(req)) {
            log.trace("Adding MSTeams login scripts");
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-msteams-login");
        }
    }

    private void logSessionAttributes(HttpServletRequestFacade req) {
        if (this.idpConfManager.isIdpSessionActive(req)) {
            log.trace("KSSO session active for user " + (String)Option.of((Object)req.getSession(false).getAttribute("ksso.idp.session.user")).map(String.class::cast).getOrElse((Object)"<anonoymous>"));
        }
    }

    private void logForwardedRequest(HttpServletRequestFacade req) {
        if (this.isForwarded(req)) {
            SanitizedLogStatement.of(req.getAttribute("javax.servlet.forward.request_uri")).andThenLog(sanitizedAttribute -> log.trace("Initiating SSO on forwarded request from; {} to: {}", sanitizedAttribute, (Object)req.getRequestURI()));
        }
    }

    private void logAuthorizationHeaders(HttpServletRequestFacade req) {
        if (this.hostApp.isRestApi(HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req)) && log.isDebugEnabled()) {
            Enumeration authorizationHeaders = req.getHeaders("Authorization");
            int i = 0;
            while (authorizationHeaders.hasMoreElements()) {
                log.trace("Authorization Headers:");
                String header = (String)authorizationHeaders.nextElement();
                String scheme = header.split(" ")[0];
                log.trace("Header Authorization " + i + ": " + scheme);
                ++i;
            }
        }
    }

    private boolean isPreemptivePathExcluded(HttpServletRequestFacade req) {
        if (this.isForwarded(req)) {
            return false;
        }
        Object r = req.getRequestURI().substring(req.getContextPath().length()).toLowerCase();
        if (req.getQueryString() != null) {
            r = (String)r + "?" + req.getQueryString();
        }
        for (String excludedPath : this.kerbConfManager.getRequireLoginExcludedPaths()) {
            if (excludedPath != null && excludedPath.endsWith("*")) {
                excludedPath = excludedPath.substring(0, excludedPath.length() - 1);
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)r, (CharSequence)excludedPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isMappedRequest(HttpServletRequestFacade req, HttpServletResponseFacade resp) {
        String r = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        if (this.hostApp.isRequestMapped(req, r)) {
            log.trace("isRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isRESTRequestMapped(req, r)) {
            log.trace("isRestRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isForceLoginRequestMapped(req) && this.kerbConfManager.isRequireLogin() && !this.isPreemptivePathExcluded(req)) {
            log.trace("isRequireLogin({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isLoginRequest(req)) {
            log.trace("isLoginRequest({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.shouldLoginManually(req, resp) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            log.trace("shouldLoginManually() && isAnyProviderForcingReLoginAfterLogout() ({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isLogoutPage(req) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            log.trace("isLogoutPage() && isAnyProviderForcingReLoginAfterLogout() ({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isJsmLogoutPage(req) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()) {
            return true;
        }
        if (this.hostApp.shouldTryApiTokenAuthentication(req)) {
            log.trace("shouldTryApiAuthentication({}) => true", (Object)r);
            return true;
        }
        if (HttpUrlUtils.getUsernameFromBasicAuthHeader((HttpServletRequestFacade)req).isDefined()) {
            log.trace("getUsernameFromBasicAuthHeader({}) => true", (Object)r);
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.requestInterceptor.getUsernameFromHeader(req))) {
            log.trace("getUsernameFromHeader({}) => true", (Object)r);
            return true;
        }
        log.trace("isMappedRequest({}) => FALSE", (Object)r);
        return false;
    }

    private void finishSuccessfulKerberosLogin(HttpServletRequestFacade req, HttpServletResponseFacade res, Principal principal, FilterChainFacade chain) throws IOException {
        this.authenticateWithProduct(req, res, principal);
        this.kerbConfManager.getStats().success();
        res.setHeader("Persistent-Auth", "false");
        log.trace("Kerberos ticket OK -> login success");
        this.hostApp.postSuccessfulLoginWithKerberosAction(principal, req, res, chain);
    }

    private boolean isForceUIForTest(HttpServletRequestFacade req) {
        String qry = req.getQueryString();
        return qry != null && qry.contains("forceUIForTest");
    }

    private boolean querystringHas(String queryStringPart, HttpServletRequestFacade req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)queryStringPart);
    }

    private void toggleKerberosSessionFromQueryString(HttpServletRequestFacade req) {
        if (this.querystringHas("nokerberosSession", req)) {
            req.getSessionKsso().setAttribute("nokerberosSession", (Object)Boolean.TRUE);
        } else if (this.querystringHas("kerberosSession", req)) {
            req.getSessionKsso().removeAttribute("nokerberosSession");
        }
    }

    private boolean isForwarded(HttpServletRequestFacade req) {
        return req.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    private void dispatchToLogin(HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        log.trace("is response committed {}", (Object)resp.isCommitted());
        IdpConfiguration autoRedirect = this.hostApp.getInstantRedirectProvider(req, resp, this.loginScriptCondition);
        boolean hasCookie = false;
        if (this.kerbConfManager.isRemembermeCookieEnabled() && req.getCookies() != null) {
            for (CookieFacade cookie : req.getCookiesKsso()) {
                if (!"seraph.rememberme.cookie".equals(cookie.getName()) && !"seraph.confluence".equals(cookie.getName())) continue;
                hasCookie = true;
                break;
            }
        }
        if (this.idpConfManager.isFederatedSsoEnabled() && autoRedirect != null && !hasCookie && (this.hostApp.isForceLoginRequestMapped(req) && this.kerbConfManager.isRequireLogin() && this.kerbConfManager.isForceLogin() || this.hostApp.isMainLoginPage(req)) && !this.kerbConfManager.isIdpDisabledUserAgent(req.getHeader("User-Agent"))) {
            this.performInstantRedirect(req, resp, autoRedirect);
        } else {
            this.hostApp.dispatchToLogin(req, resp, chain);
        }
    }

    protected final void performInstantRedirect(HttpServletRequestFacade req, HttpServletResponseFacade resp, IdpConfiguration idpConfiguration) throws IOException {
        Object url;
        String target = this.hostApp.getRedirectTarget(req);
        ContextAware pathHelper = ContextAware.of((HttpServletRequestFacade)req);
        resp.setContentType("text/html");
        if (target != null) {
            url = target;
        } else {
            Object qs;
            Object object = qs = req.getQueryString() != null ? "?" + req.getQueryString() : "";
            if (this.hostApp.isMainLoginPage(req)) {
                if (StringUtils.isNotBlank((CharSequence)qs) && !StringUtils.contains((CharSequence)qs, (CharSequence)this.hostApp.getTargetParameterName())) {
                    qs = (String)qs + "&" + this.hostApp.getTargetParameterName() + "=/";
                } else if (StringUtils.isBlank((CharSequence)qs)) {
                    qs = "?" + this.hostApp.getTargetParameterName() + "=/";
                }
            }
            url = req.getRequestURI() + (String)qs;
            log.trace("Instant redirect: Target value built from query string: " + (String)url);
        }
        if (!StringUtils.contains((CharSequence)url, (CharSequence)pathHelper.path("/rest/"))) {
            req.getSessionKsso().setAttribute("samlInstantLoginUrl", url);
        }
        url = this.idpConfManager.getServiceProviderLoginUrl(req, idpConfiguration.getId()) + "?target=" + HttpUrlUtils.urlEncode((String)url);
        log.trace("Instant redirect: Return value sent to IdP: " + (String)url);
        if (idpConfiguration.isHostedDomain() && idpConfiguration.getKnownDomains().iterator().hasNext()) {
            url = (String)url + "&hd=" + (String)idpConfiguration.getKnownDomains().iterator().next();
        }
        resp.getWriter().print("<html><head><link rel=\"icon\" href=\"data:image/x-icon;base64,AA==\" /><meta http-equiv=\"refresh\" content=\"1;URL='" + StringEscapeUtils.escapeHtml4((String)url) + "'\" /></head><p>Redirecting to sign-on..</p></html>");
    }

    public void destroy() {
    }

    private Principal authenticateWithProduct(HttpServletRequestFacade req, HttpServletResponseFacade res, Principal user) {
        return AtlasKerberosMainAuthFilter.authenticateWithProduct(req, res, user, this.kerbConfManager, this.hostApp);
    }

    public static Principal authenticateWithProduct(HttpServletRequestFacade req, HttpServletResponseFacade res, Principal user, KerbConfManager kerbConfManager, HostApp hostApp) {
        if (kerbConfManager.isRemembermeCookieEnabled()) {
            hostApp.setRememberMeCookie(req, res, user.getName());
        }
        return hostApp.authenticateWithProduct(req, res, user);
    }
}

