/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.dircopy;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.kantega.atlaskerb.velocity.model.DirectoryDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageUsersInDirectoriesServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(ManageUsersInDirectoriesServlet.class);
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final DirectoryManager directoryManager;

    @Inject
    public ManageUsersInDirectoriesServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
        this.directoryManager = this.hostApp.getDirectoryManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.modelAndRender(req, resp, null, null, false);
    }

    private void modelAndRender(HttpServletRequestFacade req, HttpServletResponseFacade resp, Result result, ArrayList<String> errorMessageList, boolean moveDone) throws IOException {
        String submitButton;
        boolean regexSearch;
        String userNamePart;
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "manageUsersInDirectories");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("errorMessage", result != null ? result.errorMessage : null);
        model.put("errorUser", result != null ? result.removeUser : null);
        model.put("errorMessageList", errorMessageList);
        List<Map<String, String>> groups = GroupSearchUtil.getGroupsAsListMap("", this.userManager);
        model.put("groups", groups);
        String onlySearchMainDirectory = req.getParameter("onlySearchMainDirectory");
        model.put("onlySearchMainDirectory", onlySearchMainDirectory);
        String usernameAtlassianSearch = userNamePart = req.getParameter("userNamePart");
        String emailPart = req.getParameter("emailPart");
        ArrayList<com.atlassian.crowd.model.user.User> allUsersInDirectories = new ArrayList<com.atlassian.crowd.model.user.User>();
        List directories = this.hostApp.getCrowdDirectoryService().findAllDirectories();
        model.put("directories", DirectoryDto.getVelocityCompatibleUserDirectories(directories));
        List<Directory> writableDirectories = directories.stream().filter(this.hostApp::isWritableDirectory).collect(Collectors.toList());
        model.put("writableDirectories", DirectoryDto.getVelocityCompatibleUserDirectories(writableDirectories));
        if (StringUtils.isBlank((CharSequence)userNamePart)) {
            userNamePart = "%";
        }
        boolean bl = regexSearch = !StringUtils.equals((CharSequence)"Search", (CharSequence)(submitButton = req.getParameter("submit")));
        if (regexSearch) {
            usernameAtlassianSearch = "%";
        }
        if (StringUtils.isNotBlank((CharSequence)userNamePart)) {
            model.put("userNamePart", userNamePart);
            String searchFromDirectory = req.getParameter("searchFromDirectory");
            if (moveDone || StringUtils.equals((CharSequence)"allDirectories", (CharSequence)searchFromDirectory)) {
                searchFromDirectory = null;
            } else {
                model.put("searchFromDirectory", searchFromDirectory);
            }
            model.put("whatScimUsers", req.getParameter("whatScimUsers"));
            EntityQuery userQuery = QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)usernameAtlassianSearch)).returningAtMost(-1);
            Comparator caseInsensitiveComparator = String::compareToIgnoreCase;
            TreeMap<String, UserInDirectory> usersInDirectories = new TreeMap<String, UserInDirectory>(caseInsensitiveComparator);
            for (Directory directory : directories) {
                try {
                    List users = this.directoryManager.searchUsers(directory.getId().longValue(), userQuery);
                    allUsersInDirectories.addAll(users);
                }
                catch (DirectoryNotFoundException | OperationFailedException e) {
                    log.error("Failed to get users from directory: " + directory.getName(), e);
                }
            }
            this.addUserAttributesAndFilterScim(allUsersInDirectories, usersInDirectories, userNamePart, req.getParameter("whatScimUsers"));
            try {
                String searchFromGroup;
                if (searchFromDirectory != null) {
                    this.filterUsersFromSearchDirectory(searchFromDirectory, usersInDirectories, onlySearchMainDirectory);
                }
                if (regexSearch) {
                    this.filterUsingRegex(userNamePart, usersInDirectories);
                }
                if (StringUtils.isNotBlank((CharSequence)(searchFromGroup = req.getParameter("searchFromGroup")))) {
                    model.put("searchFromGroup", searchFromGroup);
                }
                this.filterFromGroup(searchFromGroup, usersInDirectories);
                if (StringUtils.isNotBlank((CharSequence)emailPart)) {
                    model.put("emailPart", emailPart);
                    this.filterEmail(emailPart, usersInDirectories, regexSearch);
                }
            }
            catch (Exception e) {
                log.error("Error filtering users", (Throwable)e);
                model.put("errorMessage", "Error filtering users: " + e.getMessage());
            }
            model.put("usersInDirectories", usersInDirectories);
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/manageUsersInDirectories.vm", model, (Writer)resp.getWriter());
    }

    private void filterUsersFromSearchDirectory(String searchFromDirectory, Map<String, UserInDirectory> usersInDirectories, String onlySearchMainDirectory) {
        HashMap<String, UserInDirectory> filtered = new HashMap<String, UserInDirectory>();
        block0: for (Map.Entry<String, UserInDirectory> entry : usersInDirectories.entrySet()) {
            UserInDirectory userInDirectory = entry.getValue();
            if (StringUtils.equals((CharSequence)userInDirectory.getMasterDirectory().getDirectory().getId().toString(), (CharSequence)searchFromDirectory)) {
                filtered.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)"on", (CharSequence)onlySearchMainDirectory)) continue;
            for (DirectoryDetails directoryDetails : userInDirectory.getDirectories()) {
                if (!directoryDetails.getDirectory().getId().toString().equals(searchFromDirectory)) continue;
                filtered.put(entry.getKey(), entry.getValue());
                continue block0;
            }
        }
        usersInDirectories.clear();
        usersInDirectories.putAll(filtered);
    }

    private void filterUsingRegex(String userNamePart, Map<String, UserInDirectory> usersInDirectories) {
        if (StringUtils.isNotBlank((CharSequence)userNamePart)) {
            userNamePart = userNamePart.trim();
            HashMap<String, UserInDirectory> filtered = new HashMap<String, UserInDirectory>();
            for (Map.Entry<String, UserInDirectory> entry : usersInDirectories.entrySet()) {
                UserInDirectory userInDirectory = entry.getValue();
                if (userInDirectory.getUserName() == null || !userInDirectory.getUserName().matches(userNamePart)) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            usersInDirectories.clear();
            usersInDirectories.putAll(filtered);
        }
    }

    private void filterEmail(String emailPart, Map<String, UserInDirectory> usersInDirectories, boolean regexSearch) {
        if (StringUtils.isNotBlank((CharSequence)emailPart)) {
            emailPart = emailPart.trim().toLowerCase();
            HashMap<String, UserInDirectory> filtered = new HashMap<String, UserInDirectory>();
            for (Map.Entry<String, UserInDirectory> entry : usersInDirectories.entrySet()) {
                UserInDirectory userInDirectory = entry.getValue();
                String email = userInDirectory.getEmail();
                if (email == null || (regexSearch || !email.toLowerCase().contains(emailPart)) && (!regexSearch || !email.matches(emailPart))) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            usersInDirectories.clear();
            usersInDirectories.putAll(filtered);
        }
    }

    private void filterFromGroup(String searchFromGroup, Map<String, UserInDirectory> usersInDirectories) {
        if (StringUtils.equals((CharSequence)"allGroups", (CharSequence)searchFromGroup)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)searchFromGroup)) {
            HashMap<String, UserInDirectory> filtered = new HashMap<String, UserInDirectory>();
            for (Map.Entry<String, UserInDirectory> entry : usersInDirectories.entrySet()) {
                UserInDirectory userInDirectory = entry.getValue();
                if (userInDirectory.getGroups() == null || !userInDirectory.getGroups().contains(searchFromGroup)) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            usersInDirectories.clear();
            usersInDirectories.putAll(filtered);
        }
    }

    private void addUserAttributesAndFilterScim(ArrayList<com.atlassian.crowd.model.user.User> allUsersInDirectories, Map<String, UserInDirectory> usersInDirectories, String userNamePart, String whatScimUsers) {
        for (com.atlassian.crowd.model.user.User user : allUsersInDirectories) {
            try {
                DirectoryDto directoryDto;
                boolean showAllUsers;
                Directory directory = this.directoryManager.findDirectoryById(user.getDirectoryId());
                boolean removeThisUser = false;
                io.vavr.collection.Map attributeMap = null;
                boolean bl = showAllUsers = StringUtils.equals((CharSequence)"allUsers", (CharSequence)whatScimUsers) || whatScimUsers == null;
                if (allUsersInDirectories.size() < 10000 || !showAllUsers) {
                    boolean shouldOnlyShowScimUsers = StringUtils.equals((CharSequence)"onlyScim", (CharSequence)whatScimUsers);
                    try {
                        UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(directory.getId().longValue(), user.getName());
                        attributeMap = io.vavr.collection.List.ofAll((Iterable)userWithAttributes.getKeys()).toMap(key -> key, key -> {
                            Set values = userWithAttributes.getValues(key);
                            return values.size() == 1 ? (String)values.iterator().next() : "[" + String.join((CharSequence)", ", values) + "]";
                        });
                        if (!showAllUsers && shouldOnlyShowScimUsers && !attributeMap.containsKey((Object)"ksso.scim.id")) {
                            removeThisUser = true;
                        } else if (!showAllUsers && !shouldOnlyShowScimUsers && attributeMap.containsKey((Object)"ksso.scim.id")) {
                            removeThisUser = true;
                        }
                    }
                    catch (OperationFailedException | UserNotFoundException e) {
                        log.error("Failed to get user attributes from user: " + user.getName(), e);
                    }
                }
                if (usersInDirectories.containsKey(user.getName())) {
                    directoryDto = DirectoryDto.from(directory);
                    List<String> userCurrentGroups = this.getGroupNamesForUser(user.getName(), directoryDto);
                    usersInDirectories.get(user.getName()).addDirectory(directoryDto, this.hostApp.isWritableDirectory(directory), (io.vavr.collection.Map<String, String>)attributeMap, userCurrentGroups);
                    continue;
                }
                directoryDto = DirectoryDto.from(directory);
                UserInDirectory userInDirectory = new UserInDirectory(user.getName(), user.getFirstName() + " " + user.getLastName(), user.getEmailAddress(), directoryDto, this.hostApp.isWritableDirectory(directory), (io.vavr.collection.Map<String, String>)attributeMap, this.getGroupNamesForUser(user.getName(), directoryDto));
                if (removeThisUser) continue;
                usersInDirectories.put(user.getName(), userInDirectory);
            }
            catch (DirectoryNotFoundException e) {
                log.error("Failed to get directory from user: " + user.getName(), (Throwable)e);
            }
        }
    }

    private List<String> getGroupNamesForUser(String username, DirectoryDto directory) {
        List userCurrentGroups = null;
        if (username != null) {
            try {
                userCurrentGroups = this.hostApp.getDirectoryManager().searchNestedGroupRelationships(directory.getId().longValue(), this.getMembershipQuery(username));
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.error("Failed to get user groups from directory: " + directory.getName(), e);
            }
        }
        return userCurrentGroups;
    }

    private MembershipQuery<String> getMembershipQuery(String username) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(0).returningAtMost(-1);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String moveToDirectoryId;
        Result result = null;
        String loggedInUser = this.getLoggedInUsername(req);
        super.doPostKsso(req, resp);
        String errorMessage = null;
        ArrayList<String> errorMessageList = new ArrayList<String>();
        String removeUser = req.getParameter("removeUser");
        if (StringUtils.isNotBlank((CharSequence)removeUser)) {
            result = this.removeUser(removeUser, req, resp, errorMessage, loggedInUser);
        }
        if (StringUtils.isNotBlank((CharSequence)(moveToDirectoryId = req.getParameter("moveToDirectoryId")))) {
            this.moveUsers(Long.parseLong(moveToDirectoryId), req, resp, loggedInUser, errorMessageList);
        }
        this.modelAndRender(req, resp, result, errorMessageList, StringUtils.isNotBlank((CharSequence)moveToDirectoryId));
    }

    private void moveUsers(long toDirectoryId, HttpServletRequestFacade req, HttpServletResponseFacade resp, String loggedInUser, ArrayList<String> errorMessageList) {
        int previousDirPriority = this.moveDirToTop(toDirectoryId);
        Enumeration parameters = req.getParameterNames();
        for (String parameter : Collections.list(parameters)) {
            if (!parameter.startsWith("selectUser_")) continue;
            String userToMove = parameter.replace("selectUser_", "");
            long fromDirectoryId = Long.parseLong(req.getParameter("dirForUser_" + userToMove));
            try {
                this.moveUserToDir(fromDirectoryId, toDirectoryId, (User)this.hostApp.getDirectoryManager().findUserByName(fromDirectoryId, userToMove), loggedInUser, errorMessageList);
            }
            catch (Exception e) {
                errorMessageList.add("Failed to move user " + userToMove + " to directory: " + e.getMessage());
            }
        }
        this.hostApp.getCrowdDirectoryService().setDirectoryPosition(toDirectoryId, previousDirPriority);
    }

    private int moveDirToTop(long toDirectoryId) {
        List directories = this.hostApp.getCrowdDirectoryService().findAllDirectories();
        int previousDirPriority = 0;
        for (int d = 0; d < directories.size(); ++d) {
            if (((Directory)directories.get(d)).getId() != toDirectoryId) continue;
            previousDirPriority = d;
            break;
        }
        this.hostApp.getCrowdDirectoryService().setDirectoryPosition(toDirectoryId, 0);
        return previousDirPriority;
    }

    private static String generateRandomPassword() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(130, random).toString(32) + "ABab23";
    }

    private void moveUserToDir(long fromDirectoryId, long toDirectoryId, User userToMove, String loggedInUser, ArrayList<String> errorMessageList) throws Exception {
        if (!userToMove.getName().equalsIgnoreCase(loggedInUser)) {
            UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(fromDirectoryId, userToMove.getName());
            try {
                UserTemplate newUser = new UserTemplate(userToMove);
                newUser.setDirectoryId(toDirectoryId);
                this.directoryManager.addUser(toDirectoryId, newUser, new PasswordCredential(ManageUsersInDirectoriesServlet.generateRandomPassword()));
            }
            catch (Exception e) {
                errorMessageList.add("Failed to add user: " + userToMove.getName() + " to directory: " + e.getMessage());
                return;
            }
            Set keys = userWithAttributes.getKeys();
            HashMap<String, Set> attributes = new HashMap<String, Set>();
            for (String key : keys) {
                Set values = userWithAttributes.getValues(key);
                attributes.put(key, values);
            }
            this.directoryManager.storeUserAttributes(toDirectoryId, userToMove.getName(), attributes);
            try {
                this.addGroupsToNewDirRemoveFromExistingUser(fromDirectoryId, toDirectoryId, userToMove);
            }
            catch (Exception e) {
                errorMessageList.add("Failed to remove groups from user " + String.valueOf(userToMove) + " in previous directory: " + e.getMessage());
            }
            this.directoryManager.removeUser(fromDirectoryId, userToMove.getName());
        }
    }

    private void addGroupsToNewDirRemoveFromExistingUser(long fromDirectoryId, long toDirectoryId, User userToMove) throws DirectoryNotFoundException, OperationFailedException, InvalidGroupException, DirectoryPermissionException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, MembershipAlreadyExistsException, MembershipNotFoundException {
        MembershipQuery groupQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userToMove.getName()).returningAtMost(-1);
        List groups = this.directoryManager.searchDirectGroupRelationships(fromDirectoryId, groupQuery);
        for (Group group : groups) {
            try {
                this.directoryManager.findGroupByName(toDirectoryId, group.getName());
            }
            catch (GroupNotFoundException ex) {
                GroupTemplate newGroup = new GroupTemplate(group);
                newGroup.setDirectoryId(toDirectoryId);
                this.directoryManager.addGroup(toDirectoryId, newGroup);
            }
            this.directoryManager.addUserToGroup(toDirectoryId, userToMove.getName(), group.getName());
            this.directoryManager.removeUserFromGroup(fromDirectoryId, userToMove.getName(), group.getName());
        }
    }

    @Nullable
    private Result removeUser(String removeUser, HttpServletRequestFacade req, HttpServletResponseFacade resp, String errorMessage, String loggedInUser) {
        String removeFromDirectoryId = req.getParameter("removeFromDirectoryId");
        try {
            if (removeUser.equals(loggedInUser)) {
                errorMessage = "You cannot remove yourself from the system";
                this.modelAndRender(req, resp, new Result((String)errorMessage, removeUser), null, false);
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)removeFromDirectoryId)) {
                Directory directory = this.directoryManager.findDirectoryById(Long.parseLong(removeFromDirectoryId));
                this.directoryManager.removeUser(directory.getId().longValue(), removeUser);
            } else {
                removeFromDirectoryId = "all directories";
                this.hostApp.getCrowdService().removeUser(this.hostApp.getCrowdService().getUser(removeUser));
            }
        }
        catch (Exception e) {
            errorMessage = "Failed to remove removeUser: " + removeUser + " from " + removeFromDirectoryId;
            log.warn((String)errorMessage, (Throwable)e);
        }
        Result result = new Result((String)errorMessage, removeUser);
        return result;
    }

    private String getLoggedInUsername(HttpServletRequestFacade req) {
        String loggedInUsername = (String)Option.of((Object)this.userManager.getRemoteUser((HttpServletRequest)req)).map(UserProfile::getUsername).getOrNull();
        return loggedInUsername;
    }

    private static class Result {
        public final String errorMessage;
        public final String removeUser;

        public Result(String errorMessage, String removeUser) {
            this.errorMessage = errorMessage;
            this.removeUser = removeUser;
        }
    }

    public class UserInDirectory {
        private final String userName;
        private final String fullname;
        private final String email;
        private boolean inOneOrMoreActiveDirs;
        private final DirectoryDetails masterDirectory;
        private ArrayList<DirectoryDetails> directories;
        private final List<String> groups;

        public UserInDirectory(String userName, String fullname, String email, DirectoryDto masterDirectory, boolean isWritable, io.vavr.collection.Map<String, String> attributeMap, List<String> groups) {
            this.userName = userName;
            this.fullname = fullname;
            this.email = email;
            this.masterDirectory = new DirectoryDetails(masterDirectory, isWritable, attributeMap, ManageUsersInDirectoriesServlet.this.getGroupNamesForUser(userName, masterDirectory));
            this.setInOneOrMoreActiveDirs(masterDirectory.isActive());
            this.directories = new ArrayList();
            this.groups = groups;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getFullname() {
            return this.fullname;
        }

        public String getEmail() {
            return this.email;
        }

        public DirectoryDetails getMasterDirectory() {
            return this.masterDirectory;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public void addDirectory(DirectoryDto directoryWrapper, boolean isWritable, io.vavr.collection.Map<String, String> attributeMap, List<String> groups) {
            this.directories.add(new DirectoryDetails(directoryWrapper, isWritable, attributeMap, groups));
            this.setInOneOrMoreActiveDirs(directoryWrapper.isActive());
        }

        public ArrayList<DirectoryDetails> getDirectories() {
            return this.directories;
        }

        public boolean isInOneOrMoreActiveDirs() {
            return this.inOneOrMoreActiveDirs;
        }

        private void setInOneOrMoreActiveDirs(boolean isActive) {
            if (isActive) {
                this.inOneOrMoreActiveDirs = true;
            }
        }
    }

    public static class DirectoryDetails {
        private final DirectoryDto directoryWrapper;
        private final boolean isWritable;
        private final io.vavr.collection.Map<String, String> attributeMap;
        private final List<String> groups;

        public DirectoryDetails(DirectoryDto directoryWrapper, boolean isWritable, io.vavr.collection.Map<String, String> attributeMap, List<String> groups) {
            this.directoryWrapper = directoryWrapper;
            this.isWritable = isWritable;
            this.attributeMap = attributeMap;
            this.groups = groups;
        }

        public DirectoryDto getDirectory() {
            return this.directoryWrapper;
        }

        public boolean isWritable() {
            return this.isWritable;
        }

        public Map<String, String> getAttributeMap() {
            if (this.attributeMap == null) {
                return new HashMap<String, String>();
            }
            return this.attributeMap.toJavaMap();
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

