/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import javax.inject.Inject;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.OidcConfigurationWithBucket;
import org.kantega.atlaskerb.identityproviders.SamlConfigurationWithBucket;
import org.kantega.atlaskerb.identityproviders.oidc.OidcFactory;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.springframework.stereotype.Component;

@Component
public class Bucket {
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;
    private final OidcLibWrapper oidcLibWrapper;

    @Inject
    private Bucket(@ComponentImport ApplicationProperties applicationProperties, HostAppFactory hostAppFactory, IdpConfManager idpConfManager, JsonWrapper jsonWrapper, OidcFactory oidcFactory) {
        this.applicationProperties = applicationProperties;
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
        this.oidcLibWrapper = oidcFactory.createOidcLibWrapper(jsonWrapper);
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public HostApp getHostApp() {
        return this.hostApp;
    }

    public IdpConfManager getIdpConfManager() {
        return this.idpConfManager;
    }

    public OidcLibWrapper getOidcLibWrapper() {
        return this.oidcLibWrapper;
    }

    public OidcConfigurationWithBucket wrapWithOidcConfig(OidcIdpConfiguration oidcIdpConfiguration) {
        return new OidcConfigurationWithBucket(oidcIdpConfiguration, this);
    }

    public SamlConfigurationWithBucket wrapWithSamlConfig(SamlIdpConfiguration samlIdpConfiguration) {
        return new SamlConfigurationWithBucket(samlIdpConfiguration, this);
    }
}

