/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class BackupInfo {
    private final String applicationName;
    private final String applicationVersion;
    private final String pluginVersion;
    private final String baseUrl;
    private final long timeMillis;
    private final String description;
    private final String filename;
    private final List<String> paths = new ArrayList<String>();
    private final boolean readable;
    private Properties settings;

    public BackupInfo(String applicationName, String applicationVersion, String pluginVersion, String baseUrl, long timeMillis, String description, String filename) {
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.pluginVersion = pluginVersion;
        this.baseUrl = baseUrl;
        this.timeMillis = timeMillis;
        this.description = description;
        this.filename = filename;
        this.readable = true;
    }

    public BackupInfo(String filename, boolean readable) {
        this.filename = filename;
        this.readable = readable;
        this.applicationName = null;
        this.applicationVersion = null;
        this.pluginVersion = null;
        this.baseUrl = null;
        this.timeMillis = 0L;
        this.description = null;
    }

    public static BackupInfo fromProperties(Properties props, String filename) {
        return new BackupInfo(props.getProperty("applicationName"), props.getProperty("applicationVersion"), props.getProperty("pluginVersion"), props.getProperty("baseUrl"), Long.parseLong(props.getProperty("timeMillis")), props.getProperty("description"), filename);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public String getDescription() {
        return this.description;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("applicationName", this.applicationName);
        props.setProperty("applicationVersion", this.applicationVersion);
        props.setProperty("pluginVersion", this.pluginVersion);
        props.setProperty("baseUrl", this.baseUrl);
        props.setProperty("timeMillis", Long.toString(this.timeMillis));
        props.setProperty("description", this.description);
        return props;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<String, String> getSettings() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (this.settings != null) {
            Enumeration<?> names = this.settings.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, this.settings.getProperty(name));
            }
        }
        return map;
    }

    public void setSettings(Properties settings) {
        this.settings = settings;
    }

    public boolean isReadable() {
        return this.readable;
    }
}

