/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class OidcIdpUtil
implements EnvironmentAware {
    private Environment environment;
    public static final String USING_ENVIRONMENT_PROPERTY = "USING_ENVIRONMENT_PROPERTY";
    public static final String secretPropertyPathStatic = "ORG_KANTEGA_ATLASKERB_IDENTITYPROVIDERS_OIDCSTATIC_CLIENTSECRET";

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public static String getClientSecretPropertyPath() {
        return secretPropertyPathStatic;
    }

    public static String getClientSecretPropertyPath(OidcIdpConfiguration idpConf) {
        return String.format("%s_%s_CLIENTSECRET", "ORG_KANTEGA_ATLASKERB_IDENTITYPROVIDERS_OIDC", idpConf.getId().replace('-', '_'));
    }

    public CONFIGURATION_LOCATION getConfigurationLocation(OidcIdpConfiguration idpConf) {
        String secretPerIdp = this.environment.getProperty(OidcIdpUtil.getClientSecretPropertyPath(idpConf));
        String staticSecret = this.environment.getProperty(OidcIdpUtil.getClientSecretPropertyPath());
        if (StringUtils.isBlank((CharSequence)staticSecret)) {
            staticSecret = this.environment.getProperty(OidcIdpUtil.getClientSecretPropertyPath(), System.getenv(OidcIdpUtil.getClientSecretPropertyPath()));
        }
        String finalStaticSecret = staticSecret;
        return (CONFIGURATION_LOCATION)((Object)Option.of((Object)secretPerIdp).filter(StringUtils::isNotBlank).map(s -> CONFIGURATION_LOCATION.PER_IDP_ENV_PROPERTY).getOrElse(() -> (CONFIGURATION_LOCATION)((Object)((Object)Option.of((Object)finalStaticSecret).filter(StringUtils::isNotBlank).map(s -> CONFIGURATION_LOCATION.STATIC_ENV_PROPERTY).getOrElse((Object)CONFIGURATION_LOCATION.KSSO_FILE)))));
    }

    public String getClientSecret(OidcIdpConfiguration idpConf) {
        CONFIGURATION_LOCATION location = this.getConfigurationLocation(idpConf);
        switch (location.ordinal()) {
            case 1: {
                return this.environment.getProperty(OidcIdpUtil.getClientSecretPropertyPath(idpConf));
            }
            case 0: {
                return this.environment.getProperty(OidcIdpUtil.getClientSecretPropertyPath());
            }
        }
        return idpConf.getClientSecret();
    }

    public String getClientSecretProcessEnv(OidcIdpConfiguration idpConf) {
        CONFIGURATION_LOCATION location = this.getConfigurationLocation(idpConf);
        if (location == CONFIGURATION_LOCATION.PER_IDP_ENV_PROPERTY || location == CONFIGURATION_LOCATION.STATIC_ENV_PROPERTY) {
            return USING_ENVIRONMENT_PROPERTY;
        }
        return idpConf.getClientSecret();
    }

    public static enum CONFIGURATION_LOCATION {
        STATIC_ENV_PROPERTY("Static Environment Property"),
        PER_IDP_ENV_PROPERTY("Per IDP Environment Property"),
        KSSO_FILE("KSSO File");

        private final String description;

        private CONFIGURATION_LOCATION(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

