/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.kantega.atlaskerb.connector.ConnectorIOUtil;

public interface ConnectorHttpClient {

    public static class AuthContext {
        private final Map<String, String> headers;

        public AuthContext(Map<String, String> headers) {
            this.headers = headers;
        }

        public HttpURLConnection openConnection(String url) throws IOException {
            HttpURLConnection conn = ConnectorIOUtil.openConnection(url);
            this.headers.forEach(conn::setRequestProperty);
            return conn;
        }
    }

    public static class JsonPostRequest
    implements PostRequest {
        private final String url;
        private final JSONObject object;

        public JsonPostRequest(String url, JSONObject object) {
            this.url = url;
            this.object = object;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getAcceptType() {
            return "application/json";
        }

        @Override
        public String getContentType() {
            return "application/json";
        }

        @Override
        public String getPostBody() {
            return this.object.toString();
        }
    }

    public static interface PostRequest {
        public String getUrl();

        public String getAcceptType();

        public String getContentType();

        public String getPostBody();
    }

    public static class Response {
        private final int responseCode;
        private final String responseString;
        private final Map<String, List<String>> headerFields;

        public Response(int responseCode, String responseString, Map<String, List<String>> headerFields) {
            this.responseCode = responseCode;
            this.responseString = responseString;
            this.headerFields = headerFields;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public Map<String, List<String>> getHeaderFields() {
            return this.headerFields;
        }

        public JSONArray getAsJSONArray() {
            return new JSONArray(this.responseString);
        }

        public JSONObject getAsJSONObject() {
            return new JSONObject(this.responseString);
        }
    }
}

