/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.keycloak;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.kantega.atlaskerb.connector.model.Directory;

public class KeycloakDirectory
extends Directory {
    public static final String REALM = "realm";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String USERNAME = "kc_username";
    public static final String PASSWORD = "kc_password";
    public static final String URI_SCHEME = "uri_scheme";

    public KeycloakDirectory(Directory.Common common, String realm, String clientId, String clientSecret, String username, String password, String uriScheme) {
        super(common);
        this.properties.put(REALM, realm);
        this.properties.put(CLIENT_ID, clientId);
        this.properties.put(CLIENT_SECRET, clientSecret);
        this.properties.put(USERNAME, username);
        this.properties.put(PASSWORD, password);
        this.properties.put(URI_SCHEME, uriScheme);
    }

    public String getRealm() {
        return this.properties.getProperty(REALM);
    }

    public String getClientId() {
        return this.properties.getProperty(CLIENT_ID);
    }

    public String getClientSecret() {
        return this.properties.getProperty(CLIENT_SECRET);
    }

    public String getUsername() {
        return this.properties.getProperty(USERNAME);
    }

    @Override
    public String getPassword() {
        return this.properties.getProperty(PASSWORD);
    }

    public String getUriScheme() {
        return this.properties.getProperty(URI_SCHEME);
    }

    public URIBuilder getUriSchemeBuilder() {
        try {
            URI uri = new URI(this.properties.getProperty(URI_SCHEME));
            return new URIBuilder().setScheme(uri.getScheme()).setHost(uri.getHost() + uri.getPath());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getClientId();
    }
}

