/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.gsuite;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorURIBuilder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.GroupHandler;
import org.kantega.atlaskerb.connector.api.MembershipHandler;
import org.kantega.atlaskerb.connector.api.UserHandler;
import org.kantega.atlaskerb.connector.gsuite.GSuiteHttpClient;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSuiteApi
implements ConnectorAPI {
    private static final Logger log = LoggerFactory.getLogger(GSuiteApi.class);
    private final String domainName;
    private final String customerId;
    private final String apiBaseUrl = System.getProperty("connector.gsuite.api.url", "https://www.googleapis.com");
    private final GSuiteHttpClient client;
    private final int maxResults = Integer.parseInt(System.getProperty("connector.gsuite.maxResults", "-1"));

    public GSuiteApi(String domainName, String customerId, String serviceAccountId, String adminAccountAddress, String privateKey) {
        this.domainName = domainName;
        this.customerId = customerId;
        this.client = new GSuiteHttpClient(this.apiBaseUrl, adminAccountAddress, serviceAccountId, privateKey);
    }

    @Override
    public void findAllUsers(UserHandler userHandler) throws InterruptedException {
        String nextPageToken = null;
        do {
            String u;
            ConnectorHttpClient.Response response;
            JSONObject responseJson;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllUsers aborting");
            }
            ConnectorURIBuilder builder = this.requestUriBuilder("/admin/directory/v1/users");
            ConnectorURIBuilder connectorURIBuilder = builder = StringUtils.isNotBlank((CharSequence)this.customerId) ? builder.queryParam("customer", this.customerId) : builder.queryParam("domain", this.domainName);
            if (nextPageToken != null) {
                builder.queryParam("pageToken", nextPageToken);
            }
            nextPageToken = !(responseJson = (response = this.client.httpGet(u = builder.toString())).getAsJSONObject()).isNull("nextPageToken") ? responseJson.getString("nextPageToken") : null;
            JSONArray usersJson = (JSONArray)responseJson.get("users");
            for (int i = 0; i < usersJson.length(); ++i) {
                UserItem user = this.toUserItem((JSONObject)usersJson.get(i));
                log.debug("Synchronizing user from Google: " + user);
                userHandler.handleUser(user);
            }
        } while (nextPageToken != null);
    }

    @Override
    public void findAllGroups(GroupHandler groupHandler) throws InterruptedException {
        String nextPageToken = null;
        do {
            String u;
            ConnectorHttpClient.Response response;
            JSONObject responseJson;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllGroups aborting");
            }
            ConnectorURIBuilder builder = this.requestUriBuilder("/admin/directory/v1/groups").queryParam("domain", this.domainName);
            if (nextPageToken != null) {
                builder.queryParam("pageToken", nextPageToken);
            }
            nextPageToken = !(responseJson = (response = this.client.httpGet(u = builder.toString())).getAsJSONObject()).isNull("nextPageToken") ? responseJson.getString("nextPageToken") : null;
            JSONArray groupsJson = (JSONArray)responseJson.get("groups");
            List<GroupItem> groups = this.unpackGroups(groupsJson);
            for (int i = 0; i < groupsJson.length(); ++i) {
                GroupItem groupItem = groups.get(i);
                log.debug("Synchronizing group from Google: " + groupItem);
                groupHandler.handleGroup(groupItem);
            }
        } while (nextPageToken != null);
    }

    private List<GroupItem> unpackGroups(JSONArray json) {
        ArrayList<GroupItem> groupItems = new ArrayList<GroupItem>();
        for (int i = 0; i < json.length(); ++i) {
            if (json.get(i) instanceof JSONObject) {
                JSONObject groupJson = (JSONObject)json.get(i);
                if (!groupJson.has("name") || !groupJson.has("id")) continue;
                GroupItem group = new GroupItem();
                group.setName(groupJson.getString("name"));
                group.setId(groupJson.getString("id"));
                group.setActive(true);
                groupItems.add(group);
                continue;
            }
            log.debug("Group Item was not of type JSON Object");
        }
        return groupItems;
    }

    @Override
    public void findAllMemberships(Set<UserItem> includedUsers, Set<GroupItem> includedGroups, MembershipHandler membershipHandler, boolean useNestedGroups) throws InterruptedException {
        HashMap<String, String> groupNameById = new HashMap<String, String>();
        includedGroups.forEach(g -> groupNameById.put(g.getId(), g.getName()));
        HashMap<String, String> userNameById = new HashMap<String, String>();
        includedUsers.forEach(u -> userNameById.put(u.getKey(), u.getName()));
        Map<String, List<Member>> memberships = this.extractGroupMemberships(includedGroups);
        for (String groupId : groupNameById.keySet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllMemberships aborting");
            }
            String groupName = (String)groupNameById.get(groupId);
            MembershipItem group = new MembershipItem();
            group.setName(groupName);
            log.debug("Handling memberships for group from Google: " + group.getName());
            this.addMembers(memberships, userNameById, groupNameById, groupId, groupName, group, useNestedGroups);
            membershipHandler.handleMembership(group);
        }
    }

    @Override
    public void setAvatars(Map<String, String> userNameToId, Path homeDir, String dirName, HostApp hostApp) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Avatars not supported for Google Workspace");
    }

    @NotNull
    private Map<String, List<Member>> extractGroupMemberships(Set<GroupItem> includedGroups) throws InterruptedException {
        HashMap<String, List<Member>> memberships = new HashMap<String, List<Member>>();
        log.debug("Getting memberships from Google for " + includedGroups.size() + " includedGroups");
        for (GroupItem groupItem : includedGroups) {
            String nextPageToken = null;
            do {
                log.debug("Fetching members for groupName: '" + groupItem.getName() + "' id: " + groupItem.getId());
                JSONObject responseJson = this.extractGroupMembers(groupItem.getId(), nextPageToken);
                if (!responseJson.isNull("nextPageToken")) {
                    log.debug("nextPageToken: " + nextPageToken + " groupItem.getId(): " + groupItem.getId());
                    nextPageToken = responseJson.getString("nextPageToken");
                } else {
                    log.debug("nextPageToken set to null groupItem.getId(): " + groupItem.getId());
                    nextPageToken = null;
                }
                if (memberships.get(groupItem.getId()) == null) {
                    memberships.put(groupItem.getId(), this.getMembers(responseJson));
                    continue;
                }
                List existingMembers = (List)memberships.get(groupItem.getId());
                existingMembers.addAll(this.getMembers(responseJson));
            } while (nextPageToken != null);
        }
        return memberships;
    }

    private List<Member> getMembers(JSONObject responseJson) {
        ArrayList<Member> members = new ArrayList<Member>();
        if (responseJson != null && !responseJson.isNull("members")) {
            JSONArray membersJson = (JSONArray)responseJson.get("members");
            for (int i = 0; i < membersJson.length(); ++i) {
                JSONObject memberJson = (JSONObject)membersJson.get(i);
                members.add(new Member(memberJson.getString("type"), memberJson.getString("id")));
            }
        }
        return members;
    }

    private void addMembers(Map<String, List<Member>> memberships, Map<String, String> userNameById, Map<String, String> groupNameById, String groupId, String groupName, MembershipItem group, boolean useNestedGroups) {
        List<Member> members = memberships.get(groupId);
        if (members != null && members.size() > 0) {
            for (Member m : members) {
                if ("USER".equals(m.getType())) {
                    String userName = userNameById.get(m.getId());
                    if (userName != null) {
                        UserMember member = new UserMember();
                        member.setName(userName);
                        log.debug("Adding user: '{}' to group '{}' from Google", (Object)userName, (Object)group.getName());
                        group.getUserCollection().getUsers().add(member);
                        continue;
                    }
                    log.debug("User {} is member of {} but wasn't found in filtered user list; skipping.", (Object)m.getId(), (Object)groupName);
                    continue;
                }
                if (!"GROUP".equals(m.getType()) || !useNestedGroups) continue;
                String subGroupId = m.getId();
                String subGroupName = groupNameById.get(subGroupId);
                log.debug("Nested groups. Unpacking members of group with id " + subGroupId + " and name " + subGroupName + " to parent group " + groupName);
                this.addMembers(memberships, userNameById, groupNameById, subGroupId, groupName, group, true);
            }
        }
    }

    private JSONObject extractGroupMembers(String groupId, String nextPageToken) throws InterruptedException {
        ConnectorURIBuilder builder = this.requestUriBuilder("/admin/directory/v1/groups/" + groupId + "/members");
        if (nextPageToken != null) {
            log.debug("setting pageToken=nextPageToken: " + nextPageToken);
            builder.queryParam("pageToken", nextPageToken);
        }
        String u = builder.toString();
        ConnectorHttpClient.Response response = this.client.httpGet(u);
        log.debug("memberJson from Google" + response.getAsJSONObject());
        return response.getAsJSONObject();
    }

    private UserItem toUserItem(JSONObject jsonUser) {
        try {
            JSONObject nameJson = (JSONObject)jsonUser.get("name");
            UserItem user = new UserItem();
            user.setDisplayName(nameJson.getString("fullName"));
            user.setFirstName(nameJson.getString("givenName"));
            user.setLastName(nameJson.getString("familyName"));
            user.setKey(jsonUser.getString("id"));
            user.setUserType(UserItem.UserType.MEMBER);
            boolean isDeactivated = jsonUser.getBoolean("suspended") || jsonUser.getBoolean("archived");
            user.setActive(!isDeactivated);
            String primaryEmail = jsonUser.getString("primaryEmail");
            user.setEmail(primaryEmail);
            user.setName(primaryEmail);
            return user;
        }
        catch (JSONException e) {
            log.warn(String.format("Retrieved an incomplete JSON object from Google Workspace. Unable to convert it to a user object: %s", jsonUser.toString(0)));
            return null;
        }
    }

    private ConnectorURIBuilder requestUriBuilder(String path) {
        ConnectorURIBuilder builder = ConnectorURIBuilder.builder(this.apiBaseUrl + path);
        if (this.maxResults > 0) {
            builder.queryParam("maxResults", String.valueOf(this.maxResults));
        }
        return builder;
    }

    private static class Member {
        private String type;
        private String id;

        private Member(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }
}

