/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.servlet.http.CookieFacade;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class CookieSecurity {
    public static CookieFacade newHttpOnlyCookie(String name, String value) {
        CookieFacade cookie = new CookieFacade(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(false);
        return cookie;
    }

    public static CookieFacade newSecureHttpOnlyCookie(String name, String value) {
        CookieFacade cookie = CookieSecurity.newHttpOnlyCookie(name, value);
        cookie.setSecure(true);
        return cookie;
    }

    public static CookieFacade cookieWithDynamicSecurity(ApplicationProperties appProps, String name, String value) {
        return HttpUrlUtils.applicationUsesHttps((ApplicationProperties)appProps) ? CookieSecurity.newSecureHttpOnlyCookie(name, value) : CookieSecurity.newHttpOnlyCookie(name, value);
    }
}

