/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.websudo;

import com.kantegasso.servlet.http.HttpServletFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.websudo.BambooWebSudoServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSudoServlet
extends HttpServletFacade {
    public static final String FORCE_AUTH_SESSION_ID = "ForceAuthSessionId";
    public static final String FORCE_AUTH_INITIATED = "ForceAuthInitiated";
    public static final String FORCED_AUTH_URL_PARAMETER = "ForceAuthn=true";
    protected static final String WEB_SUDO_TARGET = "webSudoTarget";
    protected String WEB_SUDO_SERVLET_URL;
    private static final Logger log = LoggerFactory.getLogger(WebSudoServlet.class);

    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.initiateWebsudo(req, resp);
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        log.debug("doGet in Websudo login. hasUsedSso: {}", (Object)req.getParameter("hasUsedSso"));
        if (req.getParameter("hasUsedSso") != null) {
            PrintWriter out = resp.getWriter();
            String idpId = (String)req.getSessionKsso().getAttribute(FORCE_AUTH_SESSION_ID);
            out.print(idpId != null);
            return;
        }
        this.finishWebsudo(req, resp);
    }

    protected void initiateWebsudo(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        HttpSessionFacade session = req.getSessionKsso();
        String context = req.getContextPath();
        String username = (String)CookieUtil.getPreviouslyKnownLoginUsername(req).getOrNull();
        String usernameParameter = StringUtils.isNotBlank((CharSequence)username) ? "&username=" + username + "&login_hint=" + username : "";
        String idpConfigurationId = (String)session.getAttribute(FORCE_AUTH_SESSION_ID);
        if (idpConfigurationId != null) {
            session.setAttribute(WEB_SUDO_TARGET, (Object)req.getParameter(WEB_SUDO_TARGET));
            String redirectAddress = String.format("%s/plugins/servlet/no.kantega.saml/sp/%s/login?%s&target=%s/plugins/servlet/no.kantega.saml/%s%s", context, idpConfigurationId, FORCED_AUTH_URL_PARAMETER, context, this.WEB_SUDO_SERVLET_URL, usernameParameter);
            log.debug("Initiating Websudo login. redirectAddress: {}", (Object)redirectAddress);
            resp.sendRedirect(redirectAddress);
        } else {
            log.error("Not able to initiate Websudo as idpConfigurationId is null. Username: {}", (Object)username);
            this.sendError(resp);
        }
    }

    protected void finishWebsudo(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        HttpSessionFacade session = req.getSessionKsso();
        if (session.getAttribute(FORCE_AUTH_SESSION_ID) != null) {
            session.removeAttribute(FORCE_AUTH_INITIATED);
            String target = (String)req.getSessionKsso().getAttribute(WEB_SUDO_TARGET);
            log.debug("Finishing Websudo login. FORCE_AUTH_SESSION_ID: {}. Target: {}", session.getAttribute(FORCE_AUTH_SESSION_ID), (Object)target);
            this.startWebsudoSession(req, resp);
            if (target == null) {
                target = ((Object)((Object)this)).getClass().equals(BambooWebSudoServlet.class) ? "/admin/administer.action" : "/";
            }
            resp.sendRedirect(req.getContextPath() + target);
        } else {
            log.error("Not able to finish Websudo login, FORCE_AUTH_SESSION_ID: {}. FORCE_AUTH_INITIATED: {}", session.getAttribute(FORCE_AUTH_SESSION_ID), session.getAttribute(FORCE_AUTH_INITIATED));
            this.sendError(resp);
        }
    }

    private void sendError(HttpServletResponseFacade resp) throws IOException {
        resp.sendError(400, "Could not determine what identity provider was used during your login. Please press Back and try again.");
    }

    protected void startWebsudoSession(HttpServletRequestFacade req, HttpServletResponseFacade resp) {
    }

    public static void setForcedAuthSessionId(HttpServletRequestFacade request, String idpConfigurationId) {
        log.debug("Setting FORCE_AUTH_SESSION_ID: {}", (Object)idpConfigurationId);
        request.getSessionKsso().setAttribute(FORCE_AUTH_SESSION_ID, (Object)idpConfigurationId);
    }
}

