/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.postprocessing;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.enums.GroupComparisonType;
import org.kantega.atlaskerb.identityproviders.postprocessing.SsoPostProcessingResult;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.JitGroupRule;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SsoLoginPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;

    @Inject
    public SsoLoginPostProcessor(@ComponentImport UserManager userManager, @ComponentImport ApplicationProperties applicationProperties, HostAppFactory hostAppFactory) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.hostApp = hostAppFactory.getInstance();
    }

    public SsoPostProcessingResult processSsoLoginAttempt(@NonNull IdpConfiguration idpConfiguration, @NonNull FederatedIdentityResponseEvaluationResult evaluationResult, @NonNull String targetUrl) {
        return SsoLoginPostProcessor.initiatePostProcessing(idpConfiguration, evaluationResult, targetUrl).then(this::handleEmptyAttributeInfo).sideEffect(this::addGroupsFromIdp).then(this::evaluateJitPolicies).then(this::jitProvisioning).sideEffect(this::setAdditionalProfileValues).then(this::updateGroupMemberships).then(this::decideLoginMethod);
    }

    private static SsoPostProcessingResult initiatePostProcessing(IdpConfiguration idpConfiguration, FederatedIdentityResponseEvaluationResult evaluationResult, String targetUrl) {
        return SsoPostProcessingResult.of(evaluationResult, idpConfiguration).setTargetUrl(targetUrl).build();
    }

    private void setAdditionalProfileValues(SsoPostProcessingResult ssoPostProcessingResult) {
        FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
        IdpConfiguration idpConfiguration = ssoPostProcessingResult.getIdpConfiguration();
        String foundUsername = evaluationResult.getFoundUsername();
        if (SsoLoginPostProcessor.userPrincipalExists(evaluationResult.getResolvedPrincipalEntry())) {
            try {
                io.vavr.collection.Map rawUserAttributes = io.vavr.collection.List.ofAll(evaluationResult.getAttributeInfos()).toMap(AttributeInfo::getName, AttributeInfo::getValue);
                Option.of((Object)idpConfiguration).filter(idp -> idp.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idp.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idp.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL).peek(idp -> io.vavr.collection.HashMap.ofAll(idp.getUserProfileKeyMap()).filterValues(StringUtils::isNotBlank).mapValues(arg_0 -> ((io.vavr.collection.Map)rawUserAttributes).get(arg_0)).filterValues(Option::isDefined).mapValues(Option::get).forEach((key, value) -> this.hostApp.setUserProfileValue(foundUsername, (String)key, (String)value)));
                User user = this.hostApp.getCrowdService().getUser(evaluationResult.getFoundUsername());
                if (user != null) {
                    this.hostApp.setUserProperties(user, SsoLoginPostProcessor.getUserAttributesMap(evaluationResult.getAttributeInfos(), idpConfiguration), idpConfiguration.isRemoveUnusedUserAttributes());
                }
            }
            catch (Exception e) {
                this.log.debug("Failed to get user during setting user properties for user {}.", (Object)evaluationResult.getFoundUsername(), (Object)e);
            }
        }
    }

    private static Map<String, String> getUserAttributesMap(List<AttributeInfo> attributeInfos, IdpConfiguration idpConfiguration) {
        if (attributeInfos == null || attributeInfos.isEmpty()) {
            return null;
        }
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        for (AttributeInfo attributeInfo : attributeInfos) {
            if (!idpConfiguration.containsStoredUserAttribute(attributeInfo.getName())) continue;
            userAttributes.put(idpConfiguration.getStoredUserAttributeNameAlias(attributeInfo.getName()), attributeInfo.getValue());
        }
        return userAttributes;
    }

    SsoPostProcessingResult handleEmptyAttributeInfo(SsoPostProcessingResult ssoPostProcessingResult) {
        FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
        IdpConfiguration idpConfiguration = ssoPostProcessingResult.getIdpConfiguration();
        if (evaluationResult.getAttributeInfos().isEmpty()) {
            this.log.debug("The response did not contain username attributes");
            if (idpConfiguration.getUsernamePolicy() == IdpConfiguration.UsernamePolicy.KNOWN_DOMAINS_ANONYMOUS_BROWSING && idpConfiguration.isSsoProtectedAnonymousBrowsingEnabled()) {
                String message = "SSO-Verified Anonymous Access due to domain login restriction fallback";
                this.log.debug(message);
                return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.ANONYMOUS_BROWSING).build();
            }
            String message = "The response contained no attribute which could be used as usernames";
            return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage("The response contained no attribute which could be used as usernames").setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
        }
        AttributeInfo configuredUsernameAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
        if (configuredUsernameAttribute == null) {
            this.log.debug("The response did not contain the expected username attribute");
            if (idpConfiguration.getUsernamePolicy() != IdpConfiguration.UsernamePolicy.KNOWN_DOMAINS && idpConfiguration.isSsoProtectedAnonymousBrowsingEnabled()) {
                String message = "SSO-Verified Anonymous Access fallback when user not found";
                this.log.debug(message);
                return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.ANONYMOUS_BROWSING).build();
            }
            String message = "The response did not contain the expected username attribute";
            return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage("The response did not contain the expected username attribute").setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
        }
        if (evaluationResult.isUserDomainRejected()) {
            if (idpConfiguration.getUsernamePolicy() == IdpConfiguration.UsernamePolicy.KNOWN_DOMAINS) {
                String userDomain = evaluationResult.getUserDomain();
                Object message = userDomain != null ? "Identity provider does not allow logging in users from domain @" + userDomain : "Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain";
                return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage((String)message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
            }
            if (idpConfiguration.getUsernamePolicy() == IdpConfiguration.UsernamePolicy.KNOWN_DOMAINS_ANONYMOUS_BROWSING) {
                if (idpConfiguration.isSsoProtectedAnonymousBrowsingEnabled()) {
                    String message = String.format("Rejected user domain %s. Fallback to SSO-Verified Anonymous Access.", Option.of((Object)evaluationResult.getUserDomain()).getOrElse((Object)"because username doesn't end in a domain"));
                    this.log.debug(message);
                    return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.ANONYMOUS_BROWSING).build();
                }
                String message = String.format("Login " + (String)Option.of((Object)evaluationResult.getUserDomain()).map(domain -> "from " + domain + " not allowed.").getOrElse((Object)"not possible because username doesn't end in a domain"), new Object[0]);
                return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
            }
        }
        return SsoPostProcessingResult.of(ssoPostProcessingResult).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).build();
    }

    public SsoPostProcessingResult updateUser(SsoPostProcessingResult ssoPostProcessingResult) {
        AuthMethod protocol = ssoPostProcessingResult.getAuthMethod();
        IdpConfiguration idpConfiguration = ssoPostProcessingResult.getIdpConfiguration();
        FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
        PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
        IdpConfiguration.UserUpdateNamePolicy userUpdateNamePolicy = idpConfiguration.getUserUpdateNamePolicy();
        IdpConfiguration.UserUpdateEmailPolicy userUpdateEmailPolicy = idpConfiguration.getUserUpdateEmailPolicy();
        IdpConfiguration.UserActivatePolicy userActivatePolicy = idpConfiguration.getUserActivatePolicy();
        UserRecipe userRecipe = evaluationResult.getUserRecipe();
        GroupEvaluation groupEvaluation = evaluationResult.getGroupEvaluation();
        Optional<Directory> jitDirectory = this.hostApp.findJitDirectory(idpConfiguration.getJitDirectory());
        UserProfile userProfile = evaluationResult.getUserProfile();
        if (jitDirectory.isPresent()) {
            Directory directory = jitDirectory.get();
            if (userRecipe != null && userRecipe.isComplete()) {
                boolean isActive;
                String foundUsername = this.hostApp.normalizeUsername(evaluationResult.getFoundUsername());
                if (userProfile == null) {
                    this.log.debug("Userprofile was not found for {}, using attributes from {}", (Object)foundUsername, (Object)protocol.getAlias());
                }
                String fullname = userUpdateNamePolicy == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || userProfile == null ? userRecipe.getName().getValue() : userProfile.getFullName();
                String email = userUpdateEmailPolicy == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL || userProfile == null ? userRecipe.getEmail().getValue() : userProfile.getEmail();
                boolean bl = isActive = userActivatePolicy == IdpConfiguration.UserActivatePolicy.ACTIVATE && IdpConfManager.hasRequiredGroupsForCreationOrActivation(idpConfiguration, groupEvaluation) || principalEntry.getUserState() != PrincipalEntry.UserState.INACTIVE;
                if (idpConfiguration.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.ADVANCED && (ssoPostProcessingResult = this.handleAdvancedGroupRule(ssoPostProcessingResult)).getExitCondition() != SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING) {
                    return ssoPostProcessingResult;
                }
                this.hostApp.updateUser(directory, foundUsername, fullname, email, isActive);
                if (isActive && principalEntry.getPrincipal().isPresent()) {
                    Principal p = principalEntry.getPrincipal().get();
                    principalEntry = new PrincipalEntry(p, PrincipalEntry.UserState.FOUND);
                }
            } else {
                String errorMessage = this.createUserRecipeErrorMessageForUpdate(evaluationResult.getUserRecipe());
                return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(errorMessage).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
            }
        }
        return SsoPostProcessingResult.of(ssoPostProcessingResult).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).setPrincipalEntry(principalEntry).build();
    }

    @NotNull
    private String createUserRecipeErrorMessageForUpdate(UserRecipe userRecipe) {
        if (userRecipe == null) {
            return "Account cannot be updated because of missing user recipe";
        }
        if (userRecipe.getName() == null) {
            return "Account cannot be updated because no name attributes were included in the user info endpoint";
        }
        if (userRecipe.getEmail() == null) {
            return "Account cannot be updated because no email attribute was included in the user info endpoint";
        }
        return "Account cannot be updated because of incomplete user recipe";
    }

    SsoPostProcessingResult jitProvisioning(SsoPostProcessingResult processingRes) {
        if (processingRes.getJitSideEffect() == SsoPostProcessingResult.SsoJitSideEffect.CREATE_USER) {
            return this.createUser(processingRes);
        }
        if (processingRes.getJitSideEffect() == SsoPostProcessingResult.SsoJitSideEffect.UPDATE_USER) {
            return this.updateUser(processingRes);
        }
        return processingRes;
    }

    SsoPostProcessingResult decideLoginMethod(SsoPostProcessingResult ssoPostProcessingResult) {
        FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
        IdpConfiguration idpConfiguration = ssoPostProcessingResult.getIdpConfiguration();
        PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
        String username = evaluationResult.getSearchedUsername();
        SsoPostProcessingResult.Builder ssoProcessingResult = SsoPostProcessingResult.of(ssoPostProcessingResult);
        if (SsoLoginPostProcessor.userPrincipalExists(principalEntry)) {
            return ssoProcessingResult.setMessage("Post processing successful. Proceed to login.").setExitCondition(SsoPostProcessingResult.ExitCondition.SSO_LOGIN).build();
        }
        if (idpConfiguration.isSsoProtectedAnonymousBrowsingEnabled()) {
            String message = String.format("Principal for %s not found. Fallback to anonymous browsing", username);
            this.log.debug(message);
            return ssoProcessingResult.setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.ANONYMOUS_BROWSING).build();
        }
        String message = String.format("Account not found in %s for %s. Unable to authenticate user", this.applicationProperties.getDisplayName(), username);
        this.log.debug(message);
        return ssoProcessingResult.setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
    }

    private void addGroupsFromIdp(SsoPostProcessingResult ssoPostProcessingResult) {
        IdpConfiguration idpConfiguration = ssoPostProcessingResult.getIdpConfiguration();
        if (idpConfiguration.isCreateAllIncomingGroups()) {
            FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
            Set<String> idpGroups = evaluationResult.getGroupEvaluation().getAllIdpGroupNames();
            for (String idpGroup : idpGroups) {
                if (this.hostApp.isExistingGroup(idpGroup)) continue;
                this.hostApp.addGroup(idpGroup);
            }
        }
    }

    private void addUser(UserRecipe userRecipe, Directory dir, IdpConfiguration idpConfiguration, String usernameFromIdp, GroupEvaluation groupEvaluation) {
        try {
            this.hostApp.addUser(dir, this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()), userRecipe.getName().getValue(), userRecipe.getEmail().getValue(), idpConfiguration.getFilteredGroupsForUser(usernameFromIdp, groupEvaluation.getAllIdpGroupNames(), this.hostApp), true);
        }
        catch (UserAlreadyExistsException e) {
            this.log.warn("Was unable to create user {} with just-in-time provisioning because the user already exist locally. Make sure your user directores are synchronized. ", (Object)this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()));
        }
    }

    private SsoPostProcessingResult updateGroupMemberships(SsoPostProcessingResult ssoPostProcessingResult) {
        FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
        PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
        IdpConfiguration idpConfiguration = evaluationResult.getIdpConfiguration();
        String usernameFromIdp = evaluationResult.getSearchedUsername();
        GroupEvaluation groupEvaluation = evaluationResult.getGroupEvaluation();
        if (SsoLoginPostProcessor.userPrincipalExists(principalEntry) && principalEntry.getPrincipal().isPresent()) {
            Principal principal = principalEntry.getPrincipal().get();
            if (idpConfiguration.isCreateAllIncomingGroups() && !groupEvaluation.syncUserIdpGroups(this.hostApp, principal, idpConfiguration.isRemoveNonIdpGroupsFromUser(), idpConfiguration.getFilteredGroupsForUser(usernameFromIdp, groupEvaluation.getAllIdpGroupNames(), this.hostApp))) {
                String message = "Failed updating group memberships for user.";
                return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
            }
            Set<String> defaultGroupsForUser = idpConfiguration.getFilteredGroupsForUser(usernameFromIdp, groupEvaluation.getAllIdpGroupNames(), this.hostApp);
            if (groupEvaluation.setManagedGroups(this.hostApp, principal, defaultGroupsForUser) && groupEvaluation.setDefaultGroups(this.hostApp, principal, defaultGroupsForUser)) {
                return ssoPostProcessingResult;
            }
        }
        String message = "Not syncing group memberships because user not found. Continue processing.";
        this.log.debug(message);
        return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).build();
    }

    private SsoPostProcessingResult handleAdvancedGroupRule(SsoPostProcessingResult ssoPostProcessingResult) {
        GroupEvaluation groupEvaluation = ssoPostProcessingResult.getEvaluationResult().getGroupEvaluation();
        List<JitGroupRule> rules = ssoPostProcessingResult.getIdpConfiguration().getAdvancedGroupRules();
        rules.sort(Comparator.comparing(JitGroupRule::getPriority));
        io.vavr.collection.List idpGroupNames = (io.vavr.collection.List)Option.of((Object)groupEvaluation).flatMap(evaluation -> Option.of(evaluation.getAllIdpGroupNames())).map(io.vavr.collection.List::ofAll).getOrElse((Object)io.vavr.collection.List.empty());
        for (JitGroupRule rule : rules) {
            boolean match;
            if (rule.getGroups().isEmpty() || !rule.isEnabled()) continue;
            io.vavr.collection.List ruleGroups = io.vavr.collection.List.ofAll(rule.getGroups());
            if (rule.getComparisonType() == GroupComparisonType.IN) {
                match = ListParseUtils.isListIntersection((io.vavr.collection.List)idpGroupNames, (io.vavr.collection.List)ruleGroups);
            } else {
                boolean bl = match = !ListParseUtils.isListIntersection((io.vavr.collection.List)idpGroupNames, (io.vavr.collection.List)ruleGroups);
            }
            if (!match) continue;
            switch (rule.getResult()) {
                case LOGIN: {
                    return SsoPostProcessingResult.of(ssoPostProcessingResult).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).build();
                }
                case ANONYMOUS_BROWSING: {
                    return SsoPostProcessingResult.of(ssoPostProcessingResult).setExitCondition(SsoPostProcessingResult.ExitCondition.ANONYMOUS_BROWSING).build();
                }
                case DENY: {
                    return SsoPostProcessingResult.of(ssoPostProcessingResult).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).setMessage("Login denied due to advanced group based JIT rules").build();
                }
            }
        }
        return ssoPostProcessingResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SsoPostProcessingResult createUser(SsoPostProcessingResult ssoPostProcessingResult) {
        IdpConfiguration idpConfiguration = ssoPostProcessingResult.getIdpConfiguration();
        FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
        String usernameFromIdp = evaluationResult.getSearchedUsername();
        PrincipalEntry principalEntry = null;
        Optional<Directory> jitDirectory = this.hostApp.findJitDirectory(idpConfiguration.getJitDirectory());
        UserRecipe userRecipe = evaluationResult.getUserRecipe();
        SsoPostProcessingResult.Builder ssoProcessingResultBuilder = SsoPostProcessingResult.of(ssoPostProcessingResult);
        if (!jitDirectory.isPresent()) return ssoProcessingResultBuilder.setPrincipalEntry(principalEntry).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).build();
        Directory directory = jitDirectory.get();
        if (userRecipe != null && userRecipe.isComplete()) {
            try {
                if (IdpConfManager.hasRequiredGroupsForCreationOrActivation(idpConfiguration, evaluationResult.getGroupEvaluation())) {
                    if (idpConfiguration.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.ADVANCED && (ssoPostProcessingResult = this.handleAdvancedGroupRule(ssoPostProcessingResult)).getExitCondition() != SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING) {
                        return ssoPostProcessingResult;
                    }
                    this.addUser(userRecipe, directory, idpConfiguration, usernameFromIdp, evaluationResult.getGroupEvaluation());
                    principalEntry = new PrincipalEntry(this.userManager.resolve(userRecipe.getUsername().getValue()), PrincipalEntry.UserState.FOUND);
                    this.log.debug("Created account for IDP user " + String.valueOf(userRecipe.getUsername()));
                    return ssoProcessingResultBuilder.setPrincipalEntry(principalEntry).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).build();
                }
                if (idpConfiguration.isSsoProtectedAnonymousBrowsingEnabled()) {
                    return ssoProcessingResultBuilder.setMessage("Not creating user due to required groups. Fallback anonymous browsing").setExitCondition(SsoPostProcessingResult.ExitCondition.ANONYMOUS_BROWSING).build();
                }
                if (idpConfiguration.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.ANY_GROUP) {
                    String message = "Account could not be created. User did not have any groups in the response from " + idpConfiguration.getName();
                    return ssoProcessingResultBuilder.setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
                }
                if (idpConfiguration.getAutoCreateUserPolicy() != IdpConfiguration.AutoCreateUserPolicy.MATCHED_GROUPS) return ssoProcessingResultBuilder.setPrincipalEntry(principalEntry).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).build();
                String message = "Account could not be created. User did not have any matched auto create groups in the user info endpoint from " + idpConfiguration.getName();
                return ssoProcessingResultBuilder.setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
            }
            catch (Exception e) {
                UUID uuid = UUID.randomUUID();
                String message = "Failed creating account for IDP user " + userRecipe.getUsername().getValue() + " in directory \"" + directory.getName() + "\" (Log correlation ID: " + String.valueOf(uuid) + "). " + idpConfiguration.getMessageIfJitDirIsAD(userRecipe, this.hostApp);
                this.log.error(message, (Throwable)e);
                return ssoProcessingResultBuilder.setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
            }
        } else {
            String message = ResponseEvaluator.createUserRecipeErrorMessage(userRecipe);
            return ssoProcessingResultBuilder.setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
        }
    }

    private boolean userDirectoryMatchesJitDirectory(Directory directory, FederatedIdentityResponseEvaluationResult evaluationResult) {
        return directory.getId().equals(evaluationResult.getResolvedUserDirectory().getId());
    }

    SsoPostProcessingResult evaluateJitPolicies(SsoPostProcessingResult ssoPostProcessingResult) {
        FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
        IdpConfiguration idpConfiguration = ssoPostProcessingResult.getIdpConfiguration();
        PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
        Optional<Directory> jitDirectory = this.hostApp.findJitDirectory(idpConfiguration.getJitDirectory());
        if (this.shouldDoJitUpdateUser(jitDirectory, evaluationResult, principalEntry, idpConfiguration)) {
            return SsoPostProcessingResult.of(ssoPostProcessingResult).setJitSideEffect(SsoPostProcessingResult.SsoJitSideEffect.UPDATE_USER).build();
        }
        if (SsoLoginPostProcessor.shouldDoJitCreateUser(jitDirectory, idpConfiguration, principalEntry)) {
            return SsoPostProcessingResult.of(ssoPostProcessingResult).setJitSideEffect(SsoPostProcessingResult.SsoJitSideEffect.CREATE_USER).build();
        }
        if (!jitDirectory.isPresent() && SsoLoginPostProcessor.hasJitPoliciesConfigured(idpConfiguration)) {
            String errorMessage = String.format("Could not create, activate or update user %s with Just-in-time provisioning (JIT). JIT directory is not specified.", evaluationResult.getSearchedUsername());
            this.log.error(errorMessage);
            return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(errorMessage).setExitCondition(SsoPostProcessingResult.ExitCondition.LOGIN_FAILED).build();
        }
        String message = "Skipping JIT  provisioning.";
        this.log.debug(message);
        return SsoPostProcessingResult.of(ssoPostProcessingResult).setMessage(message).setExitCondition(SsoPostProcessingResult.ExitCondition.CONTINUE_PROCESSING).setJitSideEffect(SsoPostProcessingResult.SsoJitSideEffect.NONE).build();
    }

    private static boolean shouldDoJitCreateUser(Optional<Directory> jitDirectory, IdpConfiguration idpConfiguration, PrincipalEntry principalEntry) {
        return jitDirectory.isPresent() && !SsoLoginPostProcessor.userPrincipalExists(principalEntry) && idpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE;
    }

    private static boolean userPrincipalExists(PrincipalEntry principalEntry) {
        return principalEntry != null && principalEntry.getPrincipal().isPresent();
    }

    private static boolean hasJitPoliciesConfigured(IdpConfiguration idpConfiguration) {
        return idpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idpConfiguration.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idpConfiguration.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL || idpConfiguration.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE;
    }

    private boolean shouldDoJitUpdateUser(Optional<Directory> jitDirectory, FederatedIdentityResponseEvaluationResult evaluationResult, PrincipalEntry principalEntry, IdpConfiguration idpConfiguration) {
        return jitDirectory.isPresent() && SsoLoginPostProcessor.userPrincipalExists(principalEntry) && this.userDirectoryMatchesJitDirectory(jitDirectory.get(), evaluationResult) && SsoLoginPostProcessor.isUserStateFoundOrInactive(principalEntry) && SsoLoginPostProcessor.hasJitUpdateUserPolicyConfigured(idpConfiguration);
    }

    private static boolean hasJitUpdateUserPolicyConfigured(IdpConfiguration idpConfiguration) {
        return idpConfiguration.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idpConfiguration.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL || idpConfiguration.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE;
    }

    private static boolean isUserStateFoundOrInactive(PrincipalEntry principalEntry) {
        return principalEntry.getUserState() == PrincipalEntry.UserState.FOUND || principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE;
    }
}

