/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.ksso.scim.ScimProviderKind;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.CertsServlet;
import org.kantega.atlaskerb.wrapper.upm.PluginLicenseWrapper;

public class DashboardAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;

    @Inject
    public DashboardAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        this.idpConfManager.readState();
        this.connectorConfManager.readState();
        model.put("topMenu", "dashboard");
        model.put("menuItem", "dashboard");
        model.put("applicationProperties", this.applicationProperties);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("providerKinds", IdpConfiguration.Kind.getValues());
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("scimTenantConfigKinds", Arrays.asList(ScimProviderKind.values()));
        Properties buildInfo = KerbConfManager.getBuildInfo();
        model.put("version", buildInfo.getProperty("build.version"));
        model.put("buildDate", buildInfo.getProperty("build.date"));
        String kssoBuildPipelineId = buildInfo.getProperty("ksso.build.pipeline.id");
        String kssoBuildPipelineUrl = buildInfo.getProperty("ksso.build.pipeline.url");
        String kssoGitCommitId = buildInfo.getProperty("ksso.build.git.commit.id");
        String kssoGitCommitMoreDetails = buildInfo.getProperty("ksso.build.git.commit.moredetails");
        model.put("kssoBuildPipelineId", StringUtils.isNotBlank((CharSequence)kssoBuildPipelineId) ? kssoBuildPipelineId : null);
        model.put("kssoBuildPipelineUrl", StringUtils.isNotBlank((CharSequence)kssoBuildPipelineUrl) ? kssoBuildPipelineUrl : null);
        model.put("kssoGitCommitId", StringUtils.isNotBlank((CharSequence)kssoGitCommitId) ? kssoGitCommitId : null);
        if (!StringUtils.equals((CharSequence)kssoGitCommitId, (CharSequence)kssoGitCommitMoreDetails)) {
            model.put("kssoGitCommitMoreDetails", StringUtils.isNotBlank((CharSequence)kssoGitCommitMoreDetails) ? kssoGitCommitMoreDetails : null);
        }
        try {
            this.checkNonstandardSeraphAuthenticator(model);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CertsServlet.checkSigningKeyPassword(model, this.idpConfManager);
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicenseWrapper licenseWrapper = new PluginLicenseWrapper((PluginLicense)this.pluginLicenseManager.getLicense().get());
            model.put("license", licenseWrapper);
        }
        try {
            this.templateRenderer.render("templates/atlaskerb/dashboard.vm", model, (Writer)resp.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkNonstandardSeraphAuthenticator(Map<String, Object> model) {
        String nonStandardAuthenticator = this.hostApp.hasNonStandardAuthenticator();
        if (nonStandardAuthenticator != null) {
            model.put("nonStandardSeraphAuthenticator", nonStandardAuthenticator);
            model.put("standardSeraphAuthenticator", this.hostApp.getStandardAuthenticatorClassName());
        }
    }
}

