/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.kerberos.servlet.TestKerberosAction;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class IdpSetupServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;

    @Inject
    public IdpSetupServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "idpsetup");
        model.put("idp", configuration);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("serviceURL", this.idpConfManager.getServiceProviderLoginUrl(req, id));
        model.put("metadataURL", this.idpConfManager.getServiceProviderMetadataUrl(req, id));
        model.put("logoutURL", this.idpConfManager.getServiceProviderLogoutServiceUrl(req, id));
        model.put("downloadCertURL", this.idpConfManager.getSAMLRequestCertUrl(req));
        model.put("certPem", CertTool.formatCertificate(Base64.encodeBase64String((byte[])this.idpConfManager.getSigningCert())));
        TestKerberosAction.checkSupportedBrowser(model, req.getHeader("User-Agent"));
        this.getTemplateRenderer().render("templates/saml/saml-idp-setup.vm", model, (Writer)resp.getWriter());
    }
}

