/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.jsonmapping.JsonMapping;
import com.kantegasso.oidc.OidcData;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class TestUtils {
    public static Try<String> readOidcProcedureJsonRepresentationFromFile(File oidcProcedureFile) {
        return JsonMapping.Read.jsonObjectFromFile((File)oidcProcedureFile).mapTry(JSONObject::toString);
    }

    public static boolean isTest(HttpServletRequestFacade request) {
        return List.of((Object[])new String[]{"test", "runtest"}).map(urlParam -> Option.of((Object)request.getParameter(urlParam))).filter(Option::isDefined).nonEmpty();
    }

    public static boolean isTest(OidcData oidcData) {
        return (Boolean)oidcData.get("ksso:is_test", Boolean.class).getOrElse((Object)false);
    }

    public static <A> String testIdFromOidcData(Either<A, OidcData> maybeOidcData) {
        return (String)maybeOidcData.map(TestUtils::testIdFromOidcData).get();
    }

    public static String testIdFromOidcData(OidcData oidcData) {
        return (String)oidcData.get("state").get();
    }

    public static Try<Void> recordTestFailedBeforeRequest(OidcIdpConfiguration idpConfig, IdpConfManager idpConfManager, Either<String, OidcData> maybeOidcData, ErrorUtils.KssoError error, ResponseEvaluationCode evaluationCode) {
        return Try.run(() -> idpConfManager.recordTestOidcDataBeforeRequest(idpConfig.getId(), TestUtils.testIdFromOidcData(maybeOidcData), (OidcData)maybeOidcData.get(), error, evaluationCode));
    }

    public static Try<Void> recordTestProcedureBeforeRequest(OidcIdpConfiguration idpConfig, IdpConfManager idpConfManager, OidcData oidcData, ResponseEvaluationCode evaluationCode) {
        String state = TestUtils.testIdFromOidcData(oidcData);
        return Try.run(() -> idpConfManager.recordTestOidcProcedureBeforeRequest(idpConfig.getId(), state, oidcData, evaluationCode));
    }

    public static Try<Void> recordTestFailedAfterResponse(OidcIdpConfiguration idpConfig, IdpConfManager idpConfManager, OidcData oidcData, ErrorUtils.KssoError error, ResponseEvaluationCode evaluationCode) {
        return Try.run(() -> idpConfManager.recordTestOidcDataAfterResponse(idpConfig.getId(), TestUtils.testIdFromOidcData(oidcData), oidcData, error, evaluationCode));
    }

    public static Try<Void> recordTestProcedureAfterResponse(OidcIdpConfiguration idpConfig, IdpConfManager idpConfManager, OidcData oidcData, ResponseEvaluationCode evaluationCode) {
        return Try.run(() -> idpConfManager.recordTestOidcProcedureAfterResponse(idpConfig.getId(), TestUtils.testIdFromOidcData(oidcData), oidcData, evaluationCode));
    }

    public static void renderTestResult(HttpServletRequestFacade req, HttpServletResponseFacade resp, IdpConfiguration idpConfig, IdpConfManager idpConfManager, UserManager userManager, String testId) throws IOException {
        resp.sendRedirect(TestUtils.testResultURL(req, idpConfig, idpConfManager, userManager, testId));
    }

    public static String testResultURL(HttpServletRequestFacade req, IdpConfiguration idpConfig, IdpConfManager idpConfManager, UserManager userManager, String testId) {
        Try uriBuilder;
        if (HttpUrlUtils.isSystemAdmin((UserManager)userManager, (HttpServletRequestFacade)req)) {
            String evaluateTestUrl = idpConfManager.getServiceProviderEvaluateTestUrl(req, idpConfig.getId()) + "/" + testId + "/result";
            uriBuilder = Try.of((CheckedFunction0 & Serializable)() -> evaluateTestUrl).mapTry(URIBuilder::new);
        } else {
            uriBuilder = Try.of((CheckedFunction0 & Serializable)() -> idpConfManager.getServiceProviderNonAdminTestUrl(req, idpConfig.getId())).mapTry(URIBuilder::new).mapTry((CheckedFunction1 & Serializable)builder -> builder.addParameter("ack", "true")).mapTry((CheckedFunction1 & Serializable)builder -> builder.addParameter("testID", testId));
        }
        String location = (String)uriBuilder.mapTry(URIBuilder::build).mapTry(URI::toString).getOrElseThrow(throwable -> new RuntimeException(ErrorUtils.createKssoError((String)"KSSO-UGYKG1O5ZH", (String)"Failed to show test results: ").asMessage() + throwable));
        return location;
    }
}

