/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConnectorURIBuilder {
    private final Map<String, String> queryParams = new LinkedHashMap<String, String>();
    private final String baseUrl;
    private final String path;

    private ConnectorURIBuilder(String baseUrl, String path) {
        this.baseUrl = baseUrl;
        this.path = path;
    }

    public static ConnectorURIBuilder builder(String uri) {
        try {
            URI p = new URI(uri);
            int port = p.getPort();
            String baseUrl = p.getScheme() + "://" + p.getHost();
            if (port > 0) {
                baseUrl = baseUrl + ":" + port;
            }
            String path = (String)StringUtils.defaultIfBlank((CharSequence)p.getPath(), (CharSequence)"");
            ConnectorURIBuilder builder = new ConnectorURIBuilder(baseUrl, path);
            String query = p.getQuery();
            if (query != null) {
                String[] keyValues;
                for (String keyValue : keyValues = query.split("&")) {
                    String[] kv = keyValue.split("=");
                    builder.queryParam(kv[0], kv[1]);
                }
            }
            return builder;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ConnectorURIBuilder queryParam(String key, String value) {
        this.queryParams.put(this.encode(key), this.encode(value));
        return this;
    }

    public String toString(boolean relative) {
        String result = relative ? this.path : this.baseUrl + this.path;
        String queryString = this.queryParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        if (!StringUtils.isBlank((CharSequence)queryString)) {
            result = result + "?" + queryString;
        }
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

