/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradePluginSettingsEntryResult;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;

public class ConfigureIpRestrictionsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final KssoUpgradeManager kssoUpgradeManager;

    @Inject
    public ConfigureIpRestrictionsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kssoUpgradeManager = bucket.getKssoUpgradeManager();
    }

    public static void populateModel(Map<String, Object> model, IpRestrictionConfig restrictionCfg) {
        model.putIfAbsent("globalIpRestrictionType", restrictionCfg.getGlobalRestrictionType().name());
        model.putIfAbsent("globalIpUnblockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines((String[])restrictionCfg.getGlobalIpUnblockedList())));
        model.putIfAbsent("globalIpBlockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines((String[])restrictionCfg.getGlobalIpBlockedList())));
        model.putIfAbsent("restIpRestrictionType", restrictionCfg.getRestRestrictionType().name());
        model.putIfAbsent("restIpUnblockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines((String[])restrictionCfg.getRestIpUnblockedList())));
        model.putIfAbsent("restIpBlockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines((String[])restrictionCfg.getRestIpBlockedList())));
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.doCommonModelSetup(req, model);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ip-restrict.vm", model, (Writer)resp.getWriter());
    }

    private boolean hasUpgradeFailures() {
        return this.kssoUpgradeManager.getUpgradeFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.REST_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST);
    }

    protected void doCommonModelSetup(HttpServletRequestFacade req, Map<String, Object> model) {
        String enforceIP = this.kerbConfManager.getRemoteIpAddress(req);
        IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
        model.putIfAbsent("isIpValidGlobal", restrictionCfg.getGlobalIpFilter().isRemoteAddressEnabled(enforceIP));
        model.putIfAbsent("isIpValidRest", restrictionCfg.getRestIpFilter().isRemoteAddressEnabled(enforceIP));
        ConfigureIpRestrictionsAction.populateModel(model, restrictionCfg);
        model.putIfAbsent("restAuthEnabled", this.kerbConfManager.isKerberosRestAuthEnabled());
        model.putIfAbsent("isProxied", this.kerbConfManager.getPreferredProxyHeader() != null);
        model.putIfAbsent("enforceIP", enforceIP);
        model.putIfAbsent("userIP", req.getRemoteAddr());
        model.putIfAbsent("xForwardedFor", req.getHeader("X-Forwarded-For"));
        model.putIfAbsent("hasRemoteIpValve", HttpUrlUtils.isRemoteIpValveConfigured());
        model.putIfAbsent("displayName", this.applicationProperties.getDisplayName());
        model.putIfAbsent("hasUpgradeFailures", this.hasUpgradeFailures());
        if (this.hasUpgradeFailures()) {
            this.addDataFromConfigUpgrade(model);
        }
    }

    private void addDataFromConfigUpgrade(Map<String, Object> model) {
        List<UpgradePluginSettingsEntryResult> updateFailures = this.kssoUpgradeManager.getUpgradeFailures();
        Option previousVersion = updateFailures.headOption().flatMap(UpgradePluginSettingsEntryResult::maybeVersion);
        previousVersion.peek(version -> {
            model.put("upgradedGlobalUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST : KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST));
            model.put("globalUnblockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST : KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST));
            model.put("upgradedGlobalBlockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST : KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST));
            model.put("globalBlockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST : KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST));
            model.put("upgradedRestUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST : KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST));
            model.put("restUnblockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST : KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST));
            model.put("upgradedRestBlockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.REST_IP_BLOCKEDLIST : KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST));
            model.put("restBlockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.REST_IP_BLOCKEDLIST : KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST));
        }).onEmpty(() -> {
            model.put("upgradedGlobalUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST));
            model.put("globalUnblockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST));
            model.put("upgradedGlobalBlockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST));
            model.put("globalBlockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST));
            model.put("upgradedRestUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST));
            model.put("restUnblockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST));
            model.put("upgradedRestBlockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST));
            model.put("restBlockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST));
        });
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (req.getParameter("iprestrict") != null) {
            Map<String, Object> model = this.newModel(req);
            String globalType = req.getParameter("global_type");
            String globalUnblockedList = req.getParameter("global_unblockedlist");
            String globalBlockedList = req.getParameter("global_blockedlist");
            Option.of((Object)globalType).toTry().mapTry(KerbConfManager.IpRestrictionType::valueOf).peek(this.kerbConfManager::setGlobalIpRestrictionType);
            Option globalUnblockedPermissions = Option.of((Object)globalUnblockedList).orElse(Option.of((Object)"")).map(InternetAddressUtils::softNormalizeIpRestrictions).filter(InternetAddressUtils::isValidExistingPermissionList).onEmpty(() -> {
                if (!this.hasUpgradeFailures()) {
                    model.put("globalIpUnblockedlist", globalUnblockedList);
                }
                model.put("globalRegexError", "true");
                model.put("globalRegexFailedUnblockedList", true);
                model.put("invalidDataInGlobalIpUnblockedlist", Option.of((Object)globalUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull());
            }).peek(_list -> {
                if (this.hasUpgradeFailures()) {
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST);
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setGlobalIpUnblockedList);
            Option globalBlockedPermissions = Option.of((Object)globalBlockedList).orElse(Option.of((Object)"")).map(InternetAddressUtils::softNormalizeIpRestrictions).filter(InternetAddressUtils::isValidExistingPermissionList).onEmpty(() -> {
                if (!this.hasUpgradeFailures()) {
                    model.put("globalIpBlockedlist", globalBlockedList);
                }
                model.put("globalRegexFailedBlockedList", "global blocked list");
                model.put("invalidDataInGlobalIpBlockedlist", Option.of((Object)globalBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull());
                model.put("globalRegexError", "true");
            }).peek(_list -> {
                if (this.hasUpgradeFailures()) {
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST);
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setGlobalIpBlockedList);
            String restType = req.getParameter("rest_type");
            String restUnblockedList = req.getParameter("rest_unblockedlist");
            String restBlockedList = req.getParameter("rest_blockedlist");
            Option.of((Object)restType).toTry().mapTry(KerbConfManager.IpRestrictionType::valueOf).peek(this.kerbConfManager::setRestIpRestrictionType);
            Option restUnblockedPermissions = Option.of((Object)restUnblockedList).orElse(Option.of((Object)"")).map(InternetAddressUtils::softNormalizeIpRestrictions).filter(InternetAddressUtils::isValidExistingPermissionList).onEmpty(() -> {
                if (!this.hasUpgradeFailures()) {
                    model.put("restIpUnblockedlist", restUnblockedList);
                }
                model.put("restRegexError", "true");
                model.put("invalidDataInRestIpUnblockedlist", Option.of((Object)restUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull());
                model.put("restRegexFailedUnblockedList", true);
            }).peek(_list -> {
                if (this.hasUpgradeFailures()) {
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST);
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setRestIpUnblockedList);
            Option restBlockedPermissions = Option.of((Object)restBlockedList).orElse(Option.of((Object)"")).map(InternetAddressUtils::softNormalizeIpRestrictions).filter(InternetAddressUtils::isValidExistingPermissionList).onEmpty(() -> {
                if (!this.hasUpgradeFailures()) {
                    model.put("restIpBlockedlist", restBlockedList);
                }
                model.put("restRegexError", "true");
                model.put("restRegexFailedBlockedList", true);
                model.put("invalidDataInRestIpBlockedlist", Option.of((Object)restBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull());
            }).peek(_list -> {
                if (this.hasUpgradeFailures()) {
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST);
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.REST_IP_BLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setRestIpBlockedlist);
            boolean success = List.of((Object[])new Option[]{globalBlockedPermissions, globalUnblockedPermissions, restBlockedPermissions, restUnblockedPermissions}).forAll(Option::isDefined);
            if (success) {
                resp.sendRedirect("iprestrict");
            } else {
                this.doCommonModelSetup(req, model);
                resp.setContentType("text/html");
                this.renderer.render("templates/atlaskerb/ip-restrict.vm", model, (Writer)resp.getWriter());
            }
            return;
        }
        String forwarded = req.getParameter("forwarded");
        if (forwarded != null) {
            this.kerbConfManager.setPreferredProxyHeader("YES".equals(forwarded) ? "x-forwarded-for" : null);
            resp.sendRedirect("iprestrict");
        }
    }
}

