/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.oidc.OidcData;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public class SingleLogoutConfigServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final ApplicationProperties applicationProperties;
    private final OidcLibWrapper oidcLibWrapper;

    @Inject
    public SingleLogoutConfigServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.oidcLibWrapper = bucket.getOidcFactory().createOidcLibWrapper(bucket.getJsonWrapper());
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String action = req.getParameter("action");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (StringUtils.equals((CharSequence)"editSingleLogout", (CharSequence)action)) {
            boolean singleLogoutEnabled = StringUtils.equals((CharSequence)req.getParameter("singleLogoutEnabled"), (CharSequence)"on");
            IdpConfigurationBuilder builder = configuration.fold(oidc -> {
                IdpConfigurationBuilder.Oidc oidcBuilder = IdpConfigurationBuilder.of(oidc);
                if (singleLogoutEnabled) {
                    OidcIdpConfiguration oidcConf = (OidcIdpConfiguration)configuration;
                    Either maybeOidcData = this.oidcLibWrapper.createOidcData((HashMap<String, Object>)HashMap.of((Object)"discovery_url", (Object)oidcConf.getDiscoveryUrl(), (Object)"workaround", (Object)oidcConf.getOidcLibRepresentation())).flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? this.oidcLibWrapper.discover((OidcData)data) : Either.right((Object)data));
                    if (maybeOidcData.isRight()) {
                        String sessionEndpoint = (String)((OidcData)maybeOidcData.get()).get("end_session_endpoint").getOrNull();
                        boolean oidcSloProbablySupported = HttpUrlUtils.isValidAndNonEmptyUri((String)sessionEndpoint);
                        model.put("oidcSloNotSupported", !oidcSloProbablySupported);
                        model.put("oidcSuccessfullyEnabled", oidcSloProbablySupported);
                        return (IdpConfigurationBuilder)oidcBuilder.setSingleLogoutEnabled(oidcSloProbablySupported);
                    }
                    model.put("errorMessageFromOidc", maybeOidcData.getLeft());
                }
                return (IdpConfigurationBuilder)oidcBuilder.setSingleLogoutEnabled(false);
            }, saml -> {
                SAMLSessionIdentification.ValidationPolicy validationPolicy = (SAMLSessionIdentification.ValidationPolicy)Option.of((Object)req.getParameter("sessionIdentificationValidationPolicy")).map(SAMLSessionIdentification.ValidationPolicy::valueOf).getOrElse(SAMLSessionIdentification.ValidationPolicy::getDefault);
                String logoutServiceUrl = StringUtils.trim((String)req.getParameter("logoutUrl"));
                return (IdpConfigurationBuilder)IdpConfigurationBuilder.of(saml).setSessionIdValidationPolicy(validationPolicy).setIdpSingleLogoutServiceURL(logoutServiceUrl).setSingleLogoutEnabled(singleLogoutEnabled);
            });
            String logoutReturnUrl = StringUtils.trimToNull((String)req.getParameter("logoutReturnUrl"));
            builder.setSingleLogoutReturnURL(logoutReturnUrl);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        this.renderPage(req, resp, model);
    }

    private void validateSingleLogoutURL(Map<String, Object> model, boolean singleLogoutEnabled, String logoutUrl) {
        if (singleLogoutEnabled && (StringUtils.isBlank((CharSequence)logoutUrl) || !HttpUrlUtils.validateURI((String)logoutUrl))) {
            model.put("invalidIdpSingleLogoutServiceURL", true);
        }
    }

    private void renderPage(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        configuration.ifSaml(samlConf -> {
            model.put("sessionIdentificationValidationPolicy", Option.of((Object)samlConf.getSessionIdentificationValidationPolicy()).getOrElse(SAMLSessionIdentification.ValidationPolicy::getDefault));
            this.validateSingleLogoutURL(model, samlConf.isSingleLogoutEnabled(), samlConf.getSingleLogoutServiceURL());
        });
        configuration.ifOidc(oidcConf -> model.put("transformedReturnUrl", HttpUrlUtils.transformToAbsoluteUrl((String)oidcConf.getSingleLogoutReturnURL(), (ApplicationProperties)this.applicationProperties)));
        model.put("topMenu", "SAML");
        model.put("menuItem", "singlelogout");
        model.put("idp", configuration);
        model.put("serviceProviderLogoutServiceURL", this.idpConfManager.getServiceProviderLogoutServiceUrl(req, id));
        model.put("kerberosConfigured", this.kerbConfManager.isKeytabConfigured());
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.getTemplateRenderer().render("templates/saml/saml-idp-single-logout.vm", model, (Writer)resp.getWriter());
    }
}

