/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.web.context.HttpContext;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.wrapper.web.ConditionWrapper;

public class InjectActionsCondition
extends ConditionWrapper {
    private final HostApp hostApp;
    private Set<String> products;
    private final HttpContext httpContext;
    private String urlEndsWith;

    @Inject
    public InjectActionsCondition(@ComponentImport HttpContext httpContext, HostAppFactory hostApp) {
        this.hostApp = hostApp.getInstance();
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> params) {
        this.urlEndsWith = params.get("urlEndsWith");
        String products = params.get("products");
        if (products != null) {
            this.products = new HashSet<String>(Arrays.asList(products.trim().split("\\s*,\\s*")));
        }
    }

    public boolean shouldDisplayInternal(Map<String, Object> parameters) {
        return this.shouldDoInject(HttpServletRequestFacade.of((HttpServletRequest)this.httpContext.getRequest()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProductMatch() {
        if (this.products == null) return false;
        if (!this.products.stream().anyMatch(this.hostApp::isProductMatch)) return false;
        return true;
    }

    public boolean shouldDoInject(HttpServletRequestFacade request) {
        return this.isProductMatch() && request != null && (this.urlEndsWith == null || request.getRequestURI().endsWith(this.urlEndsWith));
    }
}

