/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.config.ConfigurationException;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.UUID;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.cleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsmCleanupJobRunner
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(String.valueOf(JsmCleanupJobRunner.class) + ".job"));
    private static final Logger log = LoggerFactory.getLogger(JsmCleanupJobRunner.class);
    private final HostApp hostApp;

    @Inject
    public JsmCleanupJobRunner(HostAppFactory hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            log.info(String.format("JsmCleanup: Starting scheduled run, previous CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
            if (this.hostApp.getJsmCleanupExecuteStatus() == InactiveUserCleaner.CleanupStatus.RUNNING) {
                log.warn(String.format("JsmCleanup: Scheduled run did not start since a cleanup is already running, CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
                return JobRunnerResponse.aborted((String)"Cleanup already running");
            }
            this.hostApp.setJsmCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.RUNNING);
            this.hostApp.cleanupInactiveUsers(null, new DryRunAttributes(false, false, true), DateTime.now(), UUID.randomUUID().toString());
        }
        catch (ConfigurationException e) {
            this.hostApp.setJsmCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.FAILED);
            log.error(String.format("JsmCleanup: Scheduled run failed, current CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
            return JobRunnerResponse.failed((Throwable)e);
        }
        this.hostApp.setJsmCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.SUCCESS);
        log.info(String.format("JsmCleanup: Scheduled run succeeded, current CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
        return JobRunnerResponse.success();
    }
}

