/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.ServiceProviderFactory;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.springframework.stereotype.Component;

@Component
public class AtlSpServletSupport {
    private final IdpConfManager idpConfManager;
    private final ServiceProviderFactory serviceProviderFactory;
    private final TemplateRenderer renderer;

    @Inject
    AtlSpServletSupport(IdpConfManager idpConfManager, ServiceProviderFactory serviceProviderFactory, TemplateRenderer renderer) {
        this.idpConfManager = idpConfManager;
        this.serviceProviderFactory = serviceProviderFactory;
        this.renderer = renderer;
    }

    public static Optional<String> getSpId(HttpServletRequestFacade req, String pathPrefix, String pathPostfix) {
        int start;
        String requestURI = req.getRequestURI();
        int end = requestURI.indexOf(pathPostfix, start = req.getContextPath().length() + pathPrefix.length());
        if (end == -1) {
            return Optional.empty();
        }
        String id = requestURI.substring(start, end);
        String postfix = requestURI.substring(end);
        if (!pathPostfix.equals(postfix)) {
            return Optional.empty();
        }
        return Optional.of(id);
    }

    public Optional<ServiceProviderSpi> getServiceProviderSpi(String id) {
        return Optional.ofNullable((SamlIdpConfiguration)this.idpConfManager.getIdentityProviderById(id)).map(this.serviceProviderFactory::getInstance);
    }

    public Optional<IdpConfiguration> getIdpConfig(String id) {
        return Optional.ofNullable(this.idpConfManager.getEnabledIdentityProviderById(id));
    }

    public Optional<IdpConfiguration> getIdpConfigForTest(String id) {
        return Optional.ofNullable(this.idpConfManager.getIdentityProviderById(id));
    }

    public void renderNotFound(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        resp.setStatus(404);
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("providerURL", req.getRequestURI());
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
        this.renderer.render("templates/saml/login-error-not-found.vm", model, (Writer)resp.getWriter());
    }
}

