/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.backup.BackupService;
import org.kantega.atlaskerb.config.ConfigNameSpaces;

public class RestoreBackupAction
extends RequireAdminServlet {
    private final BackupService backupService;
    private final TemplateRenderer renderer;

    @Inject
    public RestoreBackupAction(RequireAdminServletDependencyBucket bucket, BackupService backupService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.backupService = backupService;
    }

    private void renderPage(HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("configOptions", ConfigNameSpaces.ConfigSubset.getValues());
        model.put("topMenu", "dashboard");
        model.put("menuItem", "backup");
        model.put("dateTool", new DateTool());
        this.renderer.render("templates/atlaskerb/backup/restore.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String filenameInput = FilenameUtils.getName((String)req.getParameter("filename"));
        Option<File> maybeBackupFile = this.backupService.getBackupFile(filenameInput);
        if (maybeBackupFile.isDefined()) {
            File backupFile = (File)maybeBackupFile.get();
            if (!backupFile.canRead()) {
                model.put("unreadable", true);
                this.renderPage(resp, model);
                return;
            }
            BackupInfo backup = this.backupService.findBackup(filenameInput);
            if (backup != null) {
                if (req.getParameter("restore") != null) {
                    HashSet<ConfigNameSpaces.ConfigSubset> configOptions = new HashSet<ConfigNameSpaces.ConfigSubset>();
                    for (ConfigNameSpaces.ConfigSubset option : ConfigNameSpaces.ConfigSubset.values()) {
                        if (req.getParameter(option.key) == null) continue;
                        configOptions.add(option);
                    }
                    this.backupService.restoreFromFile(backupFile, req.getParameter("makeBackup") != null, configOptions);
                    resp.sendRedirect("backup?restored");
                } else {
                    String pluginVersion = PluginKey.getVersion();
                    model.put("pluginVersion", pluginVersion);
                    boolean canRestore = pluginVersion.contains("-SNAPSHOT") || pluginVersion.equals(backup.getPluginVersion());
                    model.put("canRestore", canRestore);
                    model.put("backup", backup);
                    this.renderPage(resp, model);
                }
                return;
            }
        }
        resp.sendRedirect("backup");
    }
}

