/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.proxy;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class ProxyIpRuleServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final KerbConfManager kerbConfManager;

    @Inject
    public ProxyIpRuleServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ip-proxy-rule.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        HashMap<String, Object> protoModel = new HashMap<String, Object>();
        String forwarded = req.getParameter("forwarded");
        if (forwarded != null) {
            this.kerbConfManager.setPreferredProxyHeader("YES".equals(forwarded) ? "x-forwarded-for" : null);
            this.buildModelAndRenderTemplate(req, resp, protoModel);
        }
    }

    private void buildModelAndRenderTemplate(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> protoModel) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ip-proxy-rule.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequestFacade req) {
        Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        model.put("topMenu", "dashboard");
        model.put("menuItem", "api-tokens");
        model.put("displayName", this.applicationProperties.getDisplayName());
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        model.put("remoteIpAddress", remoteIpAddress);
        model.put("isKerberosEnabledAndConfigured", this.kerbConfManager.isKerberosEnabled() && this.kerbConfManager.isKeytabConfigured());
        model.put("isKerberosRemoteAddressEnabled", ipRestrictionConfig.getGlobalIpFilter().isRemoteAddressEnabled(remoteIpAddress));
        model.put("isKerberosForRestEnabled", this.kerbConfManager.isKerberosRestAuthEnabled());
        model.put("isKerberosForRestRemoteAddressEnabled", ipRestrictionConfig.getRestIpFilter().isRemoteAddressEnabled(remoteIpAddress));
        model.put("isApiTokenRemoteAddressEnabled", ipRestrictionConfig.getApiTokenFilter().isRemoteAddressEnabled(remoteIpAddress));
        model.put("isBasicAuthEnabledForAll", this.kerbConfManager.getBasicAuthPermissionType() == KerbConfManager.BasicAuthUserPermissionType.ENABLE_ALL_USERS);
        model.put("isBasicAuthEnabledForSome", this.kerbConfManager.getBasicAuthPermissionType() != KerbConfManager.BasicAuthUserPermissionType.DISABLE_ALL_USERS);
        model.put("isBasicAuthRemoteAddressEnabled", ipRestrictionConfig.getBasicAuthFilter().isRemoteAddressEnabled(remoteIpAddress));
        model.put("isProxied", this.kerbConfManager.getPreferredProxyHeader() != null);
        model.put("userIP", req.getRemoteAddr());
        model.put("xForwardedFor", req.getHeader("X-Forwarded-For"));
        model.put("hasRemoteIpValve", HttpUrlUtils.isRemoteIpValveConfigured());
        return model;
    }
}

