/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class ConfigureCrowdAutoAddGroupsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public ConfigureCrowdAutoAddGroupsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String crowdAutoAddGroups = this.kerbConfManager.getCrowdAutoAddGroups();
        model.put("crowdAutoAddGroups", crowdAutoAddGroups);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/crowd-auto-add-groups.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String crowdAutoAddGroups = req.getParameter("crowdAutoAddGroups").trim();
        if (crowdAutoAddGroups.isEmpty()) {
            crowdAutoAddGroups = null;
        }
        this.kerbConfManager.setCrowdAutoAddGroups(crowdAutoAddGroups);
        resp.sendRedirect("config");
    }
}

