/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import com.kantegasso.runtimetrust.FingerprintSSLSocketFactory;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import javax.net.ssl.SSLException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.OidcConfigurationWithBucket;
import org.kantega.atlaskerb.identityproviders.SamlConfigurationWithBucket;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidationError;
import org.kantega.atlaskerb.identityproviders.setup.SamlMetadataParserWrapper;
import org.kantega.atlaskerb.saml.CertTool;

public class IdpActionResult {
    private final Option<Boolean> success;
    private final Option<String> message;
    private final Option<? extends Map<String, ?>> data;
    private final int httpCode;

    IdpActionResult(Boolean success, String message, Map<String, ?> data, int httpCode) {
        this.success = Option.of((Object)success);
        this.message = Option.of((Object)message);
        this.data = Option.of(data).filter(hashMap -> !hashMap.isEmpty());
        this.httpCode = httpCode;
    }

    public static IdpActionResult fromSamlMetadataParserWrapper(SamlMetadataParserWrapper metadata) {
        JSONArray saml_certificates = new JSONArray((Collection)((List)Option.of(metadata.getSigningCerts()).map(List::ofAll).getOrElse((Object)List.empty())).map(cert -> (HashMap)Try.of((CheckedFunction0 & Serializable)() -> CertTool.parse(cert)).mapTry((CheckedFunction1 & Serializable)x509 -> HashMap.of((Object)"base_64_cert", (Object)new String(Base64.getEncoder().encode((byte[])cert), StandardCharsets.UTF_8), (Object)"sha1_fingerprint", (Object)CertTool.fingerPrint(cert), (Object)"sha256_fingerprint", (Object)CertTool.sha256FingerPrint(cert), (Object)"sig_alg_name", (Object)x509.getSigAlgName(), (Object)"not_after", (Object)x509.getNotAfter(), (Object)"not_before", (Object)x509.getNotBefore(), (Object)"subject_name", (Object)x509.getSubjectDN().getName())).getOrElse(HashMap::empty)).map(HashMap::toJavaMap).map(JSONObject::new).toJavaList());
        return new IdpActionResult(true, "Metadata successfully parsed", (Map<String, ?>)HashMap.of((Object)"certificates", (Object)saml_certificates, (Object)"location", (Object)metadata.getIdpLocation(), (Object)"single_logout_service_url", (Object)metadata.getSingleLogoutServiceUrl(), (Object)"use_post_binding", (Object)metadata.isUsePostBinding()), 200);
    }

    public static IdpActionResult fromSamlIdpConfigWithBucketTry(Try<SamlConfigurationWithBucket> idpConfigurationWithBucketTry) {
        return (IdpActionResult)idpConfigurationWithBucketTry.fold(IdpActionResult::fromThrowable, samlConfigurationWithBucket -> new IdpActionResult(true, samlConfigurationWithBucket.getSamlIdpConfiguration().getName() + " successfully persisted.", (Map<String, ?>)HashMap.ofEntries((Tuple2[])new Tuple2[]{API.Tuple((Object)"id", (Object)samlConfigurationWithBucket.getSamlIdpConfiguration().getId()), API.Tuple((Object)"name", (Object)samlConfigurationWithBucket.getSamlIdpConfiguration().getName()), API.Tuple((Object)"kind", (Object)samlConfigurationWithBucket.getSamlIdpConfiguration().getKind().toString()), API.Tuple((Object)"protocol", (Object)samlConfigurationWithBucket.getSamlIdpConfiguration().getProtocol().toString()), API.Tuple((Object)"id", (Object)samlConfigurationWithBucket.getSamlIdpConfiguration().getId()), API.Tuple((Object)"non_admin_test_url", (Object)samlConfigurationWithBucket.getServiceProviderNonAdminTestURL()), API.Tuple((Object)"service_provider_login_url", (Object)samlConfigurationWithBucket.getServiceProviderLoginURL())}), 200));
    }

    public static IdpActionResult fromOidcIdpConfigWithBucketTry(Try<OidcConfigurationWithBucket> oidcConfigurationWithBucketTry) {
        return (IdpActionResult)oidcConfigurationWithBucketTry.fold(IdpActionResult::fromThrowable, oidcConfigurationWithBucket -> new IdpActionResult(true, oidcConfigurationWithBucket.getOidcIdpConfiguration().getName() + " successfully persisted.", (Map<String, ?>)HashMap.ofEntries((Tuple2[])new Tuple2[]{API.Tuple((Object)"id", (Object)oidcConfigurationWithBucket.getOidcIdpConfiguration().getId()), API.Tuple((Object)"name", (Object)oidcConfigurationWithBucket.getOidcIdpConfiguration().getName()), API.Tuple((Object)"kind", (Object)oidcConfigurationWithBucket.getOidcIdpConfiguration().getKind().toString()), API.Tuple((Object)"protocol", (Object)oidcConfigurationWithBucket.getOidcIdpConfiguration().getProtocol().toString()), API.Tuple((Object)"non_admin_test_url", (Object)oidcConfigurationWithBucket.getServiceProviderNonAdminTestURL()), API.Tuple((Object)"id", (Object)oidcConfigurationWithBucket.getOidcIdpConfiguration().getId())}), 200));
    }

    public static IdpActionResult fromThrowable(Throwable throwable) {
        return new IdpActionResult(false, throwable.getMessage(), null, 500);
    }

    public static IdpActionResult fromValidationErrors(Seq<IdpValidationError> idpValidationErrorSeq) {
        return new IdpActionResult(false, "Action failed one or more validations.", (Map<String, ?>)HashMap.ofEntries((Iterable)idpValidationErrorSeq.map(IdpValidationError::asShortNameTuple)), 400);
    }

    public static IdpActionResult fromThrowableMetadataImport(Throwable throwable, String url) {
        if (throwable.getCause() instanceof FingerprintSSLSocketFactory.FingerPrintException) {
            FingerprintSSLSocketFactory.FingerPrintException fingerPrintException = (FingerprintSSLSocketFactory.FingerPrintException)throwable.getCause();
            X509Certificate[] certs = fingerPrintException.getX509Certificates();
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(Arrays.asList(certs));
            if (certList.size() > 1) {
                certList.removeIf(cert -> cert.getIssuerDN().hashCode() == cert.getSubjectDN().hashCode());
            }
            JSONArray saml_certificates = new JSONArray((Collection)((List)Option.of(certList).map(List::ofAll).getOrElse((Object)List.empty())).map(x509 -> (HashMap)Try.of(x509::getEncoded).mapTry((CheckedFunction1 & Serializable)cert -> HashMap.of((Object)"base_64_cert", (Object)new String(Base64.getEncoder().encode((byte[])cert), StandardCharsets.UTF_8), (Object)"sha1_fingerprint", (Object)CertTool.fingerPrint(cert), (Object)"sha256_fingerprint", (Object)CertTool.sha256FingerPrint(cert), (Object)"sig_alg_name", (Object)x509.getSigAlgName(), (Object)"not_after", (Object)x509.getNotAfter(), (Object)"not_before", (Object)x509.getNotBefore(), (Object)"subject_name", (Object)x509.getSubjectDN().getName())).getOrElse(HashMap::empty)).map(HashMap::toJavaMap).map(JSONObject::new).toJavaList());
            return new IdpActionResult(false, "The provided fingerprint did not match the fingerprint in the certificate.", (Map<String, ?>)HashMap.ofEntries((Tuple2[])new Tuple2[]{API.Tuple((Object)"error_message", (Object)fingerPrintException.getMessage()), API.Tuple((Object)"internal_error_code", (Object)"fingerprint_does_not_match"), API.Tuple((Object)"metadata_url", (Object)url), API.Tuple((Object)"certificates", (Object)saml_certificates)}), 200);
        }
        if (throwable instanceof SSLException) {
            return new IdpActionResult(false, "SSLException: Certificate at SAML Metadata URL could not be verified. " + throwable.getMessage(), (Map<String, ?>)HashMap.ofEntries((Tuple2[])new Tuple2[]{API.Tuple((Object)"error_message", (Object)throwable.getMessage()), API.Tuple((Object)"internal_error_code", (Object)"fingerprint_needed")}), 200);
        }
        return IdpActionResult.fromThrowable(throwable);
    }

    public String toJsonObjectString() {
        return new JSONObject((java.util.Map)HashMap.ofEntries((Tuple2[])new Tuple2[]{API.Tuple((Object)"success", this.success), API.Tuple((Object)"message", this.message), API.Tuple((Object)"data", (Object)this.data.map(Map::toJavaMap))}).filterValues(Option::isDefined).mapValues(Option::get).toJavaMap()).toString(0);
    }

    public int getHttpCode() {
        return this.httpCode;
    }
}

