/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.wrapper.crowd.CrowdGroupWrapper;
import org.kantega.atlaskerb.wrapper.crowd.CrowdUserWrapper;

public class DirectoryGroupAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ScimConfManager scimConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public DirectoryGroupAction(RequireAdminServletDependencyBucket bucket, @ComponentImport ApplicationProperties applicationProperties, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = applicationProperties;
        this.scimConfManager = scimConfManager;
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String tenantId = req.getParameter("tenantId");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = (ScimDirectory)maybeDirectory.get();
        model.put("currentScimDirectory", scimDirectory);
        model.put("topMenu", "connectors");
        model.put("menuItem", "scimDirectoryGroups");
        model.put("displayName", this.applicationProperties.getDisplayName());
        String groupName = req.getParameter("group-name");
        model.put("groupName", groupName);
        this.render(scimDirectory.getDirectory(), groupName, resp, model);
    }

    private void render(Directory dir, String groupName, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        try {
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            MembershipQuery umq = QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
            MembershipQuery gmq = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
            GroupWithAttributes groupWithAttributes = directoryManager.findGroupWithAttributesByName(dir.getId().longValue(), groupName);
            CrowdGroupWrapper group = new CrowdGroupWrapper((Group)groupWithAttributes);
            List directoryMembers = directoryManager.searchDirectGroupRelationships(dir.getId().longValue(), umq);
            ArrayList<CrowdUserWrapper> members = new ArrayList<CrowdUserWrapper>();
            for (com.atlassian.crowd.model.user.User user : directoryMembers) {
                members.add(new CrowdUserWrapper((User)user));
            }
            List nestedGroupsDir = directoryManager.searchDirectGroupRelationships(dir.getId().longValue(), gmq);
            ArrayList<CrowdGroupWrapper> nestedGroups = new ArrayList<CrowdGroupWrapper>();
            for (Group nestedGroup : nestedGroupsDir) {
                nestedGroups.add(new CrowdGroupWrapper(nestedGroup));
            }
            model.put("dateTool", new DateTool());
            model.put("group", group);
            model.put("gid", group.getValue("ksso.scim.id"));
            model.put("externalId", Option.of((Object)group.getValue("ksso.scim.extId")).getOrElse(() -> null));
            model.put("groupcreated", Option.of((Object)group.getValue("ksso.scim.created")).map(ts -> new Date(Long.parseLong(ts))).getOrElse((Object)new Date(0L)));
            model.put("groupmodified", Option.of((Object)group.getValue("ksso.scim.lastModified")).map(ts -> new Date(Long.parseLong(ts))).getOrElse((Object)new Date(0L)));
            model.put("userMembers", members);
            model.put("nestedGroups", nestedGroups);
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.renderer.render("templates/atlaskerb/scim/group-details.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

