/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.latest.admin;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.rest.resource.api.apitokens.latest.admin.DeleteTokenAdmin;
import org.kantega.atlaskerb.rest.resource.api.apitokens.latest.admin.GetTokensAdmin;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="admin")
@PublicApi
public class ApiTokensAdminResource {
    private final Logger log = LoggerFactory.getLogger(ApiTokensAdminResource.class);
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;

    @Inject
    public ApiTokensAdminResource(@ComponentImport UserManager userManager, ApiTokenService apiTokenService) {
        this.userManager = userManager;
        this.apiTokenService = apiTokenService;
    }

    @Path(value="/tokens")
    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> GetTokensAdmin.run(this.apiTokenService));
    }

    @Path(value="/delete/{id}")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response delete(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        return ResponseUtils.sysadminOnly(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userKey -> (Response)Try.of((CheckedFunction0 & Serializable)() -> {
            if (id != null) {
                return DeleteTokenAdmin.run(id, this.apiTokenService, this.userManager);
            }
            String errorMessage = "Cannot delete API Token without ID.";
            this.log.debug("Cannot delete API Token without ID.");
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cannot delete API Token without ID.");
        }).onFailure(e -> this.log.error("Encountered an exception while deleting API token.", e)).getOrElse(() -> Response.serverError().build()));
    }
}

