/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.idp;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.rest.resource.api.idp.model.IdpInfoDto;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="idp")
public class IdpConfigResource {
    private final Logger log = LoggerFactory.getLogger(IdpConfigResource.class);
    private final IdpConfManager idpConfManager;
    private final UserManager userManager;
    private final JsonWrapper jsonWrapper;

    @Inject
    public IdpConfigResource(IdpConfManager idpConfManager, @ComponentImport UserManager userManager, JsonWrapper jsonWrapper) {
        this.idpConfManager = idpConfManager;
        this.userManager = userManager;
        this.jsonWrapper = jsonWrapper;
    }

    @GET
    @Path(value="/ids")
    @Produces(value={"application/json"})
    public Response getAllIdpIds(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            Collection<IdpConfiguration> identityProviders = this.idpConfManager.getIdentityProviders();
            List idpIds = identityProviders.stream().map(idpConfiguration -> new IdpInfoDto(idpConfiguration.getId(), idpConfiguration.getName())).collect(Collectors.toList());
            this.log.debug("getAllIdpIds -> Found {} idp ids", (Object)idpIds.size());
            try {
                return Response.ok((Object)this.jsonWrapper.buildJsonString(idpIds)).build();
            }
            catch (JsonProcessingException e) {
                this.log.error("KSSO: something went wrong processing json object ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        });
    }
}

