/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;

@UnrestrictedAccess
public class Jira6SamlFilter
extends FilterFacade {
    private final TemplateRenderer templateRenderer;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;

    @Inject
    public Jira6SamlFilter(@ComponentImport TemplateRenderer templateRenderer, HostAppFactory hostAppFactory, IdpConfManager idpConfManager, KerbConfManager kerbConfManager) {
        this.templateRenderer = templateRenderer;
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
    }

    private void appendScript(StringWriter inject, String contextPath, String file) {
        String src = contextPath + "/download/resources/" + file;
        inject.append("<script src=\"").append(src).append("\"></script>");
    }

    private void appendLink(StringWriter inject, String contextPath, String file) {
        String src = contextPath + "/download/resources/" + file;
        inject.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(src).append("\">");
    }

    public void doFilterKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        String url = req.getParameter("url");
        if (url == null || !url.contains("gadgets/login.xml") || !this.idpConfManager.isLicenseValid() || this.idpConfManager.countActiveProviders() == 0) {
            chain.doFilterKsso(req, resp);
            return;
        }
        final StringWriter inject = new StringWriter();
        if (this.hostApp.shouldUseLegacyLoginExperience()) {
            this.appendScript(inject, req.getContextPath(), PluginKey.getPluginKey() + ":entrypoint-saml-legacy-login/saml-legacy-login.js");
        } else {
            this.appendScript(inject, req.getContextPath(), PluginKey.getPluginKey() + ":entrypoint-saml-login/saml-login.js");
        }
        this.appendScript(inject, req.getContextPath(), "com.atlassian.auiplugin:aui-dropdown2/dropdown2.js");
        this.appendLink(inject, req.getContextPath(), "com.atlassian.auiplugin:aui-buttons/aui-buttons.css");
        this.appendLink(inject, req.getContextPath(), "com.atlassian.auiplugin:aui-dropdown2/dropdown2.css");
        inject.append("<script>window.contextPath = \"").append(req.getContextPath()).append("\";</script>");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
        model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
        model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
        model.put("shouldUseLegacyLoginExperience", this.hostApp.shouldUseLegacyLoginExperience());
        model.put("shouldLoginManually", false);
        model.put("redirectProgressDelay", this.idpConfManager.getRedirectProgressDelay() + "s");
        model.put("useIdpPriority", this.idpConfManager.isUseIdpPriority());
        this.templateRenderer.render("templates/atlaskerb/login-page/saml-login-condition.vm", model, (Writer)inject);
        chain.doFilterKsso(req, new HttpServletResponseFacade((HttpServletResponse)resp){
            PrintWriter w;

            public PrintWriter getWriter() throws IOException {
                if (this.w == null) {
                    this.w = new PrintWriter(super.getWriter()){

                        @Override
                        public void write(String s) {
                            super.write(s.replace("</body>", inject + "</body>"));
                        }
                    };
                }
                return this.w;
            }
        });
    }

    public void destroy() {
    }
}

