/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTokenAccessServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final Logger log = LoggerFactory.getLogger(ApiTokenAccessServlet.class);

    public ApiTokenAccessServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        try {
            this.renderer.render("templates/atlaskerb/api-tokens-access.vm", model, (Writer)resp.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        try {
            String addUrl;
            String removeUrl = req.getParameter("removeUrl");
            if (StringUtils.isNotBlank((CharSequence)removeUrl)) {
                this.kerbConfManager.removeApiTokenAccessUrls(removeUrl);
                removeUrl = removeUrl.replaceFirst("%2F", "/");
                this.kerbConfManager.removeApiTokenAccessUrls(removeUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)(addUrl = req.getParameter("addUrl")))) {
                addUrl = addUrl.trim();
                String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
                addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
                addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
                if (!StringUtils.startsWith((CharSequence)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (CharSequence)"/")) {
                    addUrl = "/" + addUrl;
                }
                addUrl = HttpUrlUtils.urlEncode((String)addUrl);
                this.kerbConfManager.addApiTokenAccessUrls(addUrl);
            }
            Map<String, Object> model = this.buildModel(req);
            resp.setContentType("text/html");
            this.renderer.render("templates/atlaskerb/api-tokens-access.vm", model, (Writer)resp.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> buildModel(HttpServletRequestFacade req) {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens-access");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("actualBaseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        Set<String> apiTokenAccessUrls = this.kerbConfManager.getApiTokenAccessUrls();
        HashSet<AccessUrlList> apiTokenAccessUrlsOut = new HashSet<AccessUrlList>();
        for (String url : apiTokenAccessUrls) {
            try {
                apiTokenAccessUrlsOut.add(new AccessUrlList(url, HttpUrlUtils.urlDecode((String)url)));
            }
            catch (UnsupportedEncodingException e) {
                apiTokenAccessUrlsOut.add(new AccessUrlList(url, url));
            }
        }
        model.put("apiAccessUrls", apiTokenAccessUrlsOut);
        return model;
    }

    public static class AccessUrlList {
        String url;
        String decodedUrl;

        public AccessUrlList(String url, String decodedUrl) {
            this.url = url;
            this.decodedUrl = decodedUrl;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDecodedUrl() {
            return this.decodedUrl;
        }
    }
}

