/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAccessServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public KerberosAccessServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String query = req.getParameter("query");
        if (query != null) {
            GroupSearchUtil.printGroupsAsJson(resp, query, this.userManager);
        } else {
            Map<String, Object> model = this.newModel(req);
            model.put("topMenu", "Kerberos");
            model.put("menuItem", "kerberosAccess");
            model.put("disable", !this.kerbConfManager.isKerberosEnabled());
            model.put("userPermission", (Object)this.kerbConfManager.getKerberosUserPermission());
            if (KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS.equals((Object)this.kerbConfManager.getKerberosUserPermission())) {
                model.put("userPermissionSome", (Object)this.kerbConfManager.getKerberosUserPermissionSome());
                if (!KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY.equals((Object)this.kerbConfManager.getKerberosUserPermissionSome())) {
                    model.put("userPermissionGroup", (Object)this.kerbConfManager.getKerberosUserPermissionGroup());
                }
                if (!KerbConfManager.UserPermissionGroupDirectoryType.GROUP.equals((Object)this.kerbConfManager.getKerberosUserPermissionSome())) {
                    model.put("directoryAccess", true);
                } else {
                    model.put("directoryAccess", false);
                }
            }
            model.put("directories", this.userLookupService.getVelocityCompatibleActiveUserDirectories());
            model.put("KSSO_DIRECTORY_ALLOWED", "ksso.kerberos.login.allowed");
            model.put("enabledGroups", this.kerbConfManager.getAllowKerberosLoginGroups());
            model.put("disabledGroups", this.kerbConfManager.getDisallowKerberosLoginGroups());
            resp.setContentType("text/html");
            this.renderer.render("templates/atlaskerb/kerberos-access/kerberos-access.vm", model, (Writer)resp.getWriter());
        }
    }

    void updatePermissionGroups(HttpServletRequestFacade req, String[] addGroups, String[] deleteGroups) {
        if ("usersInGroup".equals(req.getParameter("usersInGroups"))) {
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
            Set<String> groups = this.kerbConfManager.getAllowKerberosLoginGroups();
            groups.addAll(Arrays.asList(addGroups));
            Arrays.asList(deleteGroups).forEach(groups::remove);
            this.kerbConfManager.setAllowKerberosLoginGroups(groups);
        } else {
            this.kerbConfManager.setKerberosUserPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_NOT_IN_GROUP);
            Set<String> groups = this.kerbConfManager.getDisallowKerberosLoginGroups();
            groups.addAll(Arrays.asList(addGroups));
            Arrays.asList(deleteGroups).forEach(groups::remove);
            this.kerbConfManager.setDisallowKerberosLoginGroups(groups);
        }
    }

    void updatePermissionDirectory(HttpServletRequestFacade req) {
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            String enableButton = req.getParameter("loginEnable" + directory.getId());
            try {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                if ("on".equals(enableButton)) {
                    attrs.put("ksso.kerberos.login.allowed", "true");
                } else {
                    attrs.put("ksso.kerberos.login.allowed", "false");
                }
                builder.setAttributes(attrs);
                this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
            }
            catch (UnsupportedOperationException u) {
                this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-X7O8L3EC11", (String)("Unable to update directory " + directory.getName())), (Throwable)u);
            }
        }
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if ("NO_USERS".equals(req.getParameter("userPermissionKerberos"))) {
            this.kerbConfManager.setKerberosEnabled(false);
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.DISABLE_ALL_USERS);
        } else if ("ALL_USERS".equals(req.getParameter("userPermissionKerberos"))) {
            this.kerbConfManager.setKerberosEnabled(true);
            this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_ALL_USERS);
        } else {
            this.kerbConfManager.setKerberosEnabled(true);
            String[] addInGroups = StringUtils.split((String)req.getParameter("addInGroup"), (char)',');
            String[] removeInGroups = StringUtils.split((String)req.getParameter("removeInGroup"), (char)',');
            String[] addNotInGroups = StringUtils.split((String)req.getParameter("addNotInGroup"), (char)',');
            String[] removeNotInGroups = StringUtils.split((String)req.getParameter("removeNotInGroup"), (char)',');
            if ("directoryActivated".equals(req.getParameter("directoryChoice")) && ("usersInGroup".equals(req.getParameter("usersInGroups")) || "usersNotInGroup".equals(req.getParameter("usersInGroups")))) {
                this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
                this.updatePermissionDirectory(req);
                if ("usersInGroup".equals(req.getParameter("usersInGroups"))) {
                    this.updatePermissionGroups(req, addInGroups, removeInGroups);
                    if ("OR".equals(req.getParameter("criteriaLogic"))) {
                        this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
                    } else {
                        this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_AND_GROUP);
                    }
                } else {
                    this.updatePermissionGroups(req, addNotInGroups, removeNotInGroups);
                    if ("OR".equals(req.getParameter("criteriaLogicDisabled"))) {
                        this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
                    } else {
                        this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_AND_GROUP);
                    }
                }
            } else if ("directoryActivated".equals(req.getParameter("directoryChoice")) && !"usersInGroup".equals(req.getParameter("usersInGroups")) && !"usersInGroup".equals(req.getParameter("usersNotInGroups"))) {
                this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
                this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY);
                this.updatePermissionDirectory(req);
            } else {
                this.kerbConfManager.setKerberosUserPermission(KerbConfManager.KerberosUserPermissionType.ENABLE_SOME_USERS);
                this.kerbConfManager.setKerberosUserPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.GROUP);
                if ("usersInGroup".equals(req.getParameter("usersInGroups"))) {
                    this.updatePermissionGroups(req, addInGroups, removeInGroups);
                } else {
                    this.updatePermissionGroups(req, addNotInGroups, removeNotInGroups);
                }
            }
        }
        resp.sendRedirect("kerberos-access");
    }
}

