/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarServiceImpl;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import com.kantegasso.servlet.http.StatusPreservableHeaderAwareResponse;
import com.kantegasso.servlet.http.UserdetailsInCommentRequestWrapper;
import com.opensymphony.module.propertyset.PropertySet;
import io.vavr.CheckedFunction0;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RemembermeUtils;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.SsoScriptLoginHookUrlReadingCondition;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimTenantConfig;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.utils.CryptoUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.kantega.atlaskerb.utils.Version;
import org.kantega.atlaskerb.wrapper.crowd.CrowdUserWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHostApp
extends DefaultHostApp {
    private static final String COMMENT_REST_URL = "/rest/api/2/issue/.*/comment";
    private static final String COMMENT_POST_URL = "/secure/AddComment.jspa";
    private static final String JIRA_VISIBLE_PROPERTY_PREFIX = "jira.meta.";
    private static final String JIRA_KSSO_PROPERTY_PREFIX = "jira.ksso.";
    private final Method recordLoginMethod;
    private final Object loginComponent;
    private final Method fromUser;
    private final AvatarServiceImpl avatarServiceImpl;
    private final com.atlassian.jira.user.util.UserManager userManager;
    private final Logger log;
    private boolean useApplicationUser;
    private Class<?> beforeUserAuthenticateClass;
    private final AvatarManager avatarManager;
    private final AvatarService avatarService;

    public JiraHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, PluginAccessor pluginAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        Method fromUser;
        Object loginComponent;
        Method recordLoginMethod;
        block4: {
            super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, pluginAccessor, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
            this.log = LoggerFactory.getLogger(this.getClass());
            this.beforeUserAuthenticateClass = null;
            this.hasRestApi = true;
            recordLoginMethod = null;
            loginComponent = null;
            fromUser = null;
            this.avatarManager = ComponentAccessor.getAvatarManager();
            this.avatarService = ComponentAccessor.getAvatarService();
            this.userManager = ComponentAccessor.getUserManager();
            this.avatarServiceImpl = (AvatarServiceImpl)ComponentAccessor.getComponent(AvatarServiceImpl.class);
            try {
                ClassLoader ccl = this.getClass().getClassLoader().getParent();
                if (ccl == null) break block4;
                Class<?> loginStoreClass = ccl.loadClass("com.atlassian.jira.security.login.LoginStore");
                Class<?> applicationUserClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUser");
                Class<?> applicationUsersClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUsers");
                Class<User> crowdEmbeddedUserClass = User.class;
                this.beforeUserAuthenticateClass = ccl.loadClass("com.atlassian.jira.event.user.BeforeUserAuthenticate");
                try {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", applicationUserClass, Boolean.TYPE);
                    this.useApplicationUser = true;
                    fromUser = applicationUsersClass.getMethod("from", User.class);
                }
                catch (NoSuchMethodException e) {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", crowdEmbeddedUserClass, Boolean.TYPE);
                    this.useApplicationUser = false;
                }
                loginComponent = ComponentLocator.getComponent(loginStoreClass);
            }
            catch (Exception e) {
                this.log.warn("Could not load JIRA LoginStore. Login count / time update disabled", (Throwable)e);
            }
        }
        this.recordLoginMethod = recordLoginMethod;
        this.loginComponent = loginComponent;
        this.fromUser = fromUser;
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/issues/*");
        this.preemptivePathMappings.add("/browse/*");
        this.preemptivePathMappings.add("/projects/*");
        this.preemptivePathMappings.add("/secure/CreateIssue*");
        this.preemptivePathMappings.add("/secure/MyJiraHome.jspa");
        this.preemptivePathMappings.add("/secure/QuickSearch.jspa*");
        this.preemptivePathMappings.add("/secure/BrowseProjects.jspa*");
        this.preemptivePathMappings.add("/secure/BulkCreateSetupPage!default.jspa*");
        this.preemptivePathMappings.add("/secure/ConfigurePortalPages.jspa*");
        this.preemptivePathMappings.add("/secure/ManageFilters.jspa*");
        this.preemptivePathMappings.add("/sr/jira.issueviews:searchrequest-printable*");
        this.preemptivePathMappings.add("/secure/StructureBoard*");
        this.preemptivePathMappings.add("/plugins/servlet/jeditor_file_provider*");
        this.preemptivePathMappings.add("/secure/CommentAssignIssue*");
    }

    @Override
    public Try<Integer> getFailedLoginAttempts(Principal principal) {
        String usernameForLog = UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal);
        return Try.of((CheckedFunction0 & Serializable)() -> Integer.parseInt(Objects.requireNonNull(this.getCrowdService().getUserWithAttributes(principal.getName()).getValue("login.currentFailedCount")))).onFailure(NullPointerException.class, e -> this.log.warn("Could not obtain failed login count for user " + usernameForLog, (Throwable)e)).onFailure(NumberFormatException.class, e -> this.log.debug("Failed to parse login attempts for user " + usernameForLog, (Throwable)e));
    }

    @Override
    public Try<Void> setFailedLoginAttempts(Principal principal, int count) {
        String usernameForLog = UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal);
        return Try.run(() -> this.getCrowdService().setUserAttribute((User)principal, "login.currentFailedCount", String.valueOf(count))).onFailure(OperationNotPermittedException.class, e -> this.log.warn("An exception occurred while setting currentFailedCount after for user " + usernameForLog, (Throwable)e));
    }

    private boolean isRootRequest(HttpServletRequestFacade req) {
        return req.getRequestURI().equals(req.getContextPath() + "/");
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"jira", (CharSequence)product);
    }

    @Override
    public boolean urlInAdditionalBuiltInApiRequest(HttpServletRequestFacade req) {
        return StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req), (CharSequence)"/sr/jira.issueviews");
    }

    @Override
    public boolean isRequestMapped(HttpServletRequestFacade req, String r) {
        return this.isPageWithLoginForm(req);
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequestFacade req) {
        String requestUri = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        return this.isMainLoginPage(req) || this.shouldUseLegacyLoginExperience() && (requestUri.equalsIgnoreCase("/secure/Dashboard.jspa") || requestUri.equals("/Dashboard.jspa") || requestUri.equals("/secure/MyJiraHome.jspa") || requestUri.equals("/secure/") || this.isRootRequest(req) || this.kerbConfManager.isUserdetailsInCommentsEnabled() && (requestUri.matches(COMMENT_REST_URL) || requestUri.startsWith(COMMENT_POST_URL)));
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequestFacade request) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request);
        return internalPath.equals("/login.jsp") || JiraHostApp.isJsmLoginPage(internalPath);
    }

    @Override
    public boolean isJsmLogoutPage(HttpServletRequestFacade r) {
        return this.isJsmLoginPage(r) && StringUtils.equals((CharSequence)r.getParameter("logout"), (CharSequence)"true") || HttpUrlUtils.getInternalPath((HttpServletRequestFacade)r).equals("/servicedesk/customer/user/logout");
    }

    private boolean isGadgetLoginRequest(HttpServletRequestFacade req, String r) {
        return r.startsWith("/rest/gadget/") && r.endsWith("/login") && "POST".equals(req.getMethod());
    }

    @Override
    public boolean isForceLoginRequestMapped(HttpServletRequestFacade req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String r = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        return super.isForceLoginRequestMapped(req) || r.equals("/") || r.startsWith("/issues/") || r.startsWith("/browse/") || r.startsWith("/projects/") || r.startsWith("/secure/CreateIssue") || r.startsWith("/secure/QuickSearch.jspa") || r.startsWith("/secure/BrowseProjects.jspa") || r.startsWith("/secure/BulkCreateSetupPage!default.jspa") || r.startsWith("/secure/ConfigurePortalPages.jspa") || r.startsWith("/secure/ManageFilters.jspa") || r.startsWith("/sr/jira.issueviews:searchrequest-printable") || r.startsWith("/secure/StructureBoard") || r.startsWith("/plugins/servlet/jeditor_file_provider") || r.startsWith("/secure/CommentAssignIssue");
    }

    @Override
    public Option<String> getAnonymousBrowsingSettingsUrl() {
        return Option.of((Object)"/secure/admin/ViewPermissionSchemes.jspa");
    }

    @Override
    public boolean isLoginRequest(HttpServletRequestFacade req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if ("POST".equals(req.getMethod()) && ("/login.jsp".equals(requestPath) || this.isDefaultRestEndpointForAuthentication(req))) {
            return true;
        }
        if (this.isGadgetLoginRequest(req, requestPath)) {
            return true;
        }
        return JiraHostApp.isJsmLoginPage(requestPath) && "POST".equals(req.getMethod());
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequestFacade req, HttpServletResponseFacade res) {
        String r;
        if (req != null && ((JiraHostApp.isJsmLoginPage(r = req.getRequestURI().substring(req.getContextPath().length())) || this.isForwardedServiceDesk(req)) && SsoScriptLoginHookUrlReadingCondition.shouldAbortSso(req) || this.isLogoutPage(req) || this.isJsmLogoutPage(req))) {
            return true;
        }
        return super.shouldLoginManually(req, res);
    }

    private boolean isForwardedServiceDesk(HttpServletRequestFacade req) {
        String forwardedUri = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (forwardedUri == null) {
            return false;
        }
        return JiraHostApp.isJsmLoginPage(forwardedUri.substring(req.getContextPath().length()));
    }

    @Override
    public void dispatchToLogin(HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) {
        try {
            String requestPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
            String qs = req.getQueryString();
            SanitizedLogStatement.of(qs).andThenLog(sanitizedQuery -> this.log.debug("dispatchToLogin() requestPath: '{}', qs: '{}'", (Object)requestPath, sanitizedQuery));
            this.log.debug("isKeytabConfigured: {}, isPreemptiveAuthEnabled: {}, isSendToLoginEnabled: {}, isTraditionalLoginDisabled: {}, isAnyProviderForcingReLoginAfterLogoutForJsm: {}", new Object[]{this.kerbConfManager.isKeytabConfigured(), this.kerbConfManager.isRequireLogin(), this.kerbConfManager.isForceLogin(), this.kerbConfManager.isTraditionalLoginPrevented(), this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()});
            if (requestPath.matches(COMMENT_REST_URL) || requestPath.startsWith(COMMENT_POST_URL)) {
                this.addUserdetailsInAnonymousJiraComment(chain, req, resp);
                return;
            }
            if (this.isForwarded(req) && "/login.jsp".equals(requestPath)) {
                this.log.debug("isForwarded()");
                chain.doFilterKsso(req, resp);
                return;
            }
            if (this.isJsm(req)) {
                this.dispatchToJsmLogin(req, resp, chain, requestPath, qs);
                return;
            }
            if (!this.isForwarded(req) && requestPath.startsWith("/secure/") && !requestPath.startsWith("/secure/CreateIssue")) {
                this.log.debug("isDashboardOrJiraHome -> sendRedirect");
                resp.sendRedirect(req.getContextPath() + "/login.jsp?os_destination=" + HttpUrlUtils.urlEncode((String)requestPath) + "%3F" + HttpUrlUtils.urlEncode((String)qs));
            } else if (requestPath.equals("/")) {
                this.log.debug("is call to path /");
                if (this.kerbConfManager.isRequireLogin() && this.kerbConfManager.isForceLogin()) {
                    resp.sendRedirect(req.getContextPath() + "/login.jsp");
                } else {
                    chain.doFilterKsso(req, resp);
                }
            } else if (this.isRestApi(requestPath)) {
                this.log.debug("isRestApi()");
                chain.doFilterKsso(req, (HttpServletResponseFacade)new StatusPreservableHeaderAwareResponse((HttpServletResponse)resp));
            } else if (JiraHostApp.shouldDispatchToLoginPage(this.kerbConfManager)) {
                this.log.debug("shouldDispatchToLoginPage()");
                String encodedQuery = HttpUrlUtils.urlEncode((String)qs);
                if (!"/login.jsp".equals(requestPath) && !requestPath.contains("logout%3FSAMLResponse")) {
                    Object queryStringPart;
                    Object object = queryStringPart = StringUtils.isNotBlank((CharSequence)encodedQuery) ? "%3F" + encodedQuery : "";
                    if (requestPath.contains("/secure/MyJiraHome.jspa")) {
                        this.log.debug("/secure/MyJiraHome.jspa, encodedQuery: '{}'", (Object)encodedQuery);
                        resp.sendRedirect(req.getContextPath() + "/login.jsp?os_destination=" + HttpUrlUtils.urlEncode((String)requestPath) + (String)queryStringPart);
                    } else {
                        this.log.debug("shouldDispatchToLoginPage() + login.jsp, encodedQuery: '{}'", (Object)encodedQuery);
                        req.getRequestDispatcher("/login.jsp?os_destination=" + requestPath + (String)queryStringPart).forward((ServletRequest)req, (ServletResponse)resp);
                    }
                } else {
                    this.log.debug("shouldDispatchToLoginPage() + else, encodedQuery: '{}'", (Object)encodedQuery);
                    req.getRequestDispatcher("/login.jsp?" + encodedQuery).forward((ServletRequest)req, (ServletResponse)resp);
                }
            } else {
                this.log.debug("dispatchToLogin default");
                if ("/login.jsp".equals(requestPath) && StringUtils.contains((CharSequence)qs, (CharSequence)"logout%3FSAMLResponse")) {
                    this.log.debug("login.jsp?os_destination={} qs: {}", (Object)requestPath, (Object)qs);
                    req.getRequestDispatcher("/login.jsp?os_destination=").forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    this.log.debug("else doFilter: {}, qs: {}: ", (Object)requestPath, (Object)qs);
                    chain.doFilterKsso(req, resp);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void dispatchToJsmLogin(HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain, String requestPath, String qs) throws IOException {
        if (JiraHostApp.isJsmLoginPage(requestPath)) {
            this.log.debug("isJSMServiceDesk");
            if (StringUtils.contains((CharSequence)qs, (CharSequence)"nokerberos")) {
                this.log.debug("isJSM() and not federated SSO enabled or queryString contains nokerberos");
                chain.doFilterKsso(req, resp);
            } else {
                String dest;
                StringBuffer url = new StringBuffer(req.getContextPath() + requestPath);
                if (this.isJsmLogoutPage(req)) {
                    this.log.debug("isServiceManagementLogout");
                    if (!this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()) {
                        HttpUrlUtils.addParameterToUrlQueryString((StringBuffer)url, (String)"noredirect", null);
                    }
                }
                if ((dest = req.getParameter("destination")) != null) {
                    HttpUrlUtils.addParameterToUrlQueryString((StringBuffer)url, (String)"destination", (String)HttpUrlUtils.urlEncode((String)dest));
                }
                if ("true".equals(req.getParameter("absolute"))) {
                    HttpUrlUtils.addParameterToUrlQueryString((StringBuffer)url, (String)"absolute", (String)"true");
                }
                this.log.debug("isJSM() + metaRefresh, url: '{}'", (Object)url);
                HttpUrlUtils.addParameterToUrlQueryString((StringBuffer)url, (String)"nokerberos", null);
                this.metaRefresh(resp, url.toString());
            }
        } else if (StringUtils.contains((CharSequence)req.getHeader("referer"), (CharSequence)this.getJsmUrlPart())) {
            this.log.debug("call with referer " + this.getJsmUrlPart());
            chain.doFilterKsso(req, resp);
        } else {
            this.log.debug("isJSM() and not JSM login page");
            resp.sendRedirect(this.getJsmLoginPageUrl(req) + "?os_destination=" + HttpUrlUtils.urlEncode((String)requestPath) + "%3F" + HttpUrlUtils.urlEncode((String)qs));
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequestFacade req, HttpServletResponseFacade res, FilterChainFacade chain) throws IOException {
        String internalRequestPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        if (JiraHostApp.isJsmLoginPage(internalRequestPath)) {
            this.preventCaching(res);
            String destination = req.getParameter("destination");
            if (destination != null) {
                String absolute = req.getParameter("absolute");
                Object url = destination;
                if (!"true".equals(absolute)) {
                    url = req.getContextPath() + "/servicedesk/customer/" + (String)url;
                }
                this.safeRedirect.sendRedirect((String)url, req, res, this);
            } else {
                res.sendRedirect(req.getContextPath() + "/servicedesk/customer/");
            }
        } else if (this.isRestApi(internalRequestPath)) {
            this.preventCaching(res);
            chain.doFilterKsso(req, res);
        } else {
            super.postSuccessfulLoginWithKerberosAction(user, req, res, chain);
        }
    }

    @Override
    public boolean shouldRequireCanLogin(HttpServletRequestFacade req) {
        return !JiraHostApp.isJsmLoginPage(HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req));
    }

    @Override
    public boolean isJsmLoginPage(HttpServletRequestFacade req) {
        return JiraHostApp.isJsmLoginPage(HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req));
    }

    private static boolean isJsmLoginPage(String requestPath) {
        return requestPath.startsWith("/servicedesk/customer/") && requestPath.endsWith("/user/login");
    }

    private String getJsmLoginPageUrl(HttpServletRequestFacade req) {
        return req.getContextPath() + "/servicedesk/customer/user/login";
    }

    private String getJsmUrlPart() {
        return "/servicedesk/customer/";
    }

    private boolean isJsm(HttpServletRequestFacade req) {
        return StringUtils.contains((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req), (CharSequence)this.getJsmUrlPart()) || StringUtils.contains((CharSequence)req.getHeader("referer"), (CharSequence)this.getJsmUrlPart());
    }

    @Override
    public String getRedirectTarget(HttpServletRequestFacade req) {
        String destination;
        if (JiraHostApp.isJsmLoginPage(req.getRequestURI().substring(req.getContextPath().length())) && (destination = req.getParameter("destination")) != null) {
            if (StringUtils.startsWith((CharSequence)destination, (CharSequence)"/servicedesk/customer") || StringUtils.startsWith((CharSequence)destination, (CharSequence)"/plugins/servlet/")) {
                return req.getContextPath() + destination;
            }
            return req.getContextPath() + "/servicedesk/customer/" + destination;
        }
        return super.getRedirectTarget(req);
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        if (CryptoUtils.secretIndicatesEncryptedValue((String)ldapPasswordParameter)) {
            String encryptorClassName = "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor";
            String componentManagerClassName = "com.atlassian.jira.component.pico.ComponentManager";
            return (String)this.decryptLdapPassword(ldapPasswordParameter, "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor", "com.atlassian.jira.component.pico.ComponentManager").getOrElse((Object)ldapPasswordParameter);
        }
        return super.optionallyDecryptLdapPassword(ldapPasswordParameter);
    }

    @Override
    public RemoteDirectory getAuthorativeDirectory(DbCachingRemoteDirectory directoryInstance) {
        RemoteDirectory authoritativeDirectory = super.getAuthorativeDirectory(directoryInstance);
        try {
            Method getKeysMethod = authoritativeDirectory.getClass().getMethod("getKeys", new Class[0]);
            getKeysMethod.setAccessible(true);
            Method getValueMethod = authoritativeDirectory.getClass().getMethod("getValue", String.class);
            getValueMethod.setAccessible(true);
            HashMap<String, String> updatedAttributes = new HashMap<String, String>();
            for (String key : authoritativeDirectory.getKeys()) {
                String value = authoritativeDirectory.getValue(key);
                if ("ldap.password".equals(key)) {
                    value = this.optionallyDecryptLdapPassword(value);
                }
                updatedAttributes.put(key, value);
            }
            authoritativeDirectory.setAttributes(updatedAttributes);
        }
        catch (NoSuchMethodException e) {
            this.log.warn("Problem getting 'ldap.password' from RemoteDirectory");
        }
        catch (Exception e) {
            this.log.warn("Problem decrypting 'ldap.password' from RemoteDirectory");
        }
        return authoritativeDirectory;
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequestFacade req, HttpServletResponseFacade res, Principal user) {
        this.seraphLikeInvalidateSession(req);
        this.publishBeforeUserAuthenticateEvent(user, req.getSessionKsso());
        req.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)user);
        req.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        this.registerSuccessfulLoginInLoginStore(user);
        return user;
    }

    @Override
    public void invalidateSession(HttpServletResponseFacade res, HttpServletRequestFacade req) {
        super.invalidateSession(res, req);
        try {
            SecurityConfigFactory.getInstance().getAuthenticator().logout((HttpServletRequest)req, (HttpServletResponse)res);
            JiraAuthenticationContext jiraAuthenticationContext = (JiraAuthenticationContext)ComponentLocator.getComponent(JiraAuthenticationContext.class);
            jiraAuthenticationContext.clearLoggedInUser();
        }
        catch (Exception e) {
            this.log.warn("Failed to invalidate session", (Throwable)e);
        }
    }

    private void publishBeforeUserAuthenticateEvent(Principal user, HttpSessionFacade session) {
        if (this.hasBeforeUserAuthenticateSupport()) {
            try {
                if (this.beforeUserAuthenticateClass != null) {
                    Constructor<?>[] cons = this.beforeUserAuthenticateClass.getConstructors();
                    Object o = cons[0].newInstance(user.getName());
                    this.eventPublisher.publish(o);
                } else {
                    this.log.warn("Could not load beforeUserAuthenticateClass");
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to publish BeforeUserAuthenticate event during Jira login", (Throwable)e);
            }
        }
    }

    private void registerSuccessfulLoginInLoginStore(Principal user) {
        if (this.recordLoginMethod != null && this.loginComponent != null) {
            try {
                Object applicationUser = this.useApplicationUser && this.fromUser != null ? this.fromUser.invoke(null, user) : user;
                this.recordLoginMethod.invoke(this.loginComponent, applicationUser, true);
            }
            catch (Exception e) {
                this.log.warn("Failed invoking JIRA LoginStore.recordLoginAttempt with the following exception {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.jira.security.login.JiraSeraphAuthenticator";
    }

    @Override
    public String getUserManagerLink() {
        return "/secure/admin/user/UserBrowser.jspa";
    }

    @Override
    public String getLoginPage() {
        return "/login.jsp";
    }

    @Override
    public String getMainLogoutPage() {
        return "/secure/Logout!default.jspa";
    }

    @Override
    public java.util.List<String> getLogoutPages() {
        ArrayList<String> logoutPages = new ArrayList<String>();
        logoutPages.add(this.getMainLogoutPage());
        logoutPages.add("/secure/Logout.jspa");
        logoutPages.add("/logout");
        return logoutPages;
    }

    @Override
    public boolean isLogoutPage(HttpServletRequestFacade req) {
        return super.isLogoutPage(req) || this.isJsmLogoutPage(req);
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5501;
    }

    @Override
    public boolean isJiraCrowdRequest(HttpServletRequestFacade req) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        String authHeader = req.getHeader("Authorization");
        boolean isJiraCrowdAuth = StringUtils.startsWith((CharSequence)authHeader, (CharSequence)"Basic ") && !StringUtils.contains((CharSequence)authHeader, (CharSequence)":");
        return isJiraCrowdAuth && (Boolean)Option.of((Object)internalPath).map(path -> path.startsWith("/rest/usermanagement/1/")).getOrElse((Object)false) != false;
    }

    @Override
    public Map<String, String> mapNameToExternalId(java.util.List<User> userBatch, Map<String, String> userData) {
        userBatch.forEach(user -> userData.put(user.getName(), ((OfBizUser)user).getExternalId()));
        return userData;
    }

    @Override
    public void setRememberMeCookie(HttpServletRequestFacade request, HttpServletResponseFacade response, String username) {
        RemembermeUtils.setRememberMeCookie(request, response, username);
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        return user.getValue("login.lastLoginMillis");
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("jira-administrators"))) {
            return "jira-administrators";
        }
        return null;
    }

    @Override
    public boolean shouldCheckUserAccess() {
        return true;
    }

    public boolean hasBeforeUserAuthenticateSupport() {
        Version version = new Version(this.applicationProperties.getVersion());
        boolean isJiraVersion8 = version.getMajor() == 8;
        boolean isJiraHigherThan8 = version.getMajor() > 8;
        boolean isJiraMinor22OrHigher = version.getMinor() >= 22;
        return isJiraHigherThan8 || isJiraVersion8 && isJiraMinor22OrHigher;
    }

    @Override
    public boolean isSyncDirCompatible() {
        Version version = new Version(this.applicationProperties.getVersion());
        boolean isJiraVersionLowerThan8 = version.getMajor() < 8;
        boolean isJiraVersion8 = version.getMajor() == 8;
        boolean isJiraHigherThan8 = version.getMajor() > 8;
        boolean isJiraMinorLowerThan14 = version.getMinor() < 14;
        boolean isJiraMinor15OrHigher = version.getMinor() >= 15;
        return isJiraVersionLowerThan8 || isJiraHigherThan8 || isJiraVersion8 && isJiraMinorLowerThan14 || isJiraVersion8 && isJiraMinor15OrHigher;
    }

    private boolean addUserdetailsInAnonymousJiraComment(FilterChainFacade chain, HttpServletRequestFacade req, HttpServletResponseFacade res) throws IOException {
        if (this.kerbConfManager.isUserdetailsInCommentsEnabled()) {
            Object userdetails = (String)req.getAttribute("usernameAnonymousUser");
            if (userdetails != null) {
                User user = this.crowdService.getUser((String)userdetails);
                if (user != null) {
                    userdetails = "[" + user.getDisplayName() + "|mailto:" + user.getEmailAddress() + "]";
                }
                this.log.debug("Adding user details to anonymous comment: " + (String)userdetails);
            }
            req.getSessionKsso().removeAttribute("lockout_timestamp");
            chain.doFilterKsso((HttpServletRequestFacade)new UserdetailsInCommentRequestWrapper((HttpServletRequest)req, (String)userdetails, HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req).matches(COMMENT_REST_URL)), (HttpServletResponseFacade)new StatusPreservableHeaderAwareResponse((HttpServletResponse)res));
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getUsersProfilePicture(java.util.List<User> users) {
        HashMap<String, String> usernameAvatarUriMap = new HashMap<String, String>();
        for (User u : users) {
            ApplicationUser aUser = this.userManager.getUserByName(u.getName());
            String avatarUri = null;
            try {
                avatarUri = this.avatarServiceImpl.getAvatarUrlNoPermCheck(aUser, null).toString();
            }
            catch (AvatarsDisabledException avatarsDisabledException) {
                // empty catch block
            }
            usernameAvatarUriMap.put(u.getName(), avatarUri);
        }
        return usernameAvatarUriMap;
    }

    @Override
    public Map<String, String> getUsersProfilePictureForVelocity(java.util.List<CrowdUserWrapper> users) {
        HashMap<String, String> usernameAvatarUriMap = new HashMap<String, String>();
        for (CrowdUserWrapper u : users) {
            ApplicationUser aUser = this.userManager.getUserByName(u.getName());
            String avatarUri = null;
            try {
                avatarUri = this.avatarServiceImpl.getAvatarUrlNoPermCheck(aUser, null).toString();
            }
            catch (AvatarsDisabledException avatarsDisabledException) {
                // empty catch block
            }
            usernameAvatarUriMap.put(u.getName(), avatarUri);
        }
        return usernameAvatarUriMap;
    }

    @Override
    public void setUserProfilePicture(String userName, String fileExtension, byte[] imageBytes, Path avatarDirPath) {
        String contentType = "image/" + fileExtension;
        String filename = userName.trim() + "." + fileExtension;
        IconType iconType = IconType.USER_ICON_TYPE;
        File outputFile = new File(Paths.get(avatarDirPath.toString(), filename).toString());
        ApplicationUser appUser = this.userManager.getUserByName(userName);
        if (appUser == null) {
            return;
        }
        try {
            IconOwningObjectId owner = new IconOwningObjectId(appUser.getKey());
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageBytes));
            ImageIO.write((RenderedImage)img, fileExtension, outputFile);
            BufferedInputStream iStream = new BufferedInputStream(Files.newInputStream(outputFile.toPath(), new OpenOption[0]));
            Avatar avatar = this.avatarManager.create(filename, contentType, iconType, owner, (InputStream)iStream, null);
            Method setAvatarMethod = this.avatarService.getClass().getDeclaredMethod("setConfiguredAvatarIdFor", ApplicationUser.class, Long.class);
            setAvatarMethod.setAccessible(true);
            setAvatarMethod.invoke((Object)this.avatarService, appUser, avatar.getId());
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRestPathInternalAtlassianFunctionality(HttpServletRequestFacade request) {
        return super.isRestPathInternalAtlassianFunctionality(request) || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request), (CharSequence)"/rest/api/2/field") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request), (CharSequence)"/rest/remote-link-aggregation") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request), (CharSequence)"/rest/remote-event-consumer") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request), (CharSequence)"/rest/gadgets");
    }

    @Override
    public boolean shouldEnableHardRedirect(HttpServletRequestFacade req) {
        if (this.idpConfManager == null) {
            return super.shouldEnableHardRedirect(req);
        }
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        boolean anyJsmUsingInstant = false;
        Iterator<IdpConfiguration> idps = this.idpConfManager.getIdentityProviders().iterator();
        while (idps.hasNext() && !anyJsmUsingInstant) {
            IdpConfiguration idp = idps.next();
            if (!idp.isEnabled()) continue;
            IdpConfiguration.RedirectPolicy redirectPolicy = idp.getJsmRedirectProperties().getRedirectPolicy();
            if (this.isJsmLogoutPage(req)) {
                anyJsmUsingInstant = redirectPolicy == IdpConfiguration.RedirectPolicy.HARD && idp.isSsoAfterLogout();
                continue;
            }
            anyJsmUsingInstant = redirectPolicy == IdpConfiguration.RedirectPolicy.HARD;
        }
        boolean shouldEnableRedirectForJsm = super.shouldEnableHardRedirect(req) && this.idpConfManager.isLoginEnabledForJSM() && anyJsmUsingInstant;
        this.log.debug("shouldEnableInstantRedirectForJsm: {}", (Object)shouldEnableRedirectForJsm);
        if (this.isJsmLoginPage(req)) {
            return shouldEnableRedirectForJsm;
        }
        return super.shouldEnableHardRedirect(req);
    }

    @Override
    public IdpConfiguration getInstantRedirectProvider(HttpServletRequestFacade req, HttpServletResponseFacade resp, SsoScriptLoginHookUrlReadingCondition loginScriptCondition) {
        java.util.List<IdpConfiguration> jsmHardRedirectIdps;
        if (this.isJsmLoginPage(req) && this.shouldEnableHardRedirect(req) && (!this.shouldLoginManually(req, resp) || this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()) && (jsmHardRedirectIdps = this.idpConfManager.getProvidersByJsmRedirectPolicy(IdpConfiguration.RedirectPolicy.HARD)).size() == 1) {
            return jsmHardRedirectIdps.get(0);
        }
        return super.getInstantRedirectProvider(req, resp, loginScriptCondition);
    }

    @Override
    public boolean sendToDashboardAfterLogin() {
        return this.kerbConfManager.isSendToDashboardAfterLogin();
    }

    @Override
    public boolean isJsmUser(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            return false;
        }
        ApplicationAuthorizationService authService = (ApplicationAuthorizationService)ComponentAccessor.getComponent(ApplicationAuthorizationService.class);
        return authService.canUseApplication(user, ApplicationKeys.SERVICE_DESK);
    }

    @Override
    public Set<Group> getJSMGroups() {
        ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentAccessor.getComponent(ApplicationRoleManager.class);
        return applicationRoleManager.getRoles().stream().filter(role -> role.getKey().equals((Object)ApplicationKeys.SERVICE_DESK)).map(ApplicationRole::getGroups).findFirst().orElse(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<ApplicationUser> getUsersToJSMClean(String currentUsername, int updatedDaysSince, java.util.List<ApplicationUser> unfilteredUsers) {
        String key;
        java.util.List issues;
        ApplicationUser currentUser = this.userManager.getUserByName(currentUsername);
        SearchService searchService = (SearchService)ComponentAccessor.getComponent(SearchService.class);
        JqlQueryParser jqlQueryParser = (JqlQueryParser)ComponentAccessor.getComponent(JqlQueryParser.class);
        ChangeHistoryManager changeHistoryManager = ComponentAccessor.getChangeHistoryManager();
        CommentManager commentManager = ComponentAccessor.getCommentManager();
        com.atlassian.jira.user.util.UserManager userManager = ComponentAccessor.getUserManager();
        String issuesJqlQuery = String.format("updated >= -%dd", updatedDaysSince);
        Calendar searchAfterCalendar = Calendar.getInstance();
        searchAfterCalendar.add(5, -updatedDaysSince);
        Date searchAfterDate = searchAfterCalendar.getTime();
        JiraThreadLocalUtils.preCall();
        try {
            try {
                issues = searchService.search(currentUser, jqlQueryParser.parseQuery(issuesJqlQuery), PagerFilter.getUnlimitedFilter()).getResults();
            }
            catch (SearchException | JqlParseException e) {
                throw new RuntimeException("Problem in getUsersToJSMClean", e);
            }
        }
        finally {
            JiraThreadLocalUtils.postCall();
        }
        if (issues == null) {
            return null;
        }
        issues = issues.stream().filter(issue -> issue.getProjectObject() != null && issue.getProjectObject().getProjectTypeKey().getKey().equals("service_desk")).collect(Collectors.toList());
        ArrayList comments = new ArrayList();
        for (Object i : issues) {
            comments.addAll(commentManager.getCommentsForUserSince((Issue)i, currentUser, searchAfterDate));
        }
        ArrayList issueChanges = new ArrayList();
        for (Object i : issues) {
            issueChanges.addAll(changeHistoryManager.getChangeHistoriesSince((Issue)i, searchAfterDate));
        }
        HashMap<String, ApplicationUser> activeUsers = new HashMap<String, ApplicationUser>();
        for (Comment c : comments) {
            key = c.getAuthorApplicationUser().getKey();
            activeUsers.put(key, userManager.getUserByKey(key));
        }
        for (Comment c : issueChanges) {
            key = c.getAuthorKey();
            activeUsers.put(key, userManager.getUserByKey(key));
        }
        Set<Group> jsmGroups = this.getJSMGroups();
        java.util.List<Object> usersInactiveInJsm = new ArrayList<ApplicationUser>();
        GroupManager groupManager = ComponentAccessor.getGroupManager();
        HashMap jsmUserMap = new HashMap();
        for (Group group : jsmGroups) {
            Collection jsmAppUsers = groupManager.getUsersInGroup(group);
            jsmAppUsers.forEach(user -> jsmUserMap.put(user.getKey(), user));
        }
        if (unfilteredUsers != null) {
            for (ApplicationUser user2 : unfilteredUsers) {
                if (!jsmUserMap.containsKey(user2.getKey()) || activeUsers.containsKey(user2.getKey())) continue;
                usersInactiveInJsm.add(user2);
            }
        } else {
            usersInactiveInJsm = jsmUserMap.values().stream().filter(u -> !activeUsers.containsKey(u.getKey())).collect(Collectors.toList());
        }
        return usersInactiveInJsm;
    }

    public ApplicationUser getApplicationUser(String username) {
        return this.userManager.getUserByName(username);
    }

    @Override
    public void readUsersIntoCache(ScimConfManager.ScimConfigState state, List<ScimTenantConfig> tenantConfigs) {
        JiraThreadLocalUtils.preCall();
        try {
            super.readUsersIntoCache(state, tenantConfigs);
        }
        finally {
            JiraThreadLocalUtils.postCall();
        }
    }

    @Override
    public boolean isEditAccountGetRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/secure/ViewProfile.jspa") && "GET".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isAdminEditAccountGetRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public boolean isEditAccountPostRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/secure/EditProfile.jspa") && "POST".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isAdminEditAccountPostRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/secure/admin/user/EditUser.jspa") && "POST".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public String getEditAccountName(HttpServletRequestFacade req) {
        String name = req.getParameter("fullname");
        return name != null ? name : req.getParameter("fullName");
    }

    @Override
    public String getEditAccountEmail(HttpServletRequestFacade req) {
        return req.getParameter("email");
    }

    @Override
    public UserProfile getEditAccountUser(UserManager userManager, HttpServletRequestFacade req) {
        String username = req.getParameter("editName");
        return username != null ? userManager.getUserProfile(username) : null;
    }

    @Override
    public String getDatabaseUrl() {
        try {
            Method m = ((SystemInfoUtils)ComponentLocator.getComponent(SystemInfoUtils.class)).getClass().getMethod("getDatabaseMetaData", new Class[0]);
            SystemInfoUtils.DatabaseMetaData dbMetadata = (SystemInfoUtils.DatabaseMetaData)m.invoke(ComponentLocator.getComponent(SystemInfoUtils.class), new Object[0]);
            return dbMetadata.getMaskedURL();
        }
        catch (Exception e) {
            this.log.warn("Could not get database URL", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isLegacyLoginPageDefaultOnCurrentApplicationVersion() {
        Version applicationVersion = Version.of((String)this.applicationProperties.getVersion());
        return applicationVersion.isLowerThan(Version.of((String)"10.2"));
    }

    @Override
    public String getForgotPasswordUrl() {
        return "/secure/ForgotLoginDetails.jspa";
    }

    @Override
    public String getDefaultLicenseGroup() {
        return "jira-software-users";
    }

    @Override
    public String[] getTargetUrlParameters() {
        return new String[]{"os_destination", "destination"};
    }

    @Override
    public boolean shouldDoKerberosForURL(HttpServletRequestFacade req) {
        return !this.isJsmLoginPage(req) || this.isJsmLoginPage(req) && !this.isJsmLogoutPage(req) && this.kerbConfManager.isKerberosJsmEnabled();
    }

    @Override
    public boolean shouldAvoidKerberosDueToLogout(HttpServletRequestFacade req) {
        String refererHeader = req.getHeader("referer");
        if (StringUtils.isNotBlank((CharSequence)refererHeader) && !this.shouldUseLegacyLoginExperience()) {
            for (String logoutPage : this.getLogoutPages()) {
                if (!StringUtils.containsIgnoreCase((CharSequence)refererHeader, (CharSequence)logoutPage)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doesUserHaveApplicationLicense(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            return false;
        }
        ApplicationAuthorizationService authService = (ApplicationAuthorizationService)ComponentAccessor.getComponent(ApplicationAuthorizationService.class);
        List applicationKeys = List.of((Object[])new ApplicationKey[]{ApplicationKeys.SERVICE_DESK, ApplicationKeys.CORE, ApplicationKeys.SOFTWARE});
        for (ApplicationKey appKey : applicationKeys) {
            if (!authService.canUseApplication(user, appKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUserProperties(User user, Map<String, String> properties, boolean isRemoveUnusedUserAttributes) {
        UserPropertyManager userPropertyManager = ComponentAccessor.getUserPropertyManager();
        ApplicationUser applicationUser = ComponentAccessor.getUserManager().getUserByName(user.getName());
        if (applicationUser != null && properties != null) {
            PropertySet propertySet = userPropertyManager.getPropertySet(applicationUser);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                propertySet.setString(JIRA_VISIBLE_PROPERTY_PREFIX + entry.getKey(), entry.getValue());
                propertySet.setString(JIRA_KSSO_PROPERTY_PREFIX + entry.getKey(), JIRA_VISIBLE_PROPERTY_PREFIX + entry.getKey());
            }
            if (isRemoveUnusedUserAttributes) {
                for (Map.Entry<String, String> element : propertySet.getKeys()) {
                    String key = (String)((Object)element);
                    if (!key.startsWith(JIRA_KSSO_PROPERTY_PREFIX) || properties.containsKey(key.replace(JIRA_KSSO_PROPERTY_PREFIX, ""))) continue;
                    propertySet.remove(key);
                    propertySet.remove(key.replace(JIRA_KSSO_PROPERTY_PREFIX, JIRA_VISIBLE_PROPERTY_PREFIX));
                }
            }
        }
    }

    @Override
    public String getTargetAfterRedirect(HttpServletRequestFacade request) {
        boolean isJsm = this.isJsmLoginPage(request);
        String target = super.getTargetAfterRedirect(request);
        if (!isJsm || StringUtils.contains((CharSequence)target, (CharSequence)this.getJsmUrlPart())) {
            return target;
        }
        String baseUrl = HttpUrlUtils.getRequestBaseUrl((HttpServletRequestFacade)request);
        return StringUtils.replace((String)target, (String)baseUrl, (String)(baseUrl + this.getJsmUrlPart()));
    }

    public static class CanUseStatus {
        private final ApplicationUser user;
        private boolean hasGlobalAdminPermission;
        private boolean hasAnyRole;

        public CanUseStatus(String username) {
            this.user = this.createApplicationUser(username);
        }

        @NotNull
        private ApplicationUser createApplicationUser(final String userName) {
            return new ApplicationUser(){

                public String getKey() {
                    return userName;
                }

                public String getUsername() {
                    return userName;
                }

                public String getName() {
                    return userName;
                }

                public long getDirectoryId() {
                    return 0L;
                }

                public boolean isActive() {
                    return true;
                }

                public String getEmailAddress() {
                    return null;
                }

                public String getDisplayName() {
                    return null;
                }

                public User getDirectoryUser() {
                    return null;
                }

                public Long getId() {
                    return null;
                }
            };
        }

        public boolean hasGlobalAdminPermission() {
            return this.hasGlobalAdminPermission;
        }

        public boolean hasAnyRole() {
            return this.hasAnyRole;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CanUseStatus invoke() {
            Thread ct = Thread.currentThread();
            ClassLoader oldCcl = ct.getContextClassLoader();
            try {
                GlobalPermissionManager globalPermissionManager = (GlobalPermissionManager)ComponentLocator.getComponent(GlobalPermissionManager.class);
                ct.setContextClassLoader(GlobalPermissionManager.class.getClassLoader());
                this.hasGlobalAdminPermission = globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.user);
                ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentLocator.getComponent(ApplicationRoleManager.class);
                this.hasAnyRole = applicationRoleManager.hasAnyRole(this.user);
            }
            finally {
                ct.setContextClassLoader(oldCcl);
            }
            return this;
        }
    }
}

