/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.kantegasso.servlet.custom.SetSameSiteResponseWrapper;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.security.SameSiteCookiePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetSameSiteCookieInResponseWrapper
extends SetSameSiteResponseWrapper {
    private final HttpServletRequestFacade request;
    private final HttpServletResponseFacade response;
    private final ArrayList<String> sessionIdCookieNames = new ArrayList();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SameSiteCookiePolicy sameSiteCookiePolicy;

    public SetSameSiteCookieInResponseWrapper(HttpServletRequestFacade request, HttpServletResponseFacade response, SameSiteCookiePolicy sameSiteCookiePolicy) {
        super(response);
        this.sessionIdCookieNames.add("JSESSIONID");
        this.sessionIdCookieNames.add("BITBUCKETSESSIONID");
        this.request = request;
        this.response = response;
        this.sameSiteCookiePolicy = sameSiteCookiePolicy;
    }

    protected void setSameSiteCookie() {
        if (this.sameSiteCookiePolicy == SameSiteCookiePolicy.DEFAULT) {
            return;
        }
        this.log.trace("KSSO: Changing set-cookie to SameSite=" + this.sameSiteCookiePolicy.value());
        Collection setSessionIdCookieHeaders = this.response.getHeaders("Set-Cookie").stream().filter(setSessionIdCookieHeader -> this.sessionIdCookieNames.stream().anyMatch(cookieName -> setSessionIdCookieHeader.contains((CharSequence)cookieName))).filter(header -> !header.contains(String.format("SameSite=%s", this.sameSiteCookiePolicy.value()))).collect(Collectors.toCollection(ArrayList::new));
        for (String cookieHeader : setSessionIdCookieHeaders) {
            if (!StringUtils.contains((CharSequence)cookieHeader, (CharSequence)"Secure") && StringUtils.equals((CharSequence)this.request.getScheme(), (CharSequence)"https")) {
                this.log.trace("Setting cookie secure");
                this.response.setHeader("Set-Cookie", String.format("%s; SameSite=%s%s", cookieHeader, this.sameSiteCookiePolicy.value(), this.sameSiteCookiePolicy.additionalAttributes()));
                continue;
            }
            this.log.trace("Setting cookie (secure already set or plain HTTP)");
            this.response.setHeader("Set-Cookie", String.format("%s; SameSite=%s", cookieHeader, this.sameSiteCookiePolicy.value()));
        }
    }
}

