/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.snapshot;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction1;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.json.JSONObject;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.backup.BackupService;
import org.kantega.atlaskerb.rest.resource.api.snapshot.RestoreSnapshot;
import org.kantega.atlaskerb.rest.resource.api.snapshot.SnapshotCreatedResponseModel;
import org.kantega.atlaskerb.rest.resource.api.snapshot.SnapshotInfoModel;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config/snapshot/")
public class ConfigSnapshotResource {
    private final Logger log = LoggerFactory.getLogger(ConfigSnapshotResource.class);
    private final UserManager userManager;
    private final BackupService snapshotService;
    private final JsonWrapper jsonWrapper;

    @Inject
    public ConfigSnapshotResource(@ComponentImport UserManager userManager, BackupService snapshotService, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.snapshotService = snapshotService;
        this.jsonWrapper = jsonWrapper;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            List<BackupInfo> snapshots = this.snapshotService.getBackups();
            List snapshotInfoModelList = snapshots.stream().map(SnapshotInfoModel::new).collect(Collectors.toList());
            JSONObject debugJson = new JSONObject();
            debugJson.put("snapshotInfo", snapshotInfoModelList);
            this.log.info("Kantega SSO API Retrieving configuration snapshots");
            this.log.debug(String.format("Kantega SSO API Listing available snapshots %s", debugJson.toString(4)));
            try {
                return Response.ok((Object)this.jsonWrapper.buildJsonString(snapshotInfoModelList)).build();
            }
            catch (JsonProcessingException e) {
                this.log.error("KSSO: something went wrong processing json object ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        });
    }

    @POST
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, @DefaultValue(value="") @QueryParam(value="description") String snapshotInput) {
        return ResponseUtils.sysadminOnly(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            String snapshotDescription = snapshotInput.isEmpty() ? this.snapshotService.filename() : snapshotInput;
            File snapshot = this.snapshotService.createBackup(snapshotDescription);
            this.log.info(String.format("Kantega SSO API Created snapshot via REST api %s", snapshot.getName()));
            try {
                return Response.ok((Object)this.jsonWrapper.buildJsonString(new SnapshotCreatedResponseModel(snapshot.getName()))).build();
            }
            catch (JsonProcessingException e) {
                this.log.error("KSSO: something went wrong processing json object ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        });
    }

    @Path(value="/restore/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, @PathParam(value="id") String snapshotInput, @QueryParam(value="makeSnapshot") boolean makeSnapshot) {
        return RestoreSnapshot.run(this.userManager, this.snapshotService, HttpServletRequestFacade.of((HttpServletRequest)request), snapshotInput, makeSnapshot, this.jsonWrapper);
    }
}

