/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.config.ConfigurationException;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.UUID;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.cleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserCleanupJobRunner
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(String.valueOf(UserCleanupJobRunner.class) + ".job"));
    private static final Logger log = LoggerFactory.getLogger(UserCleanupJobRunner.class);
    private final HostApp hostApp;

    @Inject
    public UserCleanupJobRunner(HostAppFactory hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (this.hostApp.isProductInReadOnlyMode()) {
            log.warn("Product is in read-only mode. Skipping UserCleanup job.");
            return JobRunnerResponse.aborted((String)"Product is in read-only mode. Skipping UserCleanup job.");
        }
        try {
            log.info(String.format("UserCleanup: Starting scheduled run, previous CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
            if (this.hostApp.getUserCleanupExecuteStatus() == InactiveUserCleaner.CleanupStatus.RUNNING) {
                log.warn(String.format("UserCleanup: Scheduled run did not start since a cleanup is already running, CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
                return JobRunnerResponse.aborted((String)"Cleanup already running");
            }
            this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.RUNNING);
            this.hostApp.cleanupInactiveUsers(null, new DryRunAttributes(false, false, false), DateTime.now(), UUID.randomUUID().toString());
        }
        catch (ConfigurationException e) {
            this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.FAILED);
            log.error(String.format("UserCleanup: Scheduled run failed, current CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
            return JobRunnerResponse.failed((Throwable)e);
        }
        this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.SUCCESS);
        log.info(String.format("UserCleanup: Scheduled run succeeded, current CleanupStatus is %s", this.hostApp.getUserCleanupExecuteStatus().toString()));
        return JobRunnerResponse.success();
    }
}

