/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.kantega.atlaskerb.connector.model.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureDirectory
extends Directory {
    private static final String TENANT_ID = "tenantId";
    private static final String APPLICATION_ID = "applicationId";
    private static final String APPLICATION_SECRET = "applicationSecret";
    private static final String AVATAR_FETCH_ACTIVE = "avatarFetchActive";
    private static final String AVATAR_FETCH_FREQUENCY = "avatarFetchFrequency";
    private static final String AVATAR_LAST_FETCH_DATE = "avatarLastFetchDate";
    private static final String AVATAR_FETCH_STATUS = "avatarFetchStatus";
    private static final Logger log = LoggerFactory.getLogger(AzureDirectory.class);
    private static final String USE_SAM_ACCOUNT_NAME = "useSAMAccountName";

    public AzureDirectory(Directory.Common common, String tenantId, String applicationId, String applicationSecret, String isAvatarFetchActive, String avatarFetchFrequency, String avatarLastFetchDate, String avatarFetchStatus, boolean useSAMAccountName) {
        super(common);
        this.properties.put(TENANT_ID, tenantId);
        this.properties.put(APPLICATION_ID, applicationId);
        this.properties.put(APPLICATION_SECRET, applicationSecret);
        this.properties.put(AVATAR_FETCH_ACTIVE, isAvatarFetchActive);
        this.properties.put(AVATAR_FETCH_FREQUENCY, avatarFetchFrequency);
        this.properties.put(AVATAR_LAST_FETCH_DATE, avatarLastFetchDate);
        this.properties.put(AVATAR_FETCH_STATUS, avatarFetchStatus);
        this.properties.put(USE_SAM_ACCOUNT_NAME, Boolean.toString(useSAMAccountName));
    }

    public String getTenantId() {
        return this.properties.getProperty(TENANT_ID);
    }

    public String getApplicationId() {
        return this.properties.getProperty(APPLICATION_ID);
    }

    public String getApplicationSecret() {
        return this.properties.getProperty(APPLICATION_SECRET);
    }

    public boolean isAvatarFetchActive() {
        return Boolean.parseBoolean(this.properties.getProperty(AVATAR_FETCH_ACTIVE));
    }

    public int getAvatarFetchFrequency() {
        int avatarFetchFrequency = 24;
        try {
            avatarFetchFrequency = Integer.parseInt(this.properties.getProperty(AVATAR_FETCH_FREQUENCY));
        }
        catch (NumberFormatException e) {
            log.warn("Unable to parse avatar fetch frequency property: {}", (Object)e.getMessage());
        }
        return avatarFetchFrequency;
    }

    public LocalDateTime getAvatarLastFetchDate() {
        try {
            return LocalDateTime.parse(this.properties.getProperty(AVATAR_LAST_FETCH_DATE));
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getAvatarFetchStatus() {
        return this.properties.getProperty(AVATAR_FETCH_STATUS);
    }

    public boolean isAvatarFetchRunning() {
        return this.getAvatarFetchStatus().equals(AvatarFetchStatus.RUNNING.name());
    }

    public void setAvatarFetchStatus(AvatarFetchStatus newStatus) {
        this.properties.setProperty(AVATAR_FETCH_STATUS, newStatus.name());
    }

    public void setAvatarLastFetchDateToCurrentDate() {
        this.properties.setProperty(AVATAR_LAST_FETCH_DATE, String.valueOf(LocalDateTime.now()));
    }

    public void setAvatarFetchActive(boolean isAvatarFetchActive) {
        this.properties.setProperty(AVATAR_FETCH_ACTIVE, Boolean.toString(isAvatarFetchActive));
    }

    public void setAvatarFetchFrequency(int avatarFetchFrequency) {
        this.properties.setProperty(AVATAR_FETCH_FREQUENCY, String.valueOf(avatarFetchFrequency));
    }

    @Override
    public String getDisplayName() {
        return this.getTenantId();
    }

    public boolean isUseSAMAccountName() {
        return Boolean.parseBoolean(this.properties.getProperty(USE_SAM_ACCOUNT_NAME));
    }

    public void setUseSAMAccountName(boolean useSAMAccountName) {
        this.properties.put(USE_SAM_ACCOUNT_NAME, Boolean.toString(useSAMAccountName));
    }

    public static enum AvatarFetchStatus {
        NOT_RUN,
        RUNNING,
        FAILED,
        SUCCESS;

    }
}

