/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatedAuthenticationDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.kantegasso.commons.fileupload.FileItemFacade;
import com.kantegasso.commons.fileupload.ServletFileUploadFacade;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.http.CachedBodyHttpServletRequest;
import com.kantegasso.servlet.http.CookieFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import com.kantegasso.servlet.http.MultipartHttpRequest;
import com.ksso.scim.spi.ScimServerSpi;
import io.prometheus.client.Summary;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.joda.time.DateTime;
import org.json.JSONObject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.cleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.diagnostics.metrics.KSSOPluginMetrics;
import org.kantega.atlaskerb.hostapp.DefaultRemoteUserUpdater;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.RemoteUserUpdater;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SsoScriptLoginHookUrlReadingCondition;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimTenantConfig;
import org.kantega.atlaskerb.security.CookieSecurity;
import org.kantega.atlaskerb.utils.AuthorizationUtil;
import org.kantega.atlaskerb.utils.CryptoUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.TargetParameterUtils;
import org.kantega.atlaskerb.wrapper.crowd.CrowdUserWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultHostApp
implements HostApp {
    private static final Logger log = LoggerFactory.getLogger(DefaultHostApp.class);
    private static final String KSSO_SAML_JIT = "ksso.saml.jit";
    protected final java.util.List<String> preemptivePathMappings = new ArrayList<String>();
    private final DelegatedAuthenticationDirectoryInstanceLoader delegatedInstanceLoader;
    private final ApplicationService applicationService;
    private final DirectoryManager directoryManager;
    private final RemoteUserUpdater remoteUserUpdater;
    protected boolean hasRestApi;
    final TransactionTemplate transactionTemplate;
    final KerbConfManager kerbConfManager;
    final ApplicationProperties applicationProperties;
    final AuthenticationListener authenticationListener;
    final AuthenticationController authenticationController;
    final EventPublisher eventPublisher;
    final SafeRedirect safeRedirect;
    final CrowdDirectoryService crowdDirectoryService;
    final CrowdService crowdService;
    IdpConfManager idpConfManager;
    final JsonWrapper jsonWrapper;
    final InactiveUserCleaner inactiveUserCleaner;
    final PluginAccessor pluginAccessor;
    final ServletFileUploadFacade upload = new ServletFileUploadFacade();

    public DefaultHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, PluginAccessor pluginAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        this.transactionTemplate = transactionTemplate;
        this.delegatedInstanceLoader = this.findComponent(DelegatedAuthenticationDirectoryInstanceLoader.class);
        this.applicationService = this.findComponent(ApplicationService.class);
        this.directoryManager = this.findComponent(DirectoryManager.class);
        this.remoteUserUpdater = new DefaultRemoteUserUpdater(this.findComponent(DbCachingRemoteDirectoryInstanceLoader.class));
        this.kerbConfManager = kerbConfManager;
        this.applicationProperties = applicationProperties;
        this.authenticationListener = authenticationListener;
        this.eventPublisher = eventPublisher;
        this.authenticationController = authenticationController;
        this.pluginAccessor = pluginAccessor;
        this.safeRedirect = safeRedirect;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
        this.jsonWrapper = jsonWrapper;
        this.inactiveUserCleaner = new InactiveUserCleaner(this, kerbConfManager, crowdService, crowdDirectoryService, jsonWrapper);
    }

    public DefaultHostApp() {
        this.delegatedInstanceLoader = null;
        this.directoryManager = null;
        this.remoteUserUpdater = null;
        this.transactionTemplate = null;
        this.kerbConfManager = null;
        this.applicationProperties = null;
        this.applicationService = null;
        this.authenticationListener = null;
        this.eventPublisher = null;
        this.authenticationController = null;
        this.pluginAccessor = null;
        this.safeRedirect = null;
        this.crowdDirectoryService = null;
        this.crowdService = null;
        this.jsonWrapper = null;
        this.inactiveUserCleaner = null;
    }

    @Override
    public InactiveUserCleaner getInactiveUserCleaner() {
        return this.inactiveUserCleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optionallyUpdateUserFromRemoteDirectory(String username, Directory directory, boolean isNewlyCreatedUser) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        Summary.Timer timer = KSSOPluginMetrics.optionalUserUpdateLatency.startTimer();
        try {
            boolean doUpdate;
            boolean bl = doUpdate = this.isAlwaysSyncGroups(directory) || this.isSyncGroupsOnFirstCreated(directory) && isNewlyCreatedUser;
            if (doUpdate && (directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR)) {
                this.remoteUserUpdater.updateUser(username, directory, this);
            }
        }
        catch (Exception e) {
            log.error("Unable to update group memberships during login. LDAP might be overloaded or unavailable.", (Throwable)e);
        }
        finally {
            timer.observeDuration();
        }
    }

    @Override
    public boolean isAlwaysSyncGroups(Directory directory) {
        return "true".equalsIgnoreCase((String)directory.getAttributes().get("crowd.sync.group.membership.after.successful.user.auth.enabled"));
    }

    @Override
    public boolean isSyncGroupsOnFirstCreated(Directory directory) {
        return "only_when_first_created".equalsIgnoreCase((String)directory.getAttributes().get("crowd.sync.group.membership.after.successful.user.auth.enabled"));
    }

    @Override
    public boolean createDelegatedUser(Directory directory, String username) {
        try {
            DelegatedAuthenticationDirectory remote = (DelegatedAuthenticationDirectory)this.getDelegatedInstanceLoader().getDirectory(directory);
            this.addOrUpdateLdapUser(username, remote);
            return true;
        }
        catch (UserNotFoundException e) {
            log.debug("Delegated user not created for user/lookupname '{}'", (Object)username, (Object)e);
            return false;
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrUpdateLdapUser(String username, DelegatedAuthenticationDirectory remote) throws UserNotFoundException, OperationFailedException {
        Thread ct = Thread.currentThread();
        ClassLoader oldCcl = ct.getContextClassLoader();
        try {
            ct.setContextClassLoader(CrowdService.class.getClassLoader());
            remote.addOrUpdateLdapUser(username);
        }
        catch (UserNotFoundException u) {
            log.debug("User not found in this delegated directory which is expected if users is removed by filter", (Throwable)u);
        }
        finally {
            ct.setContextClassLoader(oldCcl);
        }
    }

    @Override
    public void optionallyUpdateDelegatedUser(Directory directory, com.atlassian.crowd.model.user.User user) {
        try {
            DelegatedAuthenticationDirectory remote = (DelegatedAuthenticationDirectory)this.getDelegatedInstanceLoader().getDirectory(directory);
            boolean updateUser = Boolean.parseBoolean((String)directory.getAttributes().get("crowd.delegated.directory.auto.update.user"));
            boolean importGroups = Boolean.parseBoolean((String)directory.getAttributes().get("crowd.delegated.directory.importGroups"));
            if (updateUser || importGroups) {
                this.addOrUpdateLdapUser(user.getName(), remote);
            }
        }
        catch (UserNotFoundException e) {
            throw new IllegalStateException("User not found", e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Option<String> getAnonymousBrowsingSettingsUrl() {
        return Option.none();
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        return ldapPasswordParameter;
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter, String dummy) {
        return this.optionallyDecryptLdapPassword(ldapPasswordParameter);
    }

    protected Option<String> decryptLdapPassword(String encryptedLdapPassword, String encryptorClassName, String componentManagerClassName) {
        try {
            ClassLoader loader = this.getClass().getClassLoader().getParent();
            Class<?> componentManagerClass = loader.loadClass(componentManagerClassName);
            Method getInstanceMethod = componentManagerClass.getMethod("getInstance", new Class[0]);
            Object componentManager = getInstanceMethod.invoke(null, new Object[0]);
            Class[] params = new Class[]{Class.class};
            Method getComponentMethod = componentManagerClass.getDeclaredMethod("getComponent", params);
            params[0] = loader.loadClass(encryptorClassName);
            Object encryptor = getComponentMethod.invoke(componentManager, (Object[])params);
            params[0] = String.class;
            Method decryptMethod = loader.loadClass(encryptorClassName).getDeclaredMethod("decrypt", params);
            Object[] encryptedPasswordParam = new String[]{encryptedLdapPassword};
            String ldapPassword = (String)decryptMethod.invoke(encryptor, encryptedPasswordParam);
            if (CryptoUtils.secretIndicatesEncryptedValue((String)ldapPassword)) {
                log.warn("Could not decode LDAP/AD password from database. Check that username/password logins against your LDAP User Directory works. If not, you may have to recreate the LDAP User Directory.");
            }
            return Option.of((Object)ldapPassword);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Could not load method in LDAP password fetch: ", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Failed to fetch LDAP password: ", (Throwable)e);
        }
        return Option.none();
    }

    @Override
    public RemoteDirectory getAuthorativeDirectory(DbCachingRemoteDirectory directoryInstance) {
        return directoryInstance.getAuthoritativeDirectory();
    }

    @Override
    public void optionallyAddCrowdGroups(com.atlassian.crowd.model.user.User user) {
        HashSet<String> addGroups = new HashSet<String>();
        String crowdAutoAddGroups = this.kerbConfManager.getCrowdAutoAddGroups();
        if (crowdAutoAddGroups != null) {
            for (String g : crowdAutoAddGroups.split(",")) {
                if ((g = g.trim()).isEmpty()) continue;
                addGroups.add(g);
            }
        }
        for (String addGroup : addGroups) {
            Group group = this.getCrowdService().getGroup(addGroup);
            if (group == null) continue;
            try {
                this.getCrowdService().addUserToGroup((User)user, group);
            }
            catch (OperationNotPermittedException | com.atlassian.crowd.exception.runtime.OperationFailedException throwable) {}
        }
    }

    @Override
    public boolean setDefaultGroups(Principal principal, Directory directory) {
        String autoAddGroupsDefinedInLdap = (String)directory.getAttributes().get("autoAddGroups");
        if (StringUtils.isNotBlank((CharSequence)autoAddGroupsDefinedInLdap)) {
            HashSet<String> groupItems = new HashSet<String>(Arrays.asList(autoAddGroupsDefinedInLdap.split("\\|")));
            for (String group : groupItems) {
                group = StringUtils.isNotBlank((CharSequence)group.trim()) ? group.trim() : group;
                try {
                    if (this.isUserInGroup(principal.getName(), group)) continue;
                    this.addUserToGroup(principal, group);
                }
                catch (Exception e) {
                    log.warn("Trying to add default ldap groups at login. Could not assign {} to {}. Error: {}", new Object[]{principal.getName(), group, e.getMessage()});
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public java.util.List<String> getRequireLoginPathMappings() {
        return this.preemptivePathMappings;
    }

    <T> T findComponent(Class<T> type) {
        Collection component = ComponentLocator.getComponents(type);
        return component.isEmpty() ? null : (T)component.iterator().next();
    }

    @Override
    public boolean isRequestMapped(HttpServletRequestFacade req, String r) {
        return false;
    }

    @Override
    public boolean isRESTRequestMapped(HttpServletRequestFacade req, String r) {
        if (!this.isRestApi(r)) {
            log.debug("Request is not RestAPI");
            return false;
        }
        if (!this.kerbConfManager.isKerberosRestAuthEnabled()) {
            log.debug("Kerberos for REST is off");
            return false;
        }
        if (AuthorizationUtil.isBasicAuth((HttpServletRequestFacade)req)) {
            log.debug("Request is isBasicAuth");
            return false;
        }
        if (this.isOAuth(req)) {
            log.debug("Request is isOAuth");
            return false;
        }
        if (this.isRestApiExcluded(r)) {
            log.debug("Request is excluded from REST API list");
            return false;
        }
        if (req.getAttribute("javax.servlet.forward.request_uri") != null) {
            log.debug("Request is forwarded for proxy");
            return false;
        }
        if (!this.kerbConfManager.isKerberosRestFromBrowserEnabled() && StringUtils.isNotBlank((CharSequence)req.getHeader("referer"))) {
            log.debug("Request isKerberosRestFromBrowserEnabled (containing referer) is off");
            return false;
        }
        String remoteAddress = this.kerbConfManager.getRemoteIpAddress(req);
        IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
        IpRestrictionFilter restFilter = restrictionCfg.getRestIpFilter();
        boolean isRemoteAddressEnabled = restFilter.isRemoteAddressEnabled(remoteAddress);
        log.debug("isRemoteAddressEnabled: {}", (Object)isRemoteAddressEnabled);
        return isRemoteAddressEnabled;
    }

    @Override
    public boolean isOAuth(HttpServletRequestFacade req) {
        String azn = req.getHeader("Authorization");
        if (azn != null) {
            return (azn = azn.toLowerCase()).startsWith("oauth") || azn.startsWith("bearer");
        }
        return false;
    }

    @Override
    public boolean isForceLoginRequestMapped(HttpServletRequestFacade req) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        Set<String> forcedSsoUrls = this.kerbConfManager.getForcedSsoUrls();
        for (String url : forcedSsoUrls) {
            boolean matching;
            if (StringUtils.endsWith((CharSequence)url, (CharSequence)"*")) {
                url = StringUtils.substringBeforeLast((String)url, (String)"*");
                matching = StringUtils.startsWith((CharSequence)internalPath, (CharSequence)url);
            } else {
                matching = StringUtils.equals((CharSequence)internalPath, (CharSequence)url);
            }
            if (!matching) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultRestEndpointForAuthentication(HttpServletRequestFacade req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return "/rest/tsv/1.0/authenticate".equals(r);
    }

    @Override
    public boolean isLoginRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public boolean isJsmLogoutPage(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public boolean isAuthTokenRequest(HttpServletRequestFacade req) {
        return this.isOAuth(req) || AuthorizationUtil.isBasicAuth((HttpServletRequestFacade)req);
    }

    @Override
    public boolean isPasswordLoginRequest(HttpServletRequestFacade req) {
        return this.legacyIsPasswordLoginRequest(req) || this.newIsPasswordLoginRequest(req);
    }

    protected boolean legacyIsPasswordLoginRequest(HttpServletRequestFacade req) {
        return StringUtils.isNotBlank((CharSequence)this.legacyGetLoginRequestPassword(req));
    }

    @Override
    public String getLoginRequestPassword(HttpServletRequestFacade req) {
        return this.legacyGetLoginRequestPassword(req) != null ? this.legacyGetLoginRequestPassword(req) : this.newGetLoginRequestPassword(req);
    }

    public String legacyGetLoginRequestPassword(HttpServletRequestFacade req) {
        return req.getParameter("os_password");
    }

    protected String newGetLoginRequestPassword(HttpServletRequestFacade req) {
        try {
            JSONObject jsonObject = new JSONObject(this.readRequestBody(req));
            if (jsonObject.has("password")) {
                return jsonObject.getString("password");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean newIsPasswordLoginRequest(HttpServletRequestFacade req) {
        if ("POST".equalsIgnoreCase(req.getMethod()) && req.getRequestURI().endsWith("/rest/tsv/1.0/authenticate")) {
            String body = this.readRequestBody(req);
            return body.contains("\"password\":");
        }
        return false;
    }

    protected String readRequestBody(HttpServletRequestFacade req) {
        if (req instanceof CachedBodyHttpServletRequest) {
            log.trace("Request is CachedBodyHttpServletRequest");
        } else {
            log.trace("Request is not CachedBodyHttpServletRequest");
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = req.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            log.error("Error reading request body", (Throwable)e);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequestFacade req) {
        return this.legacyGetLoginRequestUsername(req) != null ? this.legacyGetLoginRequestUsername(req) : this.newGetLoginRequestUsername(req);
    }

    protected String legacyGetLoginRequestUsername(HttpServletRequestFacade req) {
        return req.getParameter("os_username");
    }

    protected String newGetLoginRequestUsername(HttpServletRequestFacade req) {
        try {
            JSONObject jsonObject = new JSONObject(this.readRequestBody(req));
            if (jsonObject.has("username")) {
                return jsonObject.getString("username");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean hasRestApi() {
        return this.hasRestApi;
    }

    @Override
    public boolean isRestApi(String internalPath) {
        return (Boolean)Option.of((Object)internalPath).map(path -> path.startsWith("/rest/")).getOrElse((Object)false);
    }

    @Override
    public boolean shouldTryApiTokenAuthentication(HttpServletRequestFacade req) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        boolean inAccessUrls = false;
        Set<String> tokenAccessUrls = this.kerbConfManager.getApiTokenAccessUrls();
        for (String url : tokenAccessUrls) {
            try {
                if (!StringUtils.startsWith((CharSequence)internalPath, (CharSequence)HttpUrlUtils.urlDecode((String)url))) continue;
                inAccessUrls = true;
                break;
            }
            catch (UnsupportedEncodingException e) {
                log.error("Unable to decode API token access URLs");
            }
        }
        return !(this.kerbConfManager.isApiTokensEnabled() == false || !this.isRestApi(internalPath) && !inAccessUrls && !this.urlInAdditionalBuiltInApiRequest(req) || !HttpUrlUtils.requestHasBasicAuthHeader((HttpServletRequestFacade)req) && !ApiTokenUtil.requestHasApiTokenAuthHeader(req, this.kerbConfManager.getAdditionalBearerKey()));
    }

    @Override
    public boolean urlInAdditionalBuiltInApiRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public boolean shouldRequireCanLogin(HttpServletRequestFacade req) {
        return true;
    }

    @Override
    public boolean isLoggedIn(HttpServletRequestFacade req) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> req.getSessionKsso(false)).filterTry(Objects::nonNull).mapTry(this::isAppLoggedIn).getOrElse((Object)false);
    }

    @Override
    public boolean isRequestFromHostApp(HttpServletRequestFacade request) {
        boolean secFetchSiteHeaderMatches = (Boolean)Option.of((Object)request.getHeader("Sec-Fetch-Site")).peek(header -> log.debug("Sec-Fetch-Site header: " + header)).map(header -> List.of((Object[])new String[]{"same-origin", "same-site", "none"}).contains(header)).peek(contains -> log.debug("Sec-Fetch-Site contains same-origin, same-site or none: " + contains)).getOrElse((Object)false);
        String baseUrlHost = (String)Try.of((CheckedFunction0 & Serializable)() -> new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getHost()).onSuccess(uri -> log.debug("Base url host: " + uri)).getOrElse((Object)"");
        boolean originHeaderMatches = (Boolean)Try.of((CheckedFunction0 & Serializable)() -> request.getHeader("Origin")).mapTry((CheckedFunction1 & Serializable)header -> baseUrlHost.equals(new URI((String)header).getHost())).getOrElse((Object)false);
        boolean refererHeaderMatches = (Boolean)Try.of((CheckedFunction0 & Serializable)() -> request.getHeader("Referer")).mapTry((CheckedFunction1 & Serializable)header -> baseUrlHost.equals(new URI((String)header).getHost())).getOrElse((Object)false);
        return this.isLoggedIn(request) || originHeaderMatches || refererHeaderMatches || secFetchSiteHeaderMatches;
    }

    @Override
    public boolean isRestPathInternalAtlassianFunctionality(HttpServletRequestFacade request) {
        boolean isApplinksPath = (Boolean)Option.of((Object)request).map(HttpUrlUtils::getInternalPath).map(internalPath -> internalPath.startsWith("/rest/applinks") || internalPath.startsWith("/rest/capabilities") || internalPath.startsWith("/rest/gadgets")).getOrElse((Object)false);
        return isApplinksPath || this.isOAuth(request);
    }

    protected boolean isAppLoggedIn(HttpSessionFacade session) {
        return session.getAttribute("seraph_defaultauthenticator_user") != null;
    }

    @Override
    public void invalidateSession(HttpServletResponseFacade resp, HttpServletRequestFacade req) {
        Option.of((Object)req.getSessionKsso(false)).peek(HttpSessionFacade::invalidate);
    }

    @Override
    public void addSsoProtectedAnonymousBrowsingSession(String username, IdpConfiguration idpConfiguration, HttpServletRequestFacade request, HttpServletResponseFacade response, String targetUrl) throws IOException {
        Option.of((Object)request.getSession(true)).peek(authenticatedAnonymousBrowsingSession -> {
            authenticatedAnonymousBrowsingSession.setAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID", (Object)idpConfiguration.getId());
            authenticatedAnonymousBrowsingSession.setAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER", Option.of((Object)username).getOrElse((Object)"[anonymous]"));
        });
        if (StringUtils.isNotBlank((CharSequence)targetUrl)) {
            this.safeRedirect.sendRedirect(targetUrl, request, response, this);
        } else {
            response.sendRedirect(request.getContextPath() + "/");
        }
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequestFacade req, HttpServletResponseFacade resp) {
        return false;
    }

    protected final void metaRefresh(HttpServletResponseFacade resp, String url) throws IOException {
        resp.setContentType("text/html");
        resp.getWriter().print("<html><head><meta http-equiv=\"refresh\" content=\"0;URL='" + StringEscapeUtils.escapeHtml4((String)url) + "'\" /></head></html>");
    }

    @Override
    public void deleteIdpSessionDataCookie(HttpServletRequestFacade req, HttpServletResponseFacade res) {
        CookieFacade[] cookies = req.getCookiesKsso();
        if (cookies != null) {
            for (CookieFacade cookie : cookies) {
                if (!cookie.getName().equals("ksso_idp_session_data")) continue;
                CookieFacade delCookie = CookieSecurity.cookieWithDynamicSecurity(this.applicationProperties, "ksso_idp_session_data", null);
                delCookie.setMaxAge(0);
                delCookie.setPath(req.getContextPath() + "/");
                res.addCookie((Cookie)delCookie);
            }
        }
    }

    @Override
    public String getTargetParameterName() {
        return "os_destination";
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        this.preventCaching(resp);
        Object os_destination = req.getParameter("os_destination");
        if (os_destination != null) {
            if (((String)os_destination).startsWith("http")) {
                this.safeRedirect.sendRedirect((String)os_destination, req, resp, this);
            } else {
                if (!((String)os_destination).startsWith("/")) {
                    os_destination = "/" + (String)os_destination;
                }
                this.safeRedirect.sendRedirect(req.getContextPath() + (String)os_destination, req, resp, this);
            }
        } else {
            Object url = req.getRequestURI();
            String queryString = req.getQueryString();
            if (queryString != null) {
                url = (String)url + "?" + queryString;
            }
            this.safeRedirect.sendRedirect((String)url, req, resp, this);
        }
    }

    protected void preventCaching(HttpServletResponseFacade resp) {
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
    }

    @Override
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Override
    public ApplicationService getApplicationService() {
        return this.applicationService;
    }

    @Override
    public DelegatedAuthenticationDirectoryInstanceLoader getDelegatedInstanceLoader() {
        return this.delegatedInstanceLoader;
    }

    @Override
    public MultipartHttpRequest getMultipartRequest(HttpServletRequestFacade req, long maxSize) throws IOException {
        if (this.upload.isMultipartHttpContent(req)) {
            this.upload.setFileSizeMax(maxSize);
            final java.util.List list = this.upload.parseRequest(req);
            return new MultipartHttpRequest((HttpServletRequest)req){

                public String getParameter(String name) {
                    for (FileItemFacade fileItem : list) {
                        if (!fileItem.isFormField() || !name.equals(fileItem.getFieldName())) continue;
                        return fileItem.getString();
                    }
                    return null;
                }

                public Map<String, String[]> getParameterMap() {
                    HashMap params = new HashMap();
                    for (FileItemFacade fileItem : list) {
                        if (!fileItem.isFormField()) continue;
                        if (!params.containsKey(fileItem.getFieldName())) {
                            params.put(fileItem.getFieldName(), new ArrayList());
                        }
                        ((java.util.List)params.get(fileItem.getFieldName())).add(fileItem.getString());
                    }
                    HashMap<String, String[]> result = new HashMap<String, String[]>();
                    for (String name : params.keySet()) {
                        java.util.List values = (java.util.List)params.get(name);
                        result.put(name, values.toArray(new String[0]));
                    }
                    return result;
                }

                public byte[] getFile(String name) {
                    for (FileItemFacade fileItem : list) {
                        if (fileItem.isFormField() || !name.equals(fileItem.getFieldName())) continue;
                        return fileItem.get();
                    }
                    return null;
                }

                public String getFilename(String name) {
                    for (FileItemFacade fileItem : list) {
                        if (fileItem.isFormField() || !name.equals(fileItem.getFieldName())) continue;
                        return fileItem.getName();
                    }
                    return null;
                }
            };
        }
        return new MultipartHttpRequest((HttpServletRequest)req){

            public byte[] getFile(String name) {
                throw new IllegalStateException("Not a multipart request");
            }

            public String getFilename(String name) {
                throw new IllegalStateException("Not a multipart request");
            }
        };
    }

    @Override
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Override
    public boolean isPublicAccessEnabled() {
        return false;
    }

    @Override
    public boolean isUserInGroup(String username, String group) {
        if (username == null || group == null) {
            log.debug(String.format("Checked group memberships of username %s and group %s", username, group));
            return false;
        }
        return this.getCrowdService().isUserMemberOfGroup(username, group);
    }

    @Override
    public boolean isUserInRequiredGroups(String username) {
        Set<String> requiredGroups = this.kerbConfManager.getRequiredGroups();
        if (requiredGroups.isEmpty()) {
            return true;
        }
        return requiredGroups.stream().anyMatch(group -> this.isUserInGroup(username, (String)group));
    }

    @Override
    public boolean isExistingGroup(String groupName) {
        return this.getCrowdService().getGroup(groupName) != null;
    }

    @Override
    public Group getGroup(String groupName) {
        return this.getCrowdService().getGroup(groupName);
    }

    @Override
    public void addGroup(final String groupName) {
        try {
            this.getCrowdService().addGroup(new Group(){

                public String getName() {
                    return groupName;
                }

                public int compareTo(Group group) {
                    return groupName.compareTo(group.getName());
                }
            });
        }
        catch (InvalidGroupException e) {
            log.error("Unable to create group: " + groupName, (Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            log.error("Not enough rights to create group: " + groupName, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Unable to create group: '" + groupName + "' Possible read-only directory?", (Throwable)e);
        }
    }

    @Override
    public void addGroups(Set<String> groupNames) {
        for (String idpGroup : groupNames) {
            if (this.isExistingGroup(idpGroup)) continue;
            this.addGroup(idpGroup);
        }
    }

    @Override
    public boolean removeNonIdpGroupsFromUser(Principal principal, Set<String> groupsFromIdp) {
        boolean success = true;
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(principal.getName()).startingAt(0).returningAtMost(-1);
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableAndActive(directory) || directory.getType() != DirectoryType.INTERNAL) continue;
            try {
                java.util.List userCurrentGroups = this.getDirectoryManager().searchNestedGroupRelationships(directory.getId().longValue(), membershipQuery);
                for (String userGroup : userCurrentGroups) {
                    if (groupsFromIdp.contains(userGroup)) continue;
                    this.removeUserFromGroup(principal, userGroup);
                    log.debug("Removed user {} from group {} ", (Object)principal.getName(), (Object)userGroup);
                }
            }
            catch (DirectoryNotFoundException e) {
                log.error("Directory not found during group search", (Throwable)e);
                success = false;
            }
            catch (OperationFailedException e) {
                log.error("Operation failed during group search", (Throwable)e);
                success = false;
            }
        }
        return success;
    }

    @Override
    public boolean addUserToGroup(Principal principal, String groupName) {
        try {
            User user = this.crowdService.getUser(principal.getName());
            Group group = this.crowdService.getGroup(groupName);
            if (user != null && group != null) {
                this.getCrowdService().addUserToGroup(user, group);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error(String.format("Failed to add user '%s' to group '%s'. This is typically because the user and group are both in a read-only directory.", principal.getName(), groupName), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean removeUserFromGroup(Principal principal, String groupName) {
        try {
            User user = this.crowdService.getUser(principal.getName());
            Group group = this.crowdService.getGroup(groupName);
            if (user != null && group != null) {
                this.getCrowdService().removeUserFromGroup(user, group);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error(String.format("Failed removing user '%s' to group '%s'", principal.getName(), groupName), (Throwable)e);
            return false;
        }
    }

    @Override
    public String hasNonStandardAuthenticator() {
        String standardAuthenticatorClass = this.getStandardAuthenticatorClassName();
        if (standardAuthenticatorClass == null) {
            return null;
        }
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!authenticator.getClass().getName().equals(standardAuthenticatorClass)) {
            return authenticator.getClass().getName();
        }
        return null;
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return null;
    }

    @Override
    public boolean isModificationOnGetSupported() {
        return true;
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user, HttpServletRequestFacade httpServletRequest, HttpServletResponseFacade httpServletResponse) {
        User crowdServiceUser = this.getCrowdService().getUser(user.getName());
        Directory directory = this.getCrowdDirectoryService().findDirectoryById(crowdServiceUser.getDirectoryId());
        Application application = ((ApplicationFactory)ComponentLocator.getComponent(ApplicationFactory.class)).getApplication();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            com.atlassian.crowd.model.user.User userByName = manager.findUserByName(directory.getId().longValue(), user.getName());
            this.eventPublisher.publish((Object)new UserAuthenticatedEvent((Object)this, directory, application, userByName));
        }
        catch (DirectoryNotFoundException e) {
            log.error("Directory not found", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            log.error("User not found", (Throwable)e);
        }
        catch (OperationFailedException e) {
            log.error("Operation failed", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.debug("Unable to perform publishUserAuthenticatedEvent", (Throwable)e);
        }
    }

    @Override
    public Optional<Directory> findJitDirectory(Optional<Long> directoryId) {
        if (!directoryId.isPresent()) {
            return this.getDefaultJitDirectory();
        }
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!directory.getId().equals(directoryId.get())) continue;
            return Optional.of(directory);
        }
        return Optional.empty();
    }

    protected void seraphLikeInvalidateSession(HttpServletRequestFacade httpServletRequest) {
        HttpSessionFacade session = httpServletRequest.getSessionKsso(false);
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        if (!securityConfig.isInvalidateSessionOnLogin()) {
            return;
        }
        java.util.List excludeList = securityConfig.getInvalidateSessionExcludeList();
        if (session != null && !session.isNew()) {
            HashMap<String, Object> sessionContents = new HashMap<String, Object>();
            Enumeration attributes = session.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                if (excludeList.contains(name)) continue;
                sessionContents.put(name, session.getAttribute(name));
            }
            try {
                session.invalidate();
                HttpSessionFacade newSession = httpServletRequest.getSessionKsso(true);
                for (Map.Entry entry : sessionContents.entrySet()) {
                    newSession.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            catch (IllegalStateException e) {
                log.warn("Couldn't invalidate for request because " + e.getMessage());
            }
        }
    }

    @Override
    public boolean shouldEnableHardRedirect(HttpServletRequestFacade req) {
        String samlRedirectTarget = this.getRedirectTarget(req);
        return req.getParameter("noautosso") == null && (samlRedirectTarget == null || !samlRedirectTarget.contains("noautosso")) && !this.shouldDisableRedirect(req);
    }

    @Override
    public IdpConfiguration getInstantRedirectProvider(HttpServletRequestFacade req, HttpServletResponseFacade resp, SsoScriptLoginHookUrlReadingCondition loginScriptCondition) {
        java.util.List<IdpConfiguration> hardRedirectIdps;
        if (!this.shouldEnableHardRedirect(req) || this.shouldLoginManually(req, resp) && !this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            return null;
        }
        if (loginScriptCondition.shouldDoFederatedSSO(req) && ((hardRedirectIdps = this.idpConfManager.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.HARD)).size() == 1 || this.idpConfManager.isUseIdpPriority() && !hardRedirectIdps.isEmpty())) {
            return hardRedirectIdps.get(0);
        }
        return null;
    }

    @Override
    public boolean shouldDisableRedirect(HttpServletRequestFacade req) {
        if (req == null) {
            return false;
        }
        return req.getParameter("noredirect") != null || (Boolean)Option.of((Object)this.getRedirectTarget(req)).map(redirectTarget -> redirectTarget.contains("noredirect")).getOrElse((Object)false) != false;
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequestFacade request) {
        return this.authenticationController.canLogin(user, (HttpServletRequest)request);
    }

    @Override
    public boolean supportsRemoveAllRememberMeTokens() {
        return false;
    }

    @Override
    public void removeAllRememberMeTokens() {
        throw new RuntimeException("Not implemented for " + this.applicationProperties.getDisplayName() + ", check supportsRemoveAllRememberMeTokens before calling this method!");
    }

    @Override
    public void setRememberMeCookie(HttpServletRequestFacade request, HttpServletResponseFacade response, String username) {
        log.debug("Remember me functionality is not implemented for this product");
    }

    @Override
    public boolean canAddUser() {
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableDirectory(directory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWritableDirectory(Directory directory) {
        return (directory.getType() == DirectoryType.INTERNAL || directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR) && directory.getAllowedOperations().contains(OperationType.CREATE_USER) && directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    @Override
    public boolean isWritableAndActive(Directory directory) {
        return directory.isActive() && (directory.getType() == DirectoryType.INTERNAL || directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CROWD) && directory.getAllowedOperations().contains(OperationType.CREATE_USER);
    }

    @Override
    public boolean isDirectoryCanUpdateUser(Directory directory) {
        return directory != null && directory.isActive() && (directory.getType() == DirectoryType.INTERNAL || directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR) && directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    @Override
    public Set<Directory> getWritableUserDirectories() {
        HashSet<Directory> directories = new HashSet<Directory>();
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableDirectory(directory)) continue;
            directories.add(directory);
        }
        return directories;
    }

    @Override
    public Set<Directory> getWritableAndActiveUserDirectories() {
        HashSet<Directory> directories = new HashSet<Directory>();
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableDirectory(directory) || !directory.isActive()) continue;
            directories.add(directory);
        }
        return directories;
    }

    @Override
    public Optional<Directory> getDefaultJitDirectory() {
        HashSet<Directory> directories = new HashSet<Directory>();
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableAndActive(directory) || directory.getType() != DirectoryType.INTERNAL) continue;
            directories.add(directory);
        }
        if (directories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Directory)directories.iterator().next());
    }

    @Override
    public Directory getDirectoryForUser(String username) {
        User user = this.getCrowdService().getUser(username);
        if (user != null) {
            return this.getCrowdDirectoryService().findDirectoryById(user.getDirectoryId());
        }
        return null;
    }

    @Override
    public void addUser(Directory directory, String username, String fullName, String email, Set<String> groups, boolean isActive) throws UserAlreadyExistsException {
        this.addUser(directory, username, fullName, email, groups, isActive, null);
    }

    @Override
    public void addUser(Directory directory, String username, String fullName, String email, Set<String> groups, boolean isActive, Map<String, String> attributes) throws UserAlreadyExistsException {
        boolean isCreated = false;
        try {
            UserTemplateWithAttributes template = new UserTemplateWithAttributes(username, directory.getId().longValue());
            template.setDisplayName(fullName);
            template.setEmailAddress(email);
            template.setActive(isActive);
            template.setAttribute(KSSO_SAML_JIT, "true");
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    template.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            com.atlassian.crowd.model.user.UserWithAttributes u = this.getDirectoryManager().addUser(directory.getId().longValue(), template, PasswordCredential.NONE);
            isCreated = true;
            for (String groupName : groups) {
                Group group = this.getCrowdService().getGroup(groupName);
                if (group == null) continue;
                this.getCrowdService().addUserToGroup((User)u, group);
            }
            log.info("Successfully added new user " + username + " to directory " + directory.getName());
        }
        catch (UserAlreadyExistsException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setUserAttributes(User user, Map<String, String> attributes) throws OperationNotPermittedException {
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.crowdService.setUserAttribute(user, entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setUserProperties(User user, Map<String, String> properties, boolean isRemoveUnusedUserAttributes) {
        log.debug("Setting user properties is not implemented for this Atlassian product");
    }

    @Override
    public void updateUser(Directory directory, String username, String fullName, String email, boolean isActive) {
        try {
            UserTemplateWithAttributes template = new UserTemplateWithAttributes(username, directory.getId().longValue());
            template.setDisplayName(fullName);
            template.setEmailAddress(email);
            template.setActive(isActive);
            this.crowdService.updateUser((User)template);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateUserInDirectory(Directory directory, String username, String fullName, String email, boolean isActive) {
        try {
            UserTemplateWithAttributes template = new UserTemplateWithAttributes(username, directory.getId().longValue());
            template.setDisplayName(fullName);
            template.setEmailAddress(email);
            template.setActive(isActive);
            this.directoryManager.updateUser(directory.getId().longValue(), (UserTemplate)template);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<Group> getAllGroups() {
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)restriction, 0, -1);
        Iterable source = this.crowdService.search((Query)query);
        ArrayList<Group> target = new ArrayList<Group>();
        source.forEach(target::add);
        return target;
    }

    @Override
    public String getDefaultAdminGroupName() {
        return null;
    }

    @Override
    public String normalizeUsername(String username) {
        return username;
    }

    @Override
    public boolean isSMTPSupported() {
        return true;
    }

    @Override
    public boolean isSMTPEnabled() {
        MailServerManager serverManager = MailFactory.getServerManager();
        return serverManager.isDefaultSMTPMailServerDefined();
    }

    @Override
    public void sendEmail(String recipient, String subject, String body) {
        Email email = new Email(recipient);
        email.setSubject(subject);
        email.setBody(body);
        try {
            MailFactory.getServerManager().getDefaultSMTPMailServer().send(email);
        }
        catch (MailException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRedirectTarget(HttpServletRequestFacade req) {
        Object osDestination = req.getParameter("os_destination");
        if (osDestination != null) {
            if (this.safeRedirect.isLocal((String)osDestination)) {
                if (!((String)osDestination).startsWith("/")) {
                    osDestination = "/" + (String)osDestination;
                }
                return req.getContextPath() + (String)osDestination;
            }
            return osDestination;
        }
        return null;
    }

    @Override
    public File getHomeDirectory() {
        return new File(this.applicationProperties.getHomeDirectory(), "kerberos");
    }

    @Override
    public boolean isRestApiExcluded(String r) {
        String basePath = "/rest";
        if (r.startsWith(basePath)) {
            for (String path : this.kerbConfManager.getRestExcludedPaths()) {
                if (!r.startsWith(basePath + path)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isForwarded(HttpServletRequestFacade req) {
        return req.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    public static boolean shouldDispatchToLoginPage(KerbConfManager kerbConfManager) {
        return !kerbConfManager.isKeytabConfigured() && kerbConfManager.isRequireLogin() || kerbConfManager.isKeytabConfigured() && kerbConfManager.isRequireLogin() && kerbConfManager.isForceLogin();
    }

    @Override
    public boolean shouldCheckUserAccess() {
        return false;
    }

    @Override
    public boolean isSyncDirCompatible() {
        return true;
    }

    @Override
    public boolean isScimRequest(HttpServletRequestFacade req) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        return (Boolean)Option.of((Object)internalPath).map(path -> path.startsWith("/scim/") || path.startsWith("/plugins/servlet/ksso/scim/")).getOrElse((Object)false);
    }

    private boolean isHasRestApi() {
        return this.hasRestApi;
    }

    @Override
    public JSONObject asJson() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        JSONObject json = new JSONObject();
        JSONObject restAPIObj = new JSONObject();
        restAPIObj.put("has.rest.api", this.isHasRestApi());
        json.put("rest.api", (Object)restAPIObj);
        JSONObject environmentObj = new JSONObject();
        JSONObject javaObj = new JSONObject();
        javaObj.put("jvm.time.zone", (Object)TimeZone.getDefault().getDisplayName());
        javaObj.put("version", (Object)System.getProperty("java.version"));
        javaObj.put("class.path", (Object)System.getProperty("java.class.path"));
        javaObj.put("home", (Object)System.getProperty("java.home"));
        javaObj.put("vendor", (Object)System.getProperty("java.vendor"));
        environmentObj.put("java", (Object)javaObj);
        JSONObject osObj = new JSONObject();
        osObj.put("arch", (Object)System.getProperty("os.arch"));
        osObj.put("name", (Object)System.getProperty("os.name"));
        osObj.put("version", (Object)System.getProperty("os.version"));
        environmentObj.put("os", (Object)osObj);
        json.put("environment", (Object)environmentObj);
        JSONObject appPropsObj = new JSONObject();
        appPropsObj.put("display.name", (Object)this.applicationProperties.getDisplayName());
        appPropsObj.put("version", (Object)this.applicationProperties.getVersion());
        appPropsObj.put("base.url", (Object)this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        appPropsObj.put("platform.id", (Object)this.applicationProperties.getPlatformId());
        JSONObject buildObj = new JSONObject();
        buildObj.put("date", (Object)dateFormat.format(this.applicationProperties.getBuildDate()));
        buildObj.put("number", (Object)this.applicationProperties.getBuildNumber());
        appPropsObj.put("build", (Object)buildObj);
        appPropsObj.put("home.directory.path", Option.of((Object)this.applicationProperties.getHomeDirectory()).map(File::getAbsolutePath).getOrElse((Object)""));
        json.put("application.properties", (Object)appPropsObj);
        JSONObject crowdServiceObj = new JSONObject();
        crowdServiceObj.put("can.new.user.reset.password", this.crowdService.getCapabilitiesForNewUsers().canResetPassword());
        json.put("crowd.service", (Object)crowdServiceObj);
        return json;
    }

    @Override
    public java.util.List<String> getLogoutPages() {
        ArrayList<String> logoutPages = new ArrayList<String>();
        logoutPages.add(this.getMainLogoutPage());
        return logoutPages;
    }

    @Override
    public boolean isLogoutPage(HttpServletRequestFacade req) {
        String requestPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        for (String logoutPage : this.getLogoutPages()) {
            if (!logoutPage.equalsIgnoreCase(requestPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJiraCrowdRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public void setIdpConfManager(IdpConfManager idpConfManager) {
        this.idpConfManager = idpConfManager;
    }

    @Override
    public boolean isMsTeamsSecurityHeadersEnabled() {
        return this.kerbConfManager.isMsTeamsAuthenticationEnabled();
    }

    @Override
    public UserCleanupResult cleanupInactiveUsers(String currentUserName, DryRunAttributes dryRunAttributes, DateTime runTimestamp, String runId) throws ConfigurationException {
        return this.inactiveUserCleaner.cleanUsers(currentUserName, dryRunAttributes, runTimestamp, runId);
    }

    @Override
    public boolean isJsmLoginPage(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public String getLastLoginParameter() {
        return "login.lastLoginMillis";
    }

    @Override
    public UserWithAttributes getUserForCleanup(User user) {
        return this.crowdService.getUserWithAttributes(user.getName());
    }

    @Override
    public InactiveUserCleaner.CleanupStatus getUserCleanupExecuteStatus() {
        return this.inactiveUserCleaner.getUserCleanupExecuteStatus();
    }

    @Override
    public InactiveUserCleaner.CleanupStatus getJsmCleanupExecuteStatus() {
        return this.inactiveUserCleaner.getJsmCleanupExecuteStatus();
    }

    @Override
    public void setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus status) {
        this.inactiveUserCleaner.setUserCleanupExecuteStatus(status);
    }

    @Override
    public void setJsmCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus status) {
        this.inactiveUserCleaner.setJsmCleanupExecuteStatus(status);
    }

    @Override
    public boolean supportsAvatars(ApplicationProperties applicationProperties) {
        return applicationProperties.getPlatformId().equals("jira");
    }

    @Override
    public Map<String, String> mapNameToExternalId(java.util.List<User> userBatch, Map<String, String> userData) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public Map<String, String> getUsersProfilePicture(java.util.List<User> users) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public Map<String, String> getUsersProfilePictureForVelocity(java.util.List<CrowdUserWrapper> users) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public void setUserProfilePicture(String userName, String fileExtension, byte[] imageBytes, Path avatarDirPath) {
        throw new NotImplementedException("Setting profile picture is not supported yet.");
    }

    @Override
    public String getUserCleanupLastRunId() {
        return this.inactiveUserCleaner.getUserCleanupLastRunId();
    }

    @Override
    public String getJsmCleanupLastRunId() {
        return this.inactiveUserCleaner.getJsmCleanupLastRunId();
    }

    @Override
    public void setUserCleanupLastRunId(String lastRunId) {
        this.inactiveUserCleaner.setUserCleanupLastRunId(lastRunId);
    }

    @Override
    public boolean sendToDashboardAfterLogin() {
        return true;
    }

    @Override
    public void setJsmCleanupLastRunId(String lastRunId) {
        this.inactiveUserCleaner.setJsmCleanupLastRunId(lastRunId);
    }

    @Override
    public boolean isJsmUser(String username) {
        throw new NotImplementedException("Checking for JSM membership is only enabled in Jira");
    }

    @Override
    public Set<Group> getJSMGroups() {
        throw new NotImplementedException("Retrieving JSM groups is only enabled in Jira");
    }

    @Override
    public void hasUsedTraditionalLogin(HttpServletRequestFacade request, HttpServletResponseFacade response) {
        request.getSessionKsso().setAttribute("hasUsedTraditionalLogin", (Object)true);
    }

    @Override
    public void notLoginRequest(HttpServletRequestFacade request, HttpServletResponseFacade response) {
    }

    @Override
    public String getLicenseEndpoint() {
        return "/rest/plugins/1.0/" + PluginKey.getPluginKeyBasepart() + "-key/license";
    }

    @Override
    public void readUsersIntoCache(ScimConfManager.ScimConfigState state, List<ScimTenantConfig> tenantConfigs) {
        log.debug("readAllUsersIntoCache triggering.");
        Runnable runnable = () -> {
            log.debug("readAllUsersIntoCache for SCIM dir.");
            for (String tenantId : state.getSpiMap().keySet()) {
                ScimServerSpi spi = (ScimServerSpi)state.getSpiMap().get((Object)tenantId).getOrElseThrow(() -> new RuntimeException("Unable to get spi for given tenantId"));
                ScimTenantConfig config = (ScimTenantConfig)tenantConfigs.find(c -> c.getTenantId().equals(tenantId)).get();
                spi.readAllUsersIntoCache(true, config.isUseCacheFile());
            }
            log.debug("readAllUsersIntoCache for SCIM dir finished.");
        };
        new Thread(runnable).start();
        log.debug("readAllUsersIntoCache triggered.");
    }

    @Override
    public boolean isProductInReadOnlyMode() {
        return false;
    }

    @Override
    public void storeLdapPassword(HttpServletRequestFacade req) {
    }

    @Override
    public boolean isEditAccountGetRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public boolean isAdminEditAccountGetRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public boolean isEditAccountPostRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public boolean isAdminEditAccountPostRequest(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public String getEditAccountName(HttpServletRequestFacade req) {
        return null;
    }

    @Override
    public String getEditAccountEmail(HttpServletRequestFacade req) {
        return null;
    }

    @Override
    public UserProfile getEditAccountUser(UserManager userManager, HttpServletRequestFacade req) {
        return null;
    }

    @Override
    public String getDatabaseUrl() {
        return null;
    }

    @Override
    public void setUserProfileValue(String username, String key, String value) {
    }

    @Override
    public List<String> getUserProfileKeys() {
        return List.empty();
    }

    @Override
    public String getUserProfileValue(String username, String key) {
        return "";
    }

    @Override
    public String[] getTargetUrlParameters() {
        return new String[]{"os_destination"};
    }

    @Override
    public boolean doesUserHaveApplicationLicense(String username) {
        return true;
    }

    @Override
    public boolean shouldUseLegacyLoginExperience() {
        try {
            String authenticationLegacyModeProperty = System.getProperty("atlassian.authentication.legacy.mode");
            if (StringUtils.isNotBlank((CharSequence)authenticationLegacyModeProperty)) {
                return Boolean.parseBoolean(authenticationLegacyModeProperty);
            }
            return this.isLegacyLoginPageDefaultOnCurrentApplicationVersion();
        }
        catch (Exception e) {
            return this.isLegacyLoginPageDefaultOnCurrentApplicationVersion();
        }
    }

    @Override
    public boolean shouldIncludeContextPathInWebResource() {
        return true;
    }

    @Override
    public boolean shouldDoKerberosForURL(HttpServletRequestFacade req) {
        return true;
    }

    @Override
    public boolean shouldAvoidKerberosDueToLogout(HttpServletRequestFacade req) {
        return false;
    }

    @Override
    public String getTargetAfterRedirect(HttpServletRequestFacade request) {
        String baseUrl = HttpUrlUtils.getRequestBaseUrl((HttpServletRequestFacade)request);
        String target = TargetParameterUtils.getInstance(this, this.kerbConfManager).extractTargetParameter(request.getQueryString());
        if (StringUtils.isBlank((CharSequence)target)) {
            return "";
        }
        if (target.startsWith(baseUrl)) {
            return target;
        }
        return baseUrl + "/" + target;
    }

    @Override
    public boolean shouldCacheBodyRequest(HttpServletRequestFacade req) {
        return !this.isLegacyLoginPageDefaultOnCurrentApplicationVersion() && this.isLoginRequest(req);
    }
}

