/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.cache.UsernameMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KerberosUserLookupFromFileCache {
    private static final String CACHE_KEY = "kerberosUserLookupFromFileCache";
    private final Cache<String, String> kerberosUserLookupFromFileCache;
    private static final Logger log = LoggerFactory.getLogger(KerberosUserLookupFromFileCache.class);
    public static final String MAPPING_FILE_NAME = "kerberosUsernameLookupFromFile.json";

    @Inject
    public KerberosUserLookupFromFileCache(@ComponentImport CacheManager cacheManager) {
        this.kerberosUserLookupFromFileCache = cacheManager.getCache(CACHE_KEY, null, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaCopy().expireAfterWrite(30L, TimeUnit.DAYS).build());
    }

    public void removeElements(Collection<String> keysToRemove) {
        for (String key : keysToRemove) {
            this.kerberosUserLookupFromFileCache.remove((Object)key);
        }
    }

    public void put(UsernameMapping usernameMapping) {
        this.kerberosUserLookupFromFileCache.put((Object)usernameMapping.getKerberosUsername(), (Object)usernameMapping.getAtlassianUsername());
    }

    public String lookupUsername(String kerberosUsername) {
        return (String)this.kerberosUserLookupFromFileCache.get((Object)kerberosUsername);
    }

    public void tryReadCacheFile(File homeFolder) {
        File mappingFile = new File(homeFolder, MAPPING_FILE_NAME);
        try {
            if (mappingFile.exists()) {
                log.debug("Reading cache file: " + mappingFile.getAbsolutePath());
                JSONArray jsonArray = KerberosUserLookupFromFileCache.readJsonFile(mappingFile);
                ArrayList<String> existingKeys = new ArrayList<String>(this.kerberosUserLookupFromFileCache.getKeys());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String kerberosUsername = jsonObject.getString("kerberosUsername");
                    String atlassianUsername = jsonObject.getString("atlassianUsername");
                    UsernameMapping usernameMapping = new UsernameMapping(kerberosUsername, atlassianUsername);
                    this.put(usernameMapping);
                    existingKeys.remove(kerberosUsername);
                }
                this.removeElements(existingKeys);
                log.debug("Reading mapping file done. Removing # of keys: " + existingKeys.size());
            } else {
                log.debug("Mapping file has not been created yet: " + mappingFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error("Error reading mapping file", (Throwable)e);
            throw new RuntimeException("Error reading mapping file", e);
        }
    }

    private static JSONArray readJsonFile(File file) throws IOException {
        StringBuilder jsonContent = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                jsonContent.append(line);
            }
        }
        return new JSONArray(jsonContent.toString());
    }
}

