/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.azure.AzureGraphHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureAdBatchHandler {
    private static final Logger log = LoggerFactory.getLogger(AzureAdBatchHandler.class);
    private static final int BATCH_SIZE = Integer.getInteger("connector.azure.batch.size", 20);
    private final List<BatchRequest> registeredRequests = new ArrayList<BatchRequest>();
    private final String baseUrl;
    private final AzureGraphHttpClient client;
    private Map<String, String> clientReferenceMap;
    private Map<String, List<JSONArray>> partialResponses;

    AzureAdBatchHandler(String baseUrl, AzureGraphHttpClient client) {
        this.baseUrl = baseUrl;
        this.client = client;
    }

    public abstract void onSuccess(String var1, JSONArray var2);

    public abstract void onError(String var1, int var2, JSONObject var3);

    void registerRequest(String clientRequestReference, String url) {
        BatchRequest br = new BatchRequest(clientRequestReference, url);
        this.registeredRequests.add(br);
    }

    private void reset() {
        this.clientReferenceMap = new HashMap<String, String>();
        this.partialResponses = new HashMap<String, List<JSONArray>>();
        this.registeredRequests.forEach(br -> this.clientReferenceMap.put(br.getRequestId(), br.getClientRequestReferenceId()));
    }

    void run() throws InterruptedException {
        this.reset();
        log.debug("Starting batch queue of {} requests, batch size is {}", (Object)this.registeredRequests.size(), (Object)BATCH_SIZE);
        ArrayDeque<BatchRequest> queue = new ArrayDeque<BatchRequest>(this.registeredRequests);
        while (!queue.isEmpty()) {
            List<BatchRequest> enqueued = this.take(queue, BATCH_SIZE);
            String nextBatchLink = null;
            do {
                ConnectorHttpClient.Response resp;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("AAD Batch interrupted");
                }
                if (nextBatchLink == null) {
                    JSONObject postBody = AzureAdBatchHandler.createJsonPostBody(enqueued);
                    ConnectorHttpClient.JsonPostRequest req = new ConnectorHttpClient.JsonPostRequest(String.format("%s/v1.0/$batch", this.baseUrl), postBody);
                    resp = this.client.httpPost(req);
                } else {
                    log.info("Getting next partial batch: {}", nextBatchLink);
                    resp = this.client.httpGet(nextBatchLink);
                }
                JSONObject top = resp.getAsJSONObject();
                JSONArray responses = top.getJSONArray("responses");
                if (log.isTraceEnabled()) {
                    log.trace("Batch response: {}", (Object)top);
                }
                ArrayList<BatchRequest> incomplete = new ArrayList<BatchRequest>();
                for (Object o : responses) {
                    JSONObject response = (JSONObject)o;
                    int status = response.getInt("status");
                    String id = response.getString("id");
                    String clientReferenceId = this.clientReferenceMap.get(id);
                    if (status != 200) {
                        this.onError(clientReferenceId, status, response);
                        continue;
                    }
                    String oDataNextLink = "";
                    JSONArray values = new JSONArray();
                    boolean isHandlingImage = false;
                    try {
                        JSONObject body = response.getJSONObject("body");
                        oDataNextLink = body.optString("@odata.nextLink");
                        values = (JSONArray)body.get("value");
                        nextBatchLink = top.optString("nextLink");
                    }
                    catch (JSONException e) {
                        isHandlingImage = true;
                    }
                    if (StringUtils.isNotBlank((CharSequence)oDataNextLink)) {
                        log.debug("Request {} (clientReference {}) has additional pages: Queuing batch for: {}", new Object[]{id, clientReferenceId, oDataNextLink});
                        String relativeUrl = this.toRelativeUrl(oDataNextLink);
                        BatchRequest nextReq = new BatchRequest(clientReferenceId, relativeUrl);
                        incomplete.add(nextReq);
                        this.clientReferenceMap.put(nextReq.getRequestId(), clientReferenceId);
                        this.partialResponses.computeIfAbsent(clientReferenceId, k -> new ArrayList()).add(values);
                        continue;
                    }
                    if (isHandlingImage) {
                        JSONArray result = new JSONArray();
                        result.put((Object)response.getString("body"));
                        result.put((Object)response.getJSONObject("headers").get("Content-Type").toString().split("/")[1]);
                        this.onSuccess(clientReferenceId, result);
                        continue;
                    }
                    JSONArray merged = new JSONArray();
                    this.combineJsonArrays(merged, values);
                    Optional.ofNullable(this.partialResponses.remove(clientReferenceId)).ifPresent(fragments -> fragments.forEach(ff -> this.combineJsonArrays(merged, (JSONArray)ff)));
                    this.onSuccess(clientReferenceId, merged);
                }
                int totalCount = enqueued.size();
                int incompleteCount = incomplete.size();
                int completedCount = totalCount - incompleteCount;
                incomplete.forEach(queue::addFirst);
                log.debug("{} of {} requests done, {} incomplete added to head of next batch, new queue size: {}", new Object[]{completedCount, totalCount, incompleteCount, queue.size()});
            } while (StringUtils.isNotBlank(nextBatchLink));
        }
    }

    private List<BatchRequest> take(Deque<BatchRequest> queue, int n) {
        ArrayList<BatchRequest> result = new ArrayList<BatchRequest>();
        for (int i = 0; i < BATCH_SIZE && !queue.isEmpty(); ++i) {
            result.add(queue.pop());
        }
        return result;
    }

    private void combineJsonArrays(JSONArray target, JSONArray source) {
        source.forEach(arg_0 -> ((JSONArray)target).put(arg_0));
    }

    private String toRelativeUrl(String url) {
        return StringUtils.substringAfter((String)url, (String)"/v1.0/");
    }

    private static JSONObject createJsonPostBody(List<BatchRequest> requests) {
        try {
            ArrayList<JSONObject> jsonReqs = new ArrayList<JSONObject>();
            for (BatchRequest req : requests) {
                JSONObject jsonReq = new JSONObject();
                jsonReq.put("id", (Object)req.getRequestId());
                jsonReq.put("method", (Object)"GET");
                jsonReq.put("url", (Object)req.getUrl());
                jsonReqs.add(jsonReq);
            }
            JSONObject obj = new JSONObject();
            obj.put("requests", jsonReqs);
            return obj;
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to create JSON batch request", e);
        }
    }

    private static final class BatchRequest {
        private final String clientRequestReferenceId;
        private final String url;
        private final String requestId;

        BatchRequest(String clientRequestReference, String url) {
            this.clientRequestReferenceId = clientRequestReference;
            this.url = url;
            this.requestId = UUID.randomUUID().toString();
        }

        String getClientRequestReferenceId() {
            return this.clientRequestReferenceId;
        }

        public String getUrl() {
            return this.url;
        }

        String getRequestId() {
            return this.requestId;
        }
    }
}

