/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.OverridingServletOutputStreamFacade;
import com.kantegasso.servlet.ServletOutputStreamFacade;
import com.kantegasso.servlet.WriteListenerFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.ServiceDeskSignupFilter;
import org.kantega.atlaskerb.saml.SsoScriptLoginHookUrlReadingCondition;
import org.kantega.atlaskerb.saml.util.ScriptInjector;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;
import org.kantega.atlaskerb.wrapper.webresource.WebResourceManagerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ServiceDeskLoginFilter
extends FilterFacade {
    private final HttpContext httpContext;
    private final TemplateRenderer templateRenderer;
    private final SsoScriptLoginHookUrlReadingCondition SsoScriptLoginHookCondition;
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ScriptInjector scriptInjector;
    private final UserLookupService userLookupService;

    @Inject
    public ServiceDeskLoginFilter(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport HttpContext httpContext, WebResourceManagerWrapper webResourceManager, HostAppFactory hostAppFactory, IdpConfManager idpConfManager, SsoScriptLoginHookUrlReadingCondition ssoScriptLoginHookUrlReadingCondition, RequireAdminServletDependencyBucket bucket) {
        this.httpContext = httpContext;
        this.hostApp = hostAppFactory.getInstance();
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = idpConfManager;
        this.userLookupService = bucket.getUserLookupService();
        this.SsoScriptLoginHookCondition = ssoScriptLoginHookUrlReadingCondition;
        this.scriptInjector = new ScriptInjector(webResourceManager, templateRenderer, this.kerbConfManager, idpConfManager, hostAppFactory, bucket);
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
    }

    public void doFilterKsso(final HttpServletRequestFacade req, final HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        boolean enableFederatedSSO;
        final String emailFromHeader = ServiceDeskSignupFilter.getEmailFromHeader(req, this.kerbConfManager);
        final String jsmSignupEmailUnblockedList = this.kerbConfManager.getJsmSignupEmailUnblockedList();
        final String jsmUrlFormUrlparts = this.kerbConfManager.getJsmSignupFormUrlparts();
        boolean bl = enableFederatedSSO = this.SsoScriptLoginHookCondition.shouldDoFederatedSSO(req) && this.idpConfManager.isLoginEnabledForJSM();
        if (TraditionalLoginUtils.isTraditionalLoginPreventedForAllUnlicensedUsers(this.kerbConfManager, this.userLookupService) || enableFederatedSSO) {
            chain.doFilterKsso(req, new HttpServletResponseFacade((HttpServletResponse)resp){
                ServletOutputStreamFacade out;
                PrintWriter pw;

                public ServletOutputStreamFacade getOutputStreamFacade() throws IOException {
                    if (this.out == null) {
                        ServiceDeskLoginFilter.this.log.debug("Setting up ServiceDeskLoginFilter. ServletOutputStream out == null");
                        this.out = new InjectingOutputStream(req, resp, ServiceDeskLoginFilter.this.hostApp.shouldLoginManually(req, resp), ServiceDeskLoginFilter.this.hostApp.shouldDisableRedirect(req), enableFederatedSSO, TraditionalLoginUtils.isTraditionalLoginPreventedForAllUsers(ServiceDeskLoginFilter.this.kerbConfManager, ServiceDeskLoginFilter.this.userLookupService), super.getOutputStreamFacade(), ServiceDeskLoginFilter.this.idpConfManager.getRedirectProgressDelay(), emailFromHeader, jsmSignupEmailUnblockedList, jsmUrlFormUrlparts);
                    }
                    return this.out;
                }

                public PrintWriter getWriter() throws IOException {
                    if (this.pw == null) {
                        ServiceDeskLoginFilter.this.log.debug("Setting up ServiceDeskLoginFilter. PrintWriter pw == null");
                        this.pw = new InjectingWriter(req, resp, ServiceDeskLoginFilter.this.hostApp.shouldLoginManually(req, resp), ServiceDeskLoginFilter.this.hostApp.shouldDisableRedirect(req), enableFederatedSSO, TraditionalLoginUtils.isTraditionalLoginPreventedForAllUnlicensedUsers(ServiceDeskLoginFilter.this.kerbConfManager, ServiceDeskLoginFilter.this.userLookupService), super.getWriter(), ServiceDeskLoginFilter.this.idpConfManager.getRedirectProgressDelay(), emailFromHeader, jsmSignupEmailUnblockedList, jsmUrlFormUrlparts);
                    }
                    return this.pw;
                }
            });
        } else if (StringUtils.isNotBlank((CharSequence)emailFromHeader) || StringUtils.isNotBlank((CharSequence)jsmSignupEmailUnblockedList)) {
            chain.doFilterKsso(req, new HttpServletResponseFacade((HttpServletResponse)resp){
                ServletOutputStreamFacade out;

                public ServletOutputStreamFacade getOutputStreamFacade() throws IOException {
                    if (this.out == null) {
                        ServiceDeskLoginFilter.this.log.debug("Setting up InjectingEmailOutputStream. ServletOutputStream out == null");
                        this.out = new InjectingEmailOutputStream(emailFromHeader, jsmSignupEmailUnblockedList, jsmUrlFormUrlparts, super.getOutputStreamFacade());
                    }
                    return this.out;
                }
            });
        } else {
            chain.doFilterKsso(req, resp);
        }
    }

    public void destroy() {
    }

    private class InjectingWriter
    extends PrintWriter {
        private final int samlRedirectDelay;
        private final boolean manualLogin;
        private final boolean shouldDisableRedirect;
        private final boolean enableSaml;
        private final boolean isTraditionalLoginDisabled;
        private final PrintWriter out;
        private final byte[] headStart;
        private final String emailFromHeader;
        private final String jsmSignupEmailUnblockedList;
        private final String jsmUrlFormUrlparts;
        private final HttpServletRequestFacade req;
        private final HttpServletResponseFacade resp;

        public InjectingWriter(HttpServletRequestFacade req, HttpServletResponseFacade resp, boolean manualLogin, boolean shouldDisableRedirect, boolean enableSaml, boolean isTraditionalLoginDisabled, PrintWriter writer, int samlRedirectDelay, String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts) {
            super(writer);
            this.req = req;
            this.resp = resp;
            this.manualLogin = manualLogin;
            this.shouldDisableRedirect = shouldDisableRedirect;
            this.enableSaml = enableSaml;
            this.isTraditionalLoginDisabled = isTraditionalLoginDisabled;
            this.out = writer;
            this.samlRedirectDelay = samlRedirectDelay;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
            this.emailFromHeader = emailFromHeader;
            this.jsmSignupEmailUnblockedList = jsmSignupEmailUnblockedList;
            this.jsmUrlFormUrlparts = jsmUrlFormUrlparts;
        }

        @Override
        public void write(@NotNull String s, int off, int len) {
            char[] buf = s.toCharArray();
            this.write(buf, off, len);
        }

        @Override
        public void write(@NotNull String s) {
            this.write(s, 0, s.length());
        }

        @Override
        public void write(char[] buf, int off, int len) {
            int head = this.findHeadStart(new String(buf).getBytes(StandardCharsets.UTF_8), off, len);
            if (head != -1) {
                super.write(buf, off, head - off + this.headStart.length);
                StringWriter inject = null;
                try {
                    inject = ServiceDeskLoginFilter.this.scriptInjector.prepareInjectScript(this.req, this.resp, this.isTraditionalLoginDisabled, this.enableSaml, this.manualLogin, this.shouldDisableRedirect, this.samlRedirectDelay, this.emailFromHeader, this.jsmSignupEmailUnblockedList, this.jsmUrlFormUrlparts);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                super.write(inject.toString().toCharArray());
                super.write(buf, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                super.write(buf, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void flush() {
            super.flush();
        }

        @Override
        public void close() {
            super.close();
        }
    }

    private class InjectingEmailOutputStream
    extends OverridingServletOutputStreamFacade {
        private final String emailFromHeader;
        private final String jsmSignupEmailUnblockedList;
        private final String jsmUrlFormUrlparts;
        private final ServletOutputStreamFacade out;
        private final byte[] headStart;

        public InjectingEmailOutputStream(String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts, ServletOutputStreamFacade outputStream) {
            super((ServletOutputStream)outputStream);
            this.emailFromHeader = emailFromHeader;
            this.jsmSignupEmailUnblockedList = jsmSignupEmailUnblockedList;
            this.jsmUrlFormUrlparts = jsmUrlFormUrlparts;
            this.out = outputStream;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
        }

        public void write(int b) throws IOException {
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int head = this.findHeadStart(b, off, len);
            if (head != -1) {
                super.write(b, off, head - off + this.headStart.length);
                StringWriter inject = new StringWriter();
                ServiceDeskLoginFilter.this.log.debug("Writing js changes. emailFromHeader: " + this.emailFromHeader);
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("emailFromHeader", this.emailFromHeader);
                model.put("jsmSignupEmailUnblockedList", this.jsmSignupEmailUnblockedList);
                model.put("jsmUrlFormUrlparts", this.jsmUrlFormUrlparts);
                try {
                    ServiceDeskLoginFilter.this.templateRenderer.render("templates/atlaskerb/jsm-signup-email.vm", model, (Writer)inject);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                super.write(inject.toString().getBytes(StandardCharsets.UTF_8));
                super.write(b, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                super.write(b, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }

        public boolean isReady() {
            return super.isReady();
        }
    }

    private class InjectingOutputStream
    extends OverridingServletOutputStreamFacade {
        private final int samlRedirectDelay;
        private final boolean manualLogin;
        private final boolean shouldDisableRedirect;
        private final boolean enableSaml;
        private final boolean isTraditionalLoginDisabled;
        private final byte[] headStart;
        private final String emailFromHeader;
        private final String jsmSignupEmailUnblockedList;
        private final String jsmUrlFormUrlparts;
        private final HttpServletRequestFacade req;
        private final HttpServletResponseFacade resp;

        public InjectingOutputStream(HttpServletRequestFacade req, HttpServletResponseFacade resp, boolean manualLogin, boolean shouldDisableRedirect, boolean enableSaml, boolean isTraditionalLoginDisabled, ServletOutputStreamFacade outputStream, int samlRedirectDelay, String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts) {
            super((ServletOutputStream)outputStream);
            this.req = req;
            this.resp = resp;
            this.manualLogin = manualLogin;
            this.shouldDisableRedirect = shouldDisableRedirect;
            this.enableSaml = enableSaml;
            this.isTraditionalLoginDisabled = isTraditionalLoginDisabled;
            this.samlRedirectDelay = samlRedirectDelay;
            this.emailFromHeader = emailFromHeader;
            this.jsmSignupEmailUnblockedList = jsmSignupEmailUnblockedList;
            this.jsmUrlFormUrlparts = jsmUrlFormUrlparts;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int head = this.findHeadStart(b, off, len);
            if (head != -1) {
                super.write(b, off, head - off + this.headStart.length);
                StringWriter inject = ServiceDeskLoginFilter.this.scriptInjector.prepareInjectScript(this.req, this.resp, this.isTraditionalLoginDisabled, this.enableSaml, this.manualLogin, this.shouldDisableRedirect, this.samlRedirectDelay, this.emailFromHeader, this.jsmSignupEmailUnblockedList, this.jsmUrlFormUrlparts);
                super.write(inject.toString().getBytes(StandardCharsets.UTF_8));
                super.write(b, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                super.write(b, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }

        public void print(String s) throws IOException {
            super.print(s);
        }

        public void print(boolean b) throws IOException {
            super.print(b);
        }

        public void print(char c) throws IOException {
            super.print(c);
        }

        public void print(int i) throws IOException {
            super.print(i);
        }

        public void print(long l) throws IOException {
            super.print(l);
        }

        public void print(float f) throws IOException {
            super.print(f);
        }

        public void print(double d) throws IOException {
            super.print(d);
        }

        public void println() throws IOException {
            super.println();
        }

        public void println(String s) throws IOException {
            super.println(s);
        }

        public void println(boolean b) throws IOException {
            super.println(b);
        }

        public void println(char c) throws IOException {
            super.println(c);
        }

        public void println(int i) throws IOException {
            super.println(i);
        }

        public void println(long l) throws IOException {
            super.println(l);
        }

        public void println(float f) throws IOException {
            super.println(f);
        }

        public void println(double d) throws IOException {
            super.println(d);
        }

        public boolean isReady() {
            return super.isReady();
        }

        public void setWriteListenerFacade(WriteListenerFacade writeListener) {
            super.setWriteListenerFacade(writeListener);
        }

        public void write(int b) throws IOException {
            super.write(b);
        }

        public void write(byte[] b) throws IOException {
            super.write(b);
        }

        public void flush() throws IOException {
            super.flush();
        }

        public void close() throws IOException {
            super.close();
        }
    }
}

