/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.userlookup;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.security.LdapSecurity;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserNameLookup {
    private static final Logger log = LoggerFactory.getLogger(UserNameLookup.class);
    private final Map<String, String> attributes;
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    public static final String KSSO_LDAP_PASSWORD = "ksso.ldapPassword";

    public UserNameLookup(Map<String, String> attributes, HostApp hostApp, KerbConfManager kerbConfManager) {
        this.attributes = attributes;
        this.hostApp = hostApp;
        this.kerbConfManager = kerbConfManager;
    }

    public String lookupUserNameFromSamAccountNameAtRealm(String principalName) {
        String username = principalName.substring(0, principalName.lastIndexOf("@"));
        String realm = principalName.substring(principalName.lastIndexOf("@") + 1);
        return this.lookupUsername("samAccountName", username, realm);
    }

    public String lookupUserNameFromUserPrincipalName(String value) {
        return this.lookupUsername("userPrincipalName", value, null);
    }

    public String lookupUserNameFromAttribute(String attributeName, String value) {
        return this.lookupUsername(attributeName, value, null);
    }

    private String lookupUsername(final String searchAttribute, final String searchValue, String realm) {
        String ldapUrl = this.attributes.get("ldap.url");
        String ldapUserDn = this.attributes.get("ldap.userdn");
        String ldapPassword = this.hostApp.optionallyDecryptLdapPassword(this.attributes.get("ldap.password"), this.attributes.get(KSSO_LDAP_PASSWORD));
        String ldapBaseDn = this.attributes.get("ldap.basedn");
        String ldapUserBaseDn = this.attributes.get("ldap.user.dn");
        String ldapUserNameAttribute = this.attributes.get("ldap.user.username");
        String ldapFollowReferral = this.attributes.get("ldap.referral");
        if (ldapUrl == null || ldapUserDn == null || ldapPassword == null || ldapBaseDn == null) {
            return null;
        }
        final String searchBase = StringUtils.isNotBlank((CharSequence)ldapUserBaseDn) ? String.format("%s,%s", ldapUserBaseDn, ldapBaseDn) : ldapBaseDn;
        Option<String> escapedSearchBase = LdapSecurity.escapeDistinguishedNameValues(searchBase);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.principal", ldapUserDn);
        env.put("java.naming.security.credentials", ldapPassword);
        if ("true".equals(ldapFollowReferral)) {
            env.put("java.naming.referral", "follow");
        }
        String logDetails = "searchAttribute='" + searchAttribute + "', searchValue='" + searchValue + "', domainDn='" + realm + "'";
        if (StringUtils.isNotBlank((CharSequence)realm) && !UserLookupService.isRealmMatchesLdapName(realm, ldapBaseDn, searchBase)) {
            log.debug("Skipping lookup for '{}': Doesn't match KrbTicket domain/dn '{}'", (Object)ldapBaseDn, (Object)realm);
            return null;
        }
        final SearchControls ldapSearchControls = new SearchControls();
        ldapSearchControls.setSearchScope(2);
        ldapSearchControls.setReturningAttributes(new String[]{searchAttribute, ldapUserNameAttribute});
        Try maybeContext = Try.of((CheckedFunction0 & Serializable)() -> this.createContext(env));
        return (String)maybeContext.flatMapTry((CheckedFunction1 & Serializable)context -> {
            if (this.kerbConfManager.isLdapFilterEncoding()) {
                log.debug("Running LDAP lookupUsername WITH filter encoding");
                return LdapSecurity.encodeFilter("({0}={1})", searchAttribute, searchValue).mapTry((CheckedFunction1)new CheckedFunction1<String, NamingEnumeration<SearchResult>>(){

                    public NamingEnumeration<SearchResult> apply(String encodedFilter) throws Throwable {
                        return context.search(searchBase, encodedFilter, ldapSearchControls);
                    }
                });
            }
            log.debug("Filter encoding turned off. Running LDAP lookupUsername WITHOUT filter encoding");
            return Try.of((CheckedFunction0)new CheckedFunction0<NamingEnumeration<SearchResult>>(){

                public NamingEnumeration<SearchResult> apply() throws Throwable {
                    return context.search(searchBase, String.format("(%s=%s)", searchAttribute, searchValue), ldapSearchControls);
                }
            });
        }).mapTry((CheckedFunction1 & Serializable)answer -> this.fetchAttributeFromLdapSearchResult(ldapUserNameAttribute, (NamingEnumeration<SearchResult>)answer)).onFailure(NamingException.class, e -> SanitizedLogStatement.of(logDetails).andThenLog(details -> log.warn("NamingException during user lookup, using search params {}", details, e))).onFailure(e -> SanitizedLogStatement.of(logDetails).andThenLog(details -> log.debug("No user found, using search params " + details, e))).andFinallyTry(() -> maybeContext.andThenTry(Context::close)).getOrNull();
    }

    private String fetchAttributeFromLdapSearchResult(String ldapUsernameAttribute, NamingEnumeration<SearchResult> answer) throws NamingException {
        while (answer.hasMoreElements()) {
            SearchResult next = answer.next();
            Attribute userNameAttr = next.getAttributes().get(ldapUsernameAttribute);
            if (userNameAttr == null || userNameAttr.size() <= 0) continue;
            return (String)userNameAttr.get(0);
        }
        return null;
    }

    DirContext createContext(Hashtable<String, String> env) throws NamingException {
        return new InitialDirContext(env);
    }
}

