/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user;

import com.atlassian.sal.api.user.UserProfile;
import javax.ws.rs.core.Response;
import org.joda.time.LocalDateTime;
import org.json.JSONObject;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.utils.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTokenV1 {
    private static final Logger log = LoggerFactory.getLogger(CreateTokenV1.class);

    public static Response run(JSONObject json, UserProfile userProfile, ApiTokenService apiTokenService) {
        String name = json.optString("description", "api_token_" + String.valueOf(LocalDateTime.now()));
        String validForDays = json.optString("validForDays", "30");
        boolean isValidForever = json.optBoolean("isValidForever", false);
        Long validFor = (Long)DateTimeUtil.convertDaysToMillis((String)validForDays).map(milliseconds -> {
            if (isValidForever) {
                return -1L;
            }
            return milliseconds;
        }).getOrElse((Object)30L);
        return (Response)apiTokenService.createAndPersistTokenJson(userProfile, name, "", validFor).map(tokenJson -> Response.status((Response.Status)Response.Status.CREATED).entity((Object)tokenJson.toString(4)).build()).peekLeft(errorMessage -> log.error("Failed to create API token: " + errorMessage)).getOrElse((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
    }
}

