/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class ConfigureRequiredGroupsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ConfigureRequiredGroupsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("requiredGroups", StringUtils.join(this.kerbConfManager.getRequiredGroups(), (String)"\n"));
        model.put("SSOEnabledForUserAvatar", this.kerbConfManager.isSSOEnabledForUserAvatar());
        model.put("userdetailsInComments", this.kerbConfManager.isUserdetailsInCommentsEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/required-groups.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.kerbConfManager.setRequiredGroups(req.getParameter("requiredGroups"));
        this.kerbConfManager.setSSOEnabledForUserAvatar("on".equals(req.getParameter("SSOEnabledForUserAvatar")));
        this.kerbConfManager.setUserdetailsInCommentsEnabled("on".equals(req.getParameter("userdetailsInComments")));
        resp.sendRedirect("requiredgroups");
    }
}

