/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import io.vavr.CheckedFunction0;
import io.vavr.Value;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.io.Serializable;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.Bucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidationError;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidator;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SamlValidator
extends IdpValidator {
    private final HostApp hostApp;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public SamlValidator(Bucket bucket) {
        this.hostApp = bucket.getHostApp();
    }

    public Validation<Seq<IdpValidationError>, Try<IdpConfigurationBuilder.Saml>> validateAndCreateSamlConfig(JSONObject actionObject) {
        JSONObject samlConfigDraft = (JSONObject)Option.of((Object)actionObject.optJSONObject("idp")).getOrElse(JSONObject::new);
        String kind = samlConfigDraft.optString("kind", null);
        String name = samlConfigDraft.optString("display_name", null);
        String location = samlConfigDraft.optString("location", null);
        JSONArray signingCerts = samlConfigDraft.optJSONArray("certificates");
        String id = samlConfigDraft.optString("idp_id", null);
        String metadataUrl = samlConfigDraft.optString("metadata_url", null);
        String tlsFingerprint = samlConfigDraft.optString("tls_fingerprint", null);
        String metadataExportUrl = samlConfigDraft.optString("samlMetadataExportUrl", null);
        boolean metadataInputMethodIsUrl = StringUtils.equals((CharSequence)samlConfigDraft.optString("metadata_input_method", null), (CharSequence)"Url");
        String redirectPolicy = samlConfigDraft.optString("redirect_policy", IdpConfiguration.RedirectPolicy.NONE.name());
        io.vavr.collection.List validatedBuildStrategies = io.vavr.collection.List.of((Object)Validation.combine(this.validateIdpId(id), this.validateKind(kind), this.validateName(name), this.validateLocation(location), this.validateSigningCerts(signingCerts), this.validateMetadataUrl(metadataUrl, metadataInputMethodIsUrl), this.validateTlsFingerprint(tlsFingerprint, actionObject.optBoolean("cert_confirmed")), this.validateMetadataExportUrl(metadataExportUrl, IdpConfiguration.Kind.valueOf(kind))).ap(this::samlCreateWithExplicitData)).map(v -> {
            Validation<IdpValidationError, RedirectProperties> validatedRedirectProperties = this.validateRedirectPolicy(redirectPolicy);
            if (validatedRedirectProperties.isValid()) {
                return v.map(samlTry -> samlTry.map(saml -> (IdpConfigurationBuilder.Saml)saml.setRedirectProperties((RedirectProperties)validatedRedirectProperties.get())).map(saml -> (IdpConfigurationBuilder.Saml)saml.setJsmRedirectProperties((RedirectProperties)validatedRedirectProperties.get())));
            }
            return v.mapError(error -> error.append((Object)((IdpValidationError)((Object)((Object)((Object)validatedRedirectProperties.getError()))))));
        }).map(v -> v.map(oidcTry -> oidcTry.map(oidc -> (IdpConfigurationBuilder.Saml)oidc.setEnabled(samlConfigDraft.optBoolean("is_enabled", false)))));
        return (Validation)validatedBuildStrategies.filter(Validation::isValid).getOrElse((Object)Validation.invalid((Object)((Seq)validatedBuildStrategies.filter(Validation::isInvalid).map(Validation::getError).fold((Object)io.vavr.collection.List.empty(), Seq::appendAll)).append((Object)IdpValidationError.MISSING_VALUES).distinct()));
    }

    private Validation<IdpValidationError, String> validateMetadataUrl(String metadataUrl, boolean metadataInputMethodIsUrl) {
        if (!metadataInputMethodIsUrl) {
            return Validation.valid((Object)"");
        }
        return (Validation)Option.of((Object)metadataUrl).map(StringUtils::trim).filter(StringUtils::isNotBlank).transform(maybeMetadataUrl -> {
            if (maybeMetadataUrl.isEmpty()) {
                return Validation.valid((Object)"");
            }
            return Try.of((CheckedFunction0 & Serializable)() -> new URI((String)maybeMetadataUrl.get())).isSuccess() ? Validation.valid((Object)((String)maybeMetadataUrl.get())) : Validation.invalid((Object)((Object)IdpValidationError.SAML_METADATA_URL));
        });
    }

    private Validation<IdpValidationError, String> validateMetadataExportUrl(String metadataExportUrl, IdpConfiguration.Kind kind) {
        if (kind != IdpConfiguration.Kind.ADFS) {
            return Validation.valid((Object)"");
        }
        return (Validation)Option.of((Object)metadataExportUrl).map(StringUtils::trim).filter(StringUtils::isNotBlank).transform(maybeMetadataUrl -> {
            if (maybeMetadataUrl.isEmpty()) {
                return Validation.valid((Object)"");
            }
            return Validation.valid((Object)((String)maybeMetadataUrl.get()));
        });
    }

    private Validation<IdpValidationError, String> validateLocation(String location) {
        return (Validation)Option.of((Object)location).filter(StringUtils::isNotBlank).filter(loc -> Try.of((CheckedFunction0 & Serializable)() -> new URI(location)).isSuccess()).transform(maybeLocation -> maybeLocation.isDefined() ? Validation.valid((Object)((String)maybeLocation.get())) : Validation.invalid((Object)((Object)IdpValidationError.SAML_LOCATION)));
    }

    private Validation<IdpValidationError, List<byte[]>> validateSigningCerts(JSONArray signingCerts) {
        return (Validation)Option.of((Object)signingCerts).map(io.vavr.collection.List::ofAll).filter(Traversable::nonEmpty).map(certList -> certList.map(Object::toString).map(cert -> Base64.getDecoder().decode((String)cert))).map(Value::toJavaList).transform(maybeSigningCerts -> maybeSigningCerts.isDefined() ? Validation.valid((Object)((List)maybeSigningCerts.get())) : Validation.invalid((Object)((Object)IdpValidationError.SAML_CERTIFICATES)));
    }

    private Validation<IdpValidationError, String> validateTlsFingerprint(String tlsFingerprint, boolean isCertConfirmed) {
        if (!isCertConfirmed) {
            return Validation.valid((Object)"");
        }
        return (Validation)Option.of((Object)tlsFingerprint).filter(StringUtils::isNotBlank).transform(maybeTlsFingerprint -> maybeTlsFingerprint.isDefined() ? Validation.valid((Object)((String)maybeTlsFingerprint.get())) : Validation.invalid((Object)((Object)IdpValidationError.SAML_TLS_FINGERPRINT)));
    }

    private Try<IdpConfigurationBuilder.Saml> samlCreateWithExplicitData(String id, IdpConfiguration.Kind kind, String name, String location, List<byte[]> signingCerts, String metadataUrl, String tlsFingerprint, String metadataExportUrl) {
        return Try.of((CheckedFunction0 & Serializable)() -> (IdpConfigurationBuilder.Saml)((IdpConfigurationBuilder.Saml)((IdpConfigurationBuilder.Saml)IdpConfigurationBuilder.Saml.saml(id, kind).setName(name)).setIdpUrl(location).setSigningCerts(signingCerts).setMetadataURL(metadataUrl).setTlsFingerprint(tlsFingerprint)).setJitDirectoryIfPresent(this.hostApp.getDefaultJitDirectory()));
    }
}

