/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import com.atlassian.json.jsonorg.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.kantega.atlaskerb.connector.AbstractConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorIOUtil;
import org.kantega.atlaskerb.connector.azure.AzureGraphHttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureGraphHttpClient
extends AbstractConnectorHttpClient {
    private static final Logger log = LoggerFactory.getLogger(AzureGraphHttpClient.class);
    private final String applicationId;
    private final String clientSecret;
    private final String loginService;
    private int delayMillisAfterRateLimiting = 0;

    AzureGraphHttpClient(String loginBase, String tenantId, String applicationId, String clientSecret) {
        this.applicationId = applicationId;
        this.clientSecret = clientSecret;
        try {
            this.loginService = loginBase + "/" + URLEncoder.encode(tenantId, StandardCharsets.UTF_8.name()) + "/oauth2/v2.0/token";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static AzureGraphHttpClient createAzureGraphHttpClient(String loginBase, String tenantId, String applicationId, String clientSecret) {
        return AzureGraphHttpClientBuilder.createAzureGraphHttpClientBuilder().setLoginBase(loginBase).setTenantId(tenantId).setApplicationId(applicationId).setClientSecret(clientSecret).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ConnectorHttpClient.AuthContext createAuthContext() throws InterruptedException {
        try {
            log.debug("Connecting to {}", (Object)this.loginService);
            HttpURLConnection con = ConnectorIOUtil.openConnection(this.loginService);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setDoOutput(true);
            StringBuilder sb = new StringBuilder().append("client_id=").append(URLEncoder.encode(this.applicationId, StandardCharsets.UTF_8.name())).append("&scope=").append(URLEncoder.encode("https://graph.microsoft.com/.default", StandardCharsets.UTF_8.name())).append("&client_secret=").append(URLEncoder.encode(this.clientSecret, StandardCharsets.UTF_8.name())).append("&grant_type=").append(URLEncoder.encode("client_credentials", StandardCharsets.UTF_8.name()));
            try (OutputStream outputStream = con.getOutputStream();){
                IOUtils.write((String)sb.toString(), (OutputStream)outputStream, (String)StandardCharsets.UTF_8.name());
            }
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                this.throwJsonException(con);
                return null;
            }
            try (InputStream inputStream = con.getInputStream();){
                JSONObject tokenJson = new JSONObject(ConnectorIOUtil.toString(inputStream, StandardCharsets.UTF_8.name()));
                inputStream.close();
                String accessToken = tokenJson.getString("access_token");
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", "Bearer " + accessToken);
                headers.put("Accept", "application/json");
                ConnectorHttpClient.AuthContext authContext = new ConnectorHttpClient.AuthContext(headers);
                return authContext;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isRateLimitExceeded(HttpURLConnection conn) throws IOException {
        return conn.getResponseCode() == 429;
    }

    @Override
    protected void waitForRateLimit(HttpURLConnection conn) throws InterruptedException {
        int retryAfter = Integer.parseInt(conn.getHeaderField("Retry-After"));
        log.warn("Entra ID rate limit exceeded {} ms", (Object)retryAfter);
        Thread.sleep((long)retryAfter * 1000L);
        this.delayMillisAfterRateLimiting = 40;
    }

    @Override
    protected void sleepToAvoidFutureRateLimit() {
        if (this.delayMillisAfterRateLimiting == 0) {
            return;
        }
        if (this.delayMillisAfterRateLimiting > 5) {
            --this.delayMillisAfterRateLimiting;
        }
        try {
            Thread.sleep(this.delayMillisAfterRateLimiting);
        }
        catch (Exception e) {
            log.error("Interrupted while sleeping", (Throwable)e);
            this.delayMillisAfterRateLimiting = 0;
        }
    }

    public String getClientSecret() {
        return this.clientSecret;
    }
}

