/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.directory.Attribute;
import org.kantega.atlaskerb.kerberos.keytab.EncryptionType;

public class LdapTestResult {
    private final Set<String> servicePrincipalAliases = new TreeSet<String>();
    private final Map<String, Attribute> additionalAttributes = new HashMap<String, Attribute>();
    private final Map<LdapTestResult, Boolean> passwordReplicationDenials = new HashMap<LdapTestResult, Boolean>();
    private final SortedSet<Object> unreadableAttributes = new TreeSet<Object>();
    private String servicePrincipalName;
    private String dn;
    private String servicePrincipalUsername;
    private boolean accountDisabled;
    private boolean accountPasswordNeverExpires;
    private boolean accountPasswordHasExpired;
    private boolean accountDesOnly;
    private Integer ldapKeyVersionNumber;
    private boolean supportedEnctypeDefault;
    private List<EncryptionType> supportedEncryptionTypes = new ArrayList<EncryptionType>();
    private String userPrincipalName;

    public SortedSet<Object> getUnreadableAttributes() {
        return this.unreadableAttributes;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getServicePrincipalUsername() {
        return this.servicePrincipalUsername;
    }

    public void setServicePrincipalUsername(String servicePrincipalUsername) {
        this.servicePrincipalUsername = servicePrincipalUsername;
    }

    public boolean isAccountDisabled() {
        return this.accountDisabled;
    }

    public void setAccountDisabled(boolean accountDisabled) {
        this.accountDisabled = accountDisabled;
    }

    public boolean isAccountPasswordNeverExpires() {
        return this.accountPasswordNeverExpires;
    }

    public void setAccountPasswordNeverExpires(boolean accountPasswordNeverExpires) {
        this.accountPasswordNeverExpires = accountPasswordNeverExpires;
    }

    public boolean isAccountPasswordHasExpired() {
        return this.accountPasswordHasExpired;
    }

    public void setAccountPasswordHasExpired(boolean accountPasswordHasExpired) {
        this.accountPasswordHasExpired = accountPasswordHasExpired;
    }

    public boolean isAccountDesOnly() {
        return this.accountDesOnly;
    }

    public void setAccountDesOnly(boolean accountDesOnly) {
        this.accountDesOnly = accountDesOnly;
    }

    public Integer getLdapKeyVersionNumber() {
        return this.ldapKeyVersionNumber;
    }

    public void setLdapKeyVersionNumber(Integer ldapKeyVersionNumber) {
        this.ldapKeyVersionNumber = ldapKeyVersionNumber;
    }

    public boolean isSupportedEnctypeDefault() {
        return this.supportedEnctypeDefault;
    }

    public void setSupportedEnctypeDefault(boolean supportedEnctypeDefault) {
        this.supportedEnctypeDefault = supportedEnctypeDefault;
    }

    public List<EncryptionType> getSupportedEncryptionTypes() {
        return this.supportedEncryptionTypes;
    }

    public void setSupportedEncryptionTypes(List<EncryptionType> supportedEncryptionTypes) {
        this.supportedEncryptionTypes = supportedEncryptionTypes;
    }

    public void addServicePrincipalAlias(String name) {
        this.servicePrincipalAliases.add(name);
    }

    public Set<String> getServicePrincipalAliases() {
        return this.servicePrincipalAliases;
    }

    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public void setUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
    }

    public boolean isEncryptionTypeSupported(String encryptionType) {
        for (EncryptionType type : this.getSupportedEncryptionTypes()) {
            if (!type.getKtpassName().equalsIgnoreCase(encryptionType)) continue;
            return true;
        }
        return false;
    }

    public EncryptionType getStrongestEncryptionType() {
        EncryptionType aes256 = EncryptionType.byEncType(18);
        EncryptionType aes128 = EncryptionType.byEncType(17);
        for (EncryptionType type : Arrays.asList(aes256, aes128)) {
            if (!this.isEncryptionTypeSupported(type.getKtpassName())) continue;
            return type;
        }
        return EncryptionType.byEncType(23);
    }

    public String getHumanReadableLocation() {
        String location = this.dn.substring(this.dn.indexOf(",") + 1);
        return location.replace(",", ", ");
    }

    public void addAttribute(String additionalAttribute, Attribute attribute) {
        this.additionalAttributes.put(additionalAttribute, attribute);
    }

    public Map<String, Attribute> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public void passwordReplicatonDenied(LdapTestResult controller, boolean explicit) {
        this.passwordReplicationDenials.put(controller, explicit);
    }

    public Map<LdapTestResult, Boolean> getPasswordReplicationDenials() {
        return this.passwordReplicationDenials;
    }

    public void addUnreadableAttribute(String attributename) {
        this.unreadableAttributes.add(attributename);
    }
}

