/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.Tuple;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.RequireLoggedInUserServlet;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.kantega.atlaskerb.pagination.Paginator;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.UserManagerUtils;

public class ApiTokenUserServlet
extends RequireLoggedInUserServlet {
    private final ApiTokenService apiTokenService;
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;

    @Inject
    public ApiTokenUserServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket.getUserManager(), bucket.getLoginUriProvider());
        this.apiTokenService = apiTokenService;
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.userLookupService = bucket.getUserLookupService();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (HttpUrlUtils.isSystemAdmin((UserManager)this.userManager, (HttpServletRequestFacade)req)) {
            resp.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart() + "/api-tokens");
            return;
        }
        Map<String, Object> model = this.buildModel(req);
        model.put("isInReadOnlyMode", this.apiTokenService.isProductInReadOnlyMode());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-user.vm", model, (Writer)resp.getWriter());
    }

    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (this.apiTokenService.isProductInReadOnlyMode()) {
            resp.sendError(403, "API tokens are disabled in read-only mode");
            return;
        }
        HashMap<String, Object> protoModel = new HashMap<String, Object>();
        if ("delete".equals(req.getParameter("operation"))) {
            Option.of((Object)((ApiTokenV570)Tuple.of((Object)((String)Option.of((Object)req.getParameter("tokenId")).getOrElse((Object)"")), (Object)((String)UserManagerUtils.extractUsername((UserProfile)this.userManager.getRemoteUser((HttpServletRequest)req)).getOrElse((Object)""))).apply(this.apiTokenService::findTokenByIdAndUsername))).forEach(this.apiTokenService::delete);
            this.buildModelAndRenderTemplate(req, resp, protoModel);
        } else {
            Option<String> maybeToken = this.apiTokenService.createAndPersistToken(req);
            if (maybeToken.isDefined()) {
                protoModel.put("newApiToken", maybeToken.get());
            }
            this.buildModelAndRenderTemplate(req, resp, protoModel);
        }
    }

    private void buildModelAndRenderTemplate(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> protoModel) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-user.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequestFacade req) {
        Map<String, Object> model = this.newModel(req);
        model.put("displayName", this.applicationProperties.getDisplayName());
        Option maybeUsername = UserManagerUtils.extractUsername((UserProfile)this.userManager.getRemoteUser((HttpServletRequest)req));
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        boolean userApiTokenEnabled = false;
        if (this.kerbConfManager.getApiTokenUserPermission() == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
            Long maximumTokenDuration = this.apiTokenService.userGroupMaximumTimeRestriction((String)maybeUsername.get());
            if (maximumTokenDuration != 0L) {
                userApiTokenEnabled = true;
            }
            model.put("durationOptions", ApiTokenUtil.DatePair.getDurationOptionsRestricted(maximumTokenDuration));
            model.putIfAbsent("maximumTokenDuration", ApiTokenUtil.Time.convertMillisToDays(maximumTokenDuration));
            model.putIfAbsent("maximumTokenDurationMillis", maximumTokenDuration);
        } else if (this.kerbConfManager.getApiTokenUserPermission() == ApiTokenUtil.TokenUserPermission.ALL_USERS) {
            userApiTokenEnabled = true;
        }
        model.put("isUserApiTokenEnabled", userApiTokenEnabled);
        model.put("username", maybeUsername.getOrNull());
        List<ApiTokenUtil.ApiTokenRepresentation> tokens = this.getTokensRepresentation(req);
        model.put("isEmptyTokens", tokens.isEmpty());
        List<ApiTokenUtil.ApiTokenRepresentation> tokensFiltered = this.getFilteredTokens(req, model, tokens);
        Paginator<ApiTokenUtil.ApiTokenRepresentation> paginator = new Paginator<ApiTokenUtil.ApiTokenRepresentation>();
        Map<String, Object> paginationMap = paginator.handlePagination(req, tokensFiltered);
        model.putAll(paginationMap);
        long maximumTokenDuration = this.kerbConfManager.getApiTokensUserMaxTimeRestriction();
        model.putIfAbsent("durationOptions", ApiTokenUtil.DatePair.getDurationOptionsRestricted(maximumTokenDuration));
        model.putIfAbsent("maximumTokenDuration", ApiTokenUtil.Time.convertMillisToDays(maximumTokenDuration));
        model.putIfAbsent("maximumTokenDurationMillis", maximumTokenDuration);
        return model;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getFilteredTokens(HttpServletRequestFacade req, Map<String, Object> model, List<ApiTokenUtil.ApiTokenRepresentation> tokens) {
        boolean filterTokenName;
        ArrayList<ApiTokenUtil.ApiTokenRepresentation> filteredTokens = new ArrayList<ApiTokenUtil.ApiTokenRepresentation>();
        boolean filterExpiredTokens = req.getParameter("tokenActiveFilter") != null && req.getParameter("tokenActiveFilter").equals("true");
        boolean filterNonExpiredTokens = req.getParameter("tokenActiveFilter") != null && req.getParameter("tokenActiveFilter").equals("false");
        boolean bl = filterTokenName = req.getParameter("tokenNameFilter") != null && !req.getParameter("tokenNameFilter").isEmpty();
        if (filterExpiredTokens) {
            model.put("tokenActiveFilter", true);
        }
        if (filterNonExpiredTokens) {
            model.put("tokenActiveFilter", false);
        }
        if (filterTokenName) {
            model.put("tokenNameFilter", req.getParameter("tokenNameFilter"));
        }
        if (!(filterExpiredTokens || filterNonExpiredTokens || filterTokenName)) {
            filteredTokens.addAll(tokens);
        } else {
            String tokenNameParam = req.getParameter("tokenNameFilter");
            for (ApiTokenUtil.ApiTokenRepresentation token : tokens) {
                boolean matchesTokenName;
                boolean isExpired = token.isExpired();
                boolean bl2 = matchesTokenName = tokenNameParam != null && token.getAlias().toUpperCase().contains(tokenNameParam.toUpperCase());
                if (filterExpiredTokens && isExpired || filterNonExpiredTokens && !isExpired || filterTokenName && !matchesTokenName) continue;
                filteredTokens.add(token);
            }
        }
        return filteredTokens;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation(HttpServletRequestFacade req) {
        return ((io.vavr.collection.List)UserManagerUtils.extractUsername((UserProfile)this.userManager.getRemoteUser((HttpServletRequest)req)).map(this.apiTokenService::findTokensByUsername).map(io.vavr.collection.List::ofAll).getOrElse((Object)io.vavr.collection.List.empty())).map(apiToken -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenV570)apiToken, this.userManager, this.apiTokenService)).asJava();
    }
}

