/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.pagination;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Paginator<T> {
    private List<Integer> rowsPerPageOptions = Arrays.asList(10, 20, 50, 100, 10000);
    private int defaultRowsPerPage = 20;

    public Paginator() {
    }

    public Paginator(int defaultRowsPerPage, List<Integer> rowsPerPageOptions) {
        this.defaultRowsPerPage = defaultRowsPerPage;
        this.rowsPerPageOptions = rowsPerPageOptions;
    }

    public Map<String, Object> handlePagination(HttpServletRequestFacade req, List<T> filteredElements) {
        int parsedRowsPerPage;
        HashMap<String, Object> model = new HashMap<String, Object>();
        int numberOfElements = filteredElements.size();
        model.put("numberOfElements", numberOfElements);
        int rowsPerPage = req.getParameter("rowsPerPage") != null && this.rowsPerPageOptions.contains(Integer.parseInt(req.getParameter("rowsPerPage"))) ? ((parsedRowsPerPage = Integer.parseInt(req.getParameter("rowsPerPage"))) == 10000 ? numberOfElements : parsedRowsPerPage) : this.defaultRowsPerPage;
        model.put("rowsPerPage", rowsPerPage);
        int numberOfPages = numberOfElements / rowsPerPage + (numberOfElements % rowsPerPage > 0 ? 1 : 0);
        model.put("numberOfPages", numberOfPages);
        String currentPageStr = req.getParameter("currentPage");
        int currentPage = currentPageStr != null && Integer.parseInt(currentPageStr) <= numberOfPages ? Integer.parseInt(currentPageStr) : 1;
        model.put("currentPage", currentPage);
        int startToken = (currentPage - 1) * rowsPerPage;
        int endToken = Math.min(startToken + rowsPerPage, numberOfElements);
        model.put("filteredElements", filteredElements.subList(startToken, endToken));
        model.put("startElement", startToken + 1);
        model.put("endElement", endToken);
        model.put("showPagination", numberOfPages > 1);
        if (numberOfPages < 7) {
            model.put("showFirstTruncate", false);
            model.put("showLastTruncate", false);
            if (numberOfPages > 3) {
                model.put("start", 2);
                model.put("end", numberOfPages - 1);
            } else if (numberOfPages == 3) {
                model.put("start", 2);
                model.put("end", numberOfPages - 1);
                model.put("showNumber2", true);
            } else {
                model.put("start", 1);
                model.put("end", 1);
            }
        } else if (currentPage - 3 <= 1) {
            model.put("showFirstTruncate", false);
            model.put("showLastTruncate", true);
            model.put("start", 2);
            model.put("end", 5);
        } else if (currentPage + 3 >= numberOfPages) {
            model.put("showFirstTruncate", true);
            model.put("showLastTruncate", false);
            model.put("start", numberOfPages - 4);
            model.put("end", numberOfPages - 1);
        } else {
            model.put("showFirstTruncate", true);
            model.put("showLastTruncate", true);
            model.put("start", currentPage - 1);
            model.put("end", currentPage + 1);
        }
        if (currentPage - 1 > 0) {
            model.put("previousPage", currentPage - 1);
        }
        if (currentPage + 1 <= numberOfPages) {
            model.put("nextPage", currentPage + 1);
        }
        return model;
    }
}

